/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import java.util.ArrayList;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.cap.ComponentDescriptor;

public class ComponentMethod
extends CapComponent {
    public int tag;
    public int size;
    public ExceptionHandlerInfo[] exceptionHandlers;
    public ArrayList<MethodInfo> methods;

    public ComponentMethod(CapFile cap, String fullName, Binary b) {
        super(cap, 7, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        offs += 2;
        int handlerCount = b.get(offs++);
        this.exceptionHandlers = new ExceptionHandlerInfo[handlerCount];
        int i = 0;
        while (i < this.exceptionHandlers.length) {
            this.exceptionHandlers[i] = new ExceptionHandlerInfo();
            offs = this.exceptionHandlers[i].parse(b, offs);
            ++i;
        }
        this.methods = new ArrayList();
        while (offs < b.size()) {
            MethodInfo method = new MethodInfo();
            offs = method.parse(b, offs);
            this.methods.add(method);
        }
        Ex.MUST(this.tag == 7 && this.size == b.size() - 3 && offs == b.size(), "Wrong component Method");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.add(this.exceptionHandlers.length);
        ExceptionHandlerInfo[] exceptionHandlerInfoArray = this.exceptionHandlers;
        int n = this.exceptionHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionHandlerInfo ex = exceptionHandlerInfoArray[n2];
            ex.toBin(b);
            ++n2;
        }
        for (MethodInfo method : this.methods) {
            method.toBin(b);
        }
        return b;
    }

    public static class ExceptionHandlerInfo {
        int startOffset;
        int activeLength;
        int handlerOffset;
        int catchTypeIndex;

        protected int parse(Binary b, int offs) {
            this.startOffset = b.getU16(offs);
            this.activeLength = b.getU16(offs += 2);
            this.handlerOffset = b.getU16(offs += 2);
            this.catchTypeIndex = b.getU16(offs += 2);
            return offs += 2;
        }

        protected void toBin(Binary b) {
            b.addU16(this.startOffset);
            b.addU16(this.activeLength);
            b.addU16(this.handlerOffset);
            b.addU16(this.catchTypeIndex);
        }
    }

    public class MethodInfo {
        public static final byte ACC_EXTENDED = 8;
        public static final byte ACC_ABSTRACT = 4;
        public int flags;
        public int maxStack;
        public int nargs;
        public int maxLocals;
        public ComponentDescriptor.MethodDescriptorInfo methodDescr;
        public Binary bytecodes;
        public int bytecodesOffset;

        protected int parse(Binary b, int offs) {
            int methodOffset = offs - 3;
            int b0 = b.get(offs++);
            this.flags = b0 >> 4 & 0xF;
            if ((this.flags & 8) != 0) {
                this.maxStack = b.get(offs++);
                this.nargs = b.get(offs++);
                this.maxLocals = b.get(offs++);
            } else {
                this.maxStack = b0 & 0xF;
                int b1 = b.get(offs++);
                this.nargs = b1 >> 4 & 0xF;
                this.maxLocals = b1 & 0xF;
            }
            this.methodDescr = ((ComponentDescriptor)ComponentMethod.this.cap.getComp(11)).findMethod(methodOffset);
            Ex.MUST(this.methodDescr != null, "Wrong component Descriptor or Method. Method info not found");
            this.bytecodesOffset = offs - 3;
            this.bytecodes = b.slice(offs, this.methodDescr.bytecodeCount);
            return offs += this.methodDescr.bytecodeCount;
        }

        protected void toBin(Binary b) {
            if ((this.flags & 8) != 0) {
                b.add(this.flags << 4);
                b.add(this.maxStack);
                b.add(this.nargs);
                b.add(this.maxLocals);
            } else {
                b.add(this.flags << 4 | this.maxStack);
                b.add(this.nargs << 4 | this.maxLocals);
            }
            b.add(this.bytecodes);
        }
    }
}

