/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;

public class ComponentRefLocation
extends CapComponent {
    public int tag;
    public int size;
    public Binary offsetsTo1ByteIndexes;
    public Binary offsetsTo2ByteIndexes;

    public ComponentRefLocation(CapFile cap, String fullName, Binary b) {
        super(cap, 9, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        int count = b.getU16(offs += 2);
        this.offsetsTo1ByteIndexes = b.slice(offs += 2, count);
        offs += count;
        count = b.getU16(offs);
        this.offsetsTo2ByteIndexes = b.slice(offs += 2, count);
        Ex.MUST(this.tag == 9 && this.size == b.size() - 3 && (offs += count) == b.size(), "Wrong component ReferenceLocation");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.addU16(this.offsetsTo1ByteIndexes.size());
        b.add(this.offsetsTo1ByteIndexes);
        b.addU16(this.offsetsTo2ByteIndexes.size());
        b.add(this.offsetsTo2ByteIndexes);
        return b;
    }
}

