/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.cap;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.smartcard.cap.CapComponent;
import org.denom.smartcard.cap.CapFile;

public class ComponentStaticField
extends CapComponent {
    public int tag;
    public int size;
    public int imageSize;
    public int referenceCount;
    public ArrayInitInfo[] arrayInit;
    public int defaultValueCount;
    public Binary nonDefaultValues;

    public ComponentStaticField(CapFile cap, String fullName, Binary b) {
        super(cap, 8, fullName);
        int offs = 0;
        this.tag = b.get(offs++);
        this.size = b.getU16(offs);
        this.imageSize = b.getU16(offs += 2);
        this.referenceCount = b.getU16(offs += 2);
        int arrayInitCount = b.getU16(offs += 2);
        offs += 2;
        this.arrayInit = new ArrayInitInfo[arrayInitCount];
        int i = 0;
        while (i < this.arrayInit.length) {
            this.arrayInit[i] = new ArrayInitInfo();
            offs = this.arrayInit[i].parse(b, offs);
            ++i;
        }
        this.defaultValueCount = b.getU16(offs);
        int nonDefaultCount = b.getU16(offs += 2);
        this.nonDefaultValues = b.slice(offs += 2, nonDefaultCount);
        Ex.MUST(this.tag == 8 && this.size == b.size() - 3 && (offs += nonDefaultCount) == b.size(), "Wrong component StaticField");
    }

    @Override
    public Binary toBin() {
        Binary b = Binary.Bin().reserve(this.size + 3);
        b.add(this.tag);
        b.addU16(this.size);
        b.addU16(this.imageSize);
        b.addU16(this.referenceCount);
        b.addU16(this.arrayInit.length);
        ArrayInitInfo[] arrayInitInfoArray = this.arrayInit;
        int n = this.arrayInit.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayInitInfo elem = arrayInitInfoArray[n2];
            elem.toBin(b);
            ++n2;
        }
        b.addU16(this.defaultValueCount);
        b.addU16(this.nonDefaultValues.size());
        b.add(this.nonDefaultValues);
        return b;
    }

    public static class ArrayInitInfo {
        public int type;
        public Binary values;

        public int parse(Binary b, int offs) {
            this.type = b.get(offs++);
            int count = b.getU16(offs);
            this.values = b.slice(offs += 2, count);
            return offs += count;
        }

        public void toBin(Binary b) {
            b.add(this.type);
            b.addU16(this.values.size());
            b.add(this.values);
        }
    }
}

