/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.format.BerTLV;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CpsDataGroup;

public class ApduEmv {
    public static CApdu StoreData(int dgi, Binary dgiData, int sequenceNumber, boolean needEncryption, boolean isLastCmd) {
        Ex.MUST(Int.isU16(dgi), "DGI must be U16");
        Ex.MUST(Int.isU8(sequenceNumber), "sequenceNumber must be U8");
        int p1 = 0;
        if (needEncryption) {
            p1 |= 0x60;
        }
        if (isLastCmd) {
            p1 |= 0x80;
        }
        Binary dataField = new Binary().reserve(dgiData.size() + 5);
        dataField.addU16(dgi);
        if (dgiData.size() < 255) {
            dataField.add(dgiData.size());
        } else {
            dataField.add(255);
            dataField.addU16(dgiData.size());
        }
        dataField.add(dgiData);
        return new CApdu(128, 226, p1, sequenceNumber, dataField, 0, "{EMV CPS} STORE DATA");
    }

    public static CApdu StoreData(CpsDataGroup dg, int sequenceNumber, boolean isLastCmd) {
        return ApduEmv.StoreData(dg.dgi, dg.data, sequenceNumber, dg.needEncryption, isLastCmd);
    }

    public static CApdu GetProcessingOptions(Binary pdolValues) {
        CApdu ap = new CApdu(128, 168, 0, 0, BerTLV.Tlv(131, pdolValues), 256, "{EMV} GET PROCESSING OPTIONS");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu GenerateAC(int cryptogramType, Binary cdolRelData, boolean moreCommands) {
        int p2 = moreCommands ? 128 : 0;
        CApdu ap = new CApdu(128, 174, cryptogramType, p2, cdolRelData, 256, "{EMV} GENERATE AC");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu ReadData(int tag) {
        return new CApdu(132, 50, 0, 0, Binary.Bin().addU24(tag), 256, "{EMV} READ DATA");
    }

    public static CApdu WriteData(Binary encryptedTLV, boolean moreCommands) {
        int p2 = moreCommands ? 128 : 0;
        return new CApdu(132, 52, 0, p2, encryptedTLV, 256, "{EMV} WRITE DATA");
    }

    public static CApdu ExchangeRelayResistanceData(Binary terminalEntropy) {
        return new CApdu(128, 234, 0, 0, terminalEntropy, 256, "{EMV} EXCHANGE RELAY RESISTANCE DATA");
    }

    public static CApdu UpdateRecord(int sfi, int recordNumber, Binary recordBody) {
        Ex.MUST(recordNumber > 0 && recordNumber <= 255, "Wrong 'Record number'");
        Ex.MUST(sfi > 0 && sfi < 31, "Wrong 'Short File ID'");
        CApdu ap = new CApdu(132, 220, recordNumber, sfi << 3 | 4, recordBody, 0, "{EMV} UPDATE RECORD");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu PutData(int tag, Binary value) {
        Ex.MUST(Int.isU16(tag), "Wrong Tag");
        return new CApdu(132, 218, tag >>> 8, tag & 0xFF, value, 0, "{EMV} PUT DATA");
    }

    public static CApdu GetData(int tag) {
        Ex.MUST(Int.isU16(tag), "Wrong Tag");
        CApdu ap = new CApdu(128, 202, tag >>> 8, tag & 0xFF, Binary.Bin(), 256, "{EMV} GET DATA");
        ap.isTlvData = true;
        return ap;
    }

    public static CApdu ApplicationUnblock() {
        return new CApdu(132, 24, 0, 0, Binary.Bin(), 0, "{EMV} APPLICATION UNBLOCK");
    }

    public static CApdu ApplicationBlock() {
        return new CApdu(132, 30, 0, 0, Binary.Bin(), 0, "{EMV} APPLICATION BLOCK");
    }
}

