/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.format.BerTLV;
import org.denom.smartcard.CpsDataGroup;

public final class EmvDataGroups {
    public static CpsDataGroup DG_Record(int recordId, Binary recordBody) {
        Ex.MUST(Int.isU16(recordId), "recordId > 0xFFFF");
        return new CpsDataGroup(recordId, recordBody, "DATA GROUP:  Record " + Binary.Num_Bin(recordId, 2).Hex());
    }

    public static CpsDataGroup DG_9102_FciProprietaryTemplateContact(Binary tlvA5) {
        Ex.MUST(BerTLV.isTLV(tlvA5), "A5 is not TLV");
        return new CpsDataGroup(37122, tlvA5, "DATA GROUP:  FCI Proprietary Template. Tag A5 (contact)");
    }

    public static CpsDataGroup DG_9103_FciProprietaryTemplateContactless(Binary tlvA5) {
        Ex.MUST(BerTLV.isTLV(tlvA5), "A5 is not TLV");
        return new CpsDataGroup(37123, tlvA5, "DATA GROUP:  FCI Proprietary Template. Tag A5 (contactless)");
    }

    public static CpsDataGroup DG_9104_AIP_AFL(Binary aipValue, Binary aflValue) {
        Binary tlvAIP = BerTLV.Tlv(130, aipValue);
        Binary tlvAFL = BerTLV.Tlv(148, aflValue);
        return new CpsDataGroup(37124, Binary.Bin(tlvAIP, tlvAFL), "DATA GROUP:  AIP and AFL (Contact)");
    }

    public static CpsDataGroup DG_B104_AIP_AFLContactless(Binary aipValue, Binary aflValue) {
        Binary tlvAIP = BerTLV.Tlv(130, aipValue);
        Binary tlvAFL = BerTLV.Tlv(148, aflValue);
        return new CpsDataGroup(45316, Binary.Bin(tlvAIP, tlvAFL), "DATA GROUP:  AIP and AFL (Contactless)");
    }
}

