/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.CryptoMode;
import org.denom.format.BerTLV;
import org.denom.format.JSONObject;
import org.denom.smartcard.CpsDataGroup;
import org.denom.smartcard.emv.ITagDictionary;
import org.denom.smartcard.emv.TagInfo;
import org.denom.smartcard.gp.GP_SM;

public final class EmvPerso {
    public static CpsDataGroup encryptDG(CpsDataGroup dg, GP_SM sm) {
        if (dg.needEncryption) {
            Ex.MUST(dg.data.size() % 8 == 0, "\u0413\u0440\u0443\u043f\u043f\u0430 \u0434\u0430\u043d\u043d\u044b\u0445, \u0448\u0438\u0444\u0440\u0443\u0435\u043c\u0430\u044f \u043d\u0430 \u043a\u043b\u044e\u0447\u0435 DEK, \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043a\u0440\u0430\u0442\u043d\u0430 8");
            Binary encrypted = sm.dekCipher.encrypt(dg.data, CryptoMode.ECB, AlignMode.NONE, null);
            dg.data.assign(encrypted);
        }
        return dg;
    }

    public static String replaceVariables(String str, JSONObject jo, ITagDictionary dict, boolean throwIfAbsent) {
        String objectName;
        int rightPos;
        if (str == "") {
            return "";
        }
        int leftPos = 0;
        int offset = 0;
        while ((leftPos = str.indexOf("<<", offset)) != -1) {
            int keyLen;
            offset = leftPos + 2;
            rightPos = str.indexOf(">>", leftPos);
            if (rightPos == -1 || (keyLen = rightPos - leftPos - 2) < 1) continue;
            objectName = str.substring(leftPos + 2, leftPos + 2 + keyLen);
            Binary emptyBin = Binary.Bin();
            Binary referencedValue = throwIfAbsent ? jo.getBinary(objectName) : jo.optBinary(objectName, emptyBin);
            objectName = objectName.replace("Contact.", "");
            objectName = objectName.replace("Contactless.", "");
            objectName = objectName.replace("NIST.", "");
            TagInfo tagInfo = dict.find(objectName = objectName.replace("GOST.", ""));
            if (tagInfo == null) {
                Ex.THROW("Tag " + objectName + " not found in dictionary");
            }
            int tag = tagInfo.tag;
            String newValue = BerTLV.Tlv(tag, referencedValue).Hex();
            str = str.replace(str.substring(leftPos, leftPos + keyLen + 4), newValue);
        }
        offset = 0;
        while ((leftPos = str.indexOf(60, offset)) != -1) {
            int key_len;
            offset = leftPos + 1;
            rightPos = str.indexOf(62, leftPos);
            if (rightPos == -1 || (key_len = rightPos - leftPos - 1) < 1) continue;
            objectName = str.substring(leftPos + 1, leftPos + 1 + key_len);
            String referencedValue = throwIfAbsent ? jo.getString(objectName) : jo.optString(objectName, "");
            str = str.replace(str.substring(leftPos, leftPos + key_len + 2), referencedValue);
            --offset;
        }
        return str;
    }

    public static void replaceVariables(JSONObject jo, ITagDictionary dict, boolean throwIfAbsent) {
        for (String key : jo.keySet()) {
            Object obj = jo.get(key);
            if (!(obj instanceof String)) continue;
            jo.put(key, EmvPerso.replaceVariables((String)obj, jo, dict, throwIfAbsent));
        }
    }
}

