/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv;

import java.util.Map;
import java.util.TreeMap;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.format.BerTLV;
import org.denom.smartcard.ApduIso;
import org.denom.smartcard.CardReader;

public final class EmvUtil {
    public static final int CT_AAC = 0;
    public static final int CT_TC = 64;
    public static final int CT_ARQC = 128;

    public static boolean IsAmountNumeric(Binary amount) {
        return amount.size() == 6 && amount.Hex().matches("[0-9]+");
    }

    public static boolean IsLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static boolean IsYYMMDD(Binary date) {
        String dateStr = date.Hex();
        if (dateStr.length() != 6 || !dateStr.matches("[0-9]+")) {
            return false;
        }
        int year = Integer.parseInt(dateStr.substring(0, 2)) + 2000;
        int month = Integer.parseInt(dateStr.substring(2, 4));
        int day = Integer.parseInt(dateStr.substring(4, 6));
        int maxDay = 31;
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            maxDay = 30;
        } else if (month == 2) {
            int n = maxDay = EmvUtil.IsLeapYear(year) ? 29 : 28;
        }
        return month > 0 && month <= 12 && day > 0 && day <= maxDay;
    }

    public static Binary formatPin(String pin, int formatId) {
        int size = pin.length();
        Ex.MUST(size >= 4 && size <= 12, "Size of PIN must be 4-12 symbols");
        Binary b = Binary.Bin().reserve(8);
        b.add(formatId << 4 | size);
        b.add(Strings.PadRight(pin, 14, 'F'));
        return b;
    }

    public static Arr<Binary> parseAFL(Binary afl, Arr<Binary> sdaRecords) {
        String ERR_MESSAGE = "Wrong AFL format";
        if (sdaRecords != null) {
            sdaRecords.clear();
        }
        Ex.MUST((afl.size() & 3) == 0, "Wrong AFL format");
        Arr<Binary> recIds = new Arr<Binary>();
        int i = 0;
        while (i < afl.size()) {
            int sfiShifted = afl.get(i);
            int sfi = sfiShifted >>> 3;
            Ex.MUST((sfiShifted & 7) == 0 && sfi > 0 && sfi < 31, "Wrong AFL format");
            int firstRec = afl.get(i + 1);
            int lastRec = afl.get(i + 2);
            int recsInSda = afl.get(i + 3);
            Ex.MUST(firstRec != 0 && lastRec >= firstRec && recsInSda <= lastRec - firstRec + 1, "Wrong AFL format");
            int recNum = firstRec;
            while (recNum <= lastRec) {
                Binary recId = Binary.Bin(2);
                recId.set(0, sfi);
                recId.set(1, recNum);
                recIds.add(recId);
                if (recsInSda > 0 && sdaRecords != null) {
                    sdaRecords.add(recId);
                    --recsInSda;
                }
                ++recNum;
            }
            i += 4;
        }
        return recIds;
    }

    public static Map<Binary, Binary> readAflRecords(CardReader cr, Arr<Binary> recIds) {
        TreeMap<Binary, Binary> records = new TreeMap<Binary, Binary>();
        for (Binary recId : recIds) {
            cr.Cmd(ApduIso.ReadRecord(recId.get(0), recId.get(1)));
            records.put(recId, cr.resp);
        }
        return records;
    }

    public static Binary getSdaRecords(Map<Binary, Binary> records, Arr<Binary> sdaRecIds) {
        Binary sdaRecords = Binary.Bin();
        for (Binary sdaRecId : sdaRecIds) {
            Binary record = records.get(sdaRecId);
            BerTLV rec = new BerTLV(record);
            Ex.MUST(rec.tag == 112, "Record body for SDA must be in tag 0x70");
            int sfi = sdaRecId.get(0);
            if (sfi < 11) {
                sdaRecords.add(rec.value);
                continue;
            }
            sdaRecords.add(record);
        }
        return sdaRecords;
    }
}

