/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.certificate;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.ec.ECAlg;
import org.denom.crypt.hash.SHA256;

public class CertificateEccNISTIcc {
    public static final int ASI = 0;
    public static final int HASH_ALG = 2;
    public int certFormat = 20;
    public int certEncoding = 0;
    public int asi = 0;
    public Binary expirationDate;
    public Binary expirationTime;
    public Binary serialNumber;
    public int hashEncoding = 1;
    public int hashAlg = 2;
    public Binary iccdHash;
    public Binary iccPublicKeyX;
    public Binary signature;

    public CertificateEccNISTIcc prepareToSign(int validYears, Binary serial, Binary iccdHash, ECAlg iccPublic) {
        Ex.MUST(serial.size() == 6 && iccdHash.size() == 32, "Wrong params for Issuer Cert");
        this.certFormat = 20;
        this.certEncoding = 0;
        this.asi = 0;
        String hex = ZonedDateTime.now(ZoneOffset.UTC).plusYears(validYears).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        this.expirationDate = Binary.Bin(hex);
        this.expirationTime = Binary.Bin("23 59");
        this.serialNumber = serial.clone();
        this.hashEncoding = 1;
        this.hashAlg = 2;
        this.iccdHash = iccdHash.clone();
        Binary pub = iccPublic.getPublic(true);
        this.iccPublicKeyX = pub.last(pub.size() - 1);
        return this;
    }

    public CertificateEccNISTIcc fromBin(Binary cert) {
        this.certFormat = cert.get(0);
        this.certEncoding = cert.get(1);
        this.asi = cert.get(2);
        this.expirationDate = cert.slice(3, 4);
        this.expirationTime = cert.slice(7, 2);
        this.serialNumber = cert.slice(9, 6);
        this.hashEncoding = cert.get(15);
        this.hashAlg = cert.get(16);
        Ex.MUST(this.certFormat == 20 && this.certEncoding == 0 && this.asi == 0 && this.hashEncoding == 1 && this.hashAlg == 2, "Unsupported ICC ECC Cert format");
        int hashSize = 32;
        int offset = 17;
        this.iccdHash = cert.slice(offset, hashSize);
        int NField = 32;
        this.iccPublicKeyX = cert.slice(offset += hashSize, NField);
        this.signature = cert.last(cert.size() - (offset += NField));
        return this;
    }

    public Binary formDataToSign() {
        Binary b = Binary.Bin();
        b.add(this.certFormat);
        b.add(this.certEncoding);
        b.add(this.asi);
        b.add(this.expirationDate);
        b.add(this.expirationTime);
        b.add(this.serialNumber);
        b.add(this.hashEncoding);
        b.add(this.hashAlg);
        b.add(this.iccdHash);
        b.add(this.iccPublicKeyX);
        return b;
    }

    public Binary toBin() {
        Binary b = this.formDataToSign();
        b.add(this.signature);
        return b;
    }

    public boolean verifySignature(ECAlg issuerPublicKey) {
        Binary b = this.formDataToSign();
        return issuerPublicKey.verifyECSDSA_X(b, new SHA256(), this.signature);
    }

    public void sign(ECAlg issuerPrivateKey) {
        Binary b = this.formDataToSign();
        this.signature = issuerPrivateKey.signECSDSA_X(b, new SHA256());
    }
}

