/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.kernel8;

import org.denom.Binary;

public interface IKernel8Crypter {
    public int getASI();

    default public boolean isASISupported(Binary cardQualifier) {
        int myASI = this.getASI();
        int i = 1;
        while (i <= 3) {
            if (cardQualifier.get(i) == myASI) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void resetSession();

    public Binary getKernelQualifier();

    public Binary getKernelKeyData();

    public boolean processCardKeyData(Binary var1);

    public void calcSdaHash(Binary var1);

    public boolean processCertificates(Binary var1, Binary var2, Binary var3, Binary var4, Binary var5, Binary var6);

    public Binary calcIADMac(Binary var1, Binary var2, Binary var3, Binary var4, Binary var5);

    public Binary calcEDAMac(Binary var1, Binary var2);

    public Binary decryptRecord(Binary var1);

    public Binary cryptWriteData(Binary var1);

    public Binary calcDataEnvelopeMac(Binary var1);

    public Binary decryptReadData(Binary var1);
}

