/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.kernel8.struct;

import java.util.HashMap;
import org.denom.smartcard.emv.ITagDictionary;
import org.denom.smartcard.emv.TagInfo;

public class TagDictKernel8
implements ITagDictionary {
    public static HashMap<Integer, TagInfo> tags;
    public static HashMap<String, TagInfo> tagsByName;

    public TagDictKernel8() {
        TagDictKernel8.initDict();
    }

    @Override
    public TagInfo find(int tag) {
        return tags.get(tag);
    }

    @Override
    public TagInfo find(String name) {
        return tagsByName.get(name);
    }

    private static void add(int tag, String name, TagInfo.Format format, int minLen, int maxLen, boolean fromCard) {
        TagInfo info = new TagInfo(tag, name, format, minLen, maxLen, fromCard, 0, "");
        tags.put(tag, info);
        tagsByName.put(name, info);
    }

    private static void add(int tag, String name, TagInfo.Format format, int len, boolean fromCard) {
        TagInfo info = new TagInfo(tag, name, format, len, len, fromCard, 0, "");
        tags.put(tag, info);
        tagsByName.put(name, info);
    }

    private static synchronized void initDict() {
        if (tags != null) {
            return;
        }
        tags = new HashMap();
        tagsByName = new HashMap();
        TagDictKernel8.add(24407, "Account Type", TagInfo.Format.N, 1, false);
        TagDictKernel8.add(40705, "Acquirer Identifier", TagInfo.Format.N, 6, false);
        TagDictKernel8.add(40768, "Additional Terminal Capabilities", TagInfo.Format.B, 5, false);
        TagDictKernel8.add(40706, "Amount, Authorised (Numeric)", TagInfo.Format.N, 6, false);
        TagDictKernel8.add(40707, "Amount, Other (Numeric)", TagInfo.Format.N, 6, false);
        TagDictKernel8.add(40742, "Application Cryptogram", TagInfo.Format.B, 8, true);
        TagDictKernel8.add(40770, "Application Currency Code", TagInfo.Format.N, 2, true);
        TagDictKernel8.add(40772, "Application Currency Exponent", TagInfo.Format.N, 1, true);
        TagDictKernel8.add(24356, "Application Expiration Date", TagInfo.Format.N, 3, true);
        TagDictKernel8.add(148, "AFL", TagInfo.Format.B, 4, 248, true);
        TagDictKernel8.add(40710, "Application Identifier", TagInfo.Format.B, 5, 16, false);
        TagDictKernel8.add(130, "AIP", TagInfo.Format.B, 2, true);
        TagDictKernel8.add(80, "Application Label", TagInfo.Format.ANS, 0, 16, true);
        TagDictKernel8.add(90, "PAN", TagInfo.Format.CN, 1, 10, true);
        TagDictKernel8.add(24372, "PAN SN", TagInfo.Format.N, 1, true);
        TagDictKernel8.add(40722, "Application Preferred Name", TagInfo.Format.ANS, 0, 16, true);
        TagDictKernel8.add(135, "Application Priority Indicator", TagInfo.Format.B, 1, true);
        TagDictKernel8.add(40714, "ASRPD", TagInfo.Format.B, 0, 255, true);
        TagDictKernel8.add(40758, "ATC", TagInfo.Format.B, 2, true);
        TagDictKernel8.add(40711, "Application Usage Control", TagInfo.Format.B, 2, true);
        TagDictKernel8.add(40713, "Application Version Number (Reader)", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(10453254, "Authenticated Application Data", TagInfo.Format.B, 0, 128, true);
        TagDictKernel8.add(10453250, "Cardholder Verification Decision", TagInfo.Format.B, 1, true);
        TagDictKernel8.add(10453261, "Card Capabilities Information", TagInfo.Format.B, 2, true);
        TagDictKernel8.add(10453510, "Card Data Input Capability", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(10453251, "Card Key Data", TagInfo.Format.B, 64, 132, true);
        TagDictKernel8.add(40748, "Card Qualifier", TagInfo.Format.B, 7, true);
        TagDictKernel8.add(10453252, "Card TVR", TagInfo.Format.B, 5, true);
        TagDictKernel8.add(140, "CDOL1", TagInfo.Format.B, 0, 250, true);
        TagDictKernel8.add(143, "CA Public Key Index (Card)", TagInfo.Format.B, 1, true);
        TagDictKernel8.add(40743, "Cryptogram Information Data", TagInfo.Format.B, 1, true);
        TagDictKernel8.add(10453511, "CVM Capability - CVM Required", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(10453512, "CVM Capability - No CVM Required", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(40756, "CVM Results", TagInfo.Format.B, 3, false);
        int i = 1;
        while (i <= 10) {
            TagDictKernel8.add(10453264 + i, "Data Envelope " + Integer.toString(i), TagInfo.Format.B, 0, 243, true);
            ++i;
        }
        TagDictKernel8.add(12550404, "Data Envelopes To Write", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(10453505, "Data Needed", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(12550402, "Data Record", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(12550401, "Data To Send", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(10453536, "Default CDOL1", TagInfo.Format.B, 0, 250, false);
        TagDictKernel8.add(10453534, "Default IAD MAC Offset", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(132, "DF Name", TagInfo.Format.B, 5, 16, true);
        TagDictKernel8.add(10453535, "Discretionary Data Tag List", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(12550403, "Discretionary Data", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(10453253, "Enhanced Data Authentication MAC", TagInfo.Format.B, 8, true);
        TagDictKernel8.add(10453508, "Error Indication", TagInfo.Format.B, 6, false);
        TagDictKernel8.add(10453258, "Extended SDA Tag List", TagInfo.Format.B, 0, 255, true);
        TagDictKernel8.add(48908, "FCI Issuer Discretionary Data", TagInfo.Format.B, 0, 220, true);
        TagDictKernel8.add(165, "FCI Proprietary Template", TagInfo.Format.B, 0, 240, true);
        TagDictKernel8.add(111, "FCI Template", TagInfo.Format.B, 0, 250, true);
        TagDictKernel8.add(10453522, "Hold Time Value", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(10453255, "IAD MAC Offset", TagInfo.Format.B, 1, true);
        TagDictKernel8.add(10453259, "ICC ECC Public Key (for RSA Certs)", TagInfo.Format.B, 32, 66, true);
        TagDictKernel8.add(40774, "ICC Public Key Certificate", TagInfo.Format.B, 0, 248, true);
        TagDictKernel8.add(40775, "ICC RSA Public Key Exponent", TagInfo.Format.B, 1, 3, true);
        TagDictKernel8.add(40776, "ICC RSA Public Key Remainder", TagInfo.Format.B, 0, 255, true);
        TagDictKernel8.add(40734, "Interface Device Serial Number", TagInfo.Format.AN, 8, false);
        TagDictKernel8.add(40720, "Issuer Application Data", TagInfo.Format.B, 0, 32, true);
        TagDictKernel8.add(10453257, "Issuer Application Data MAC", TagInfo.Format.B, 8, false);
        TagDictKernel8.add(40721, "Issuer Code Table Index", TagInfo.Format.N, 1, true);
        TagDictKernel8.add(66, "Issuer Identification Number", TagInfo.Format.N, 3, true);
        TagDictKernel8.add(40716, "Issuer Identification Number Extended", TagInfo.Format.N, 3, 4, true);
        TagDictKernel8.add(144, "Issuer Public Key Certificate", TagInfo.Format.B, 0, 248, true);
        TagDictKernel8.add(40754, "Issuer RSA Public Key Exponent", TagInfo.Format.B, 1, 3, true);
        TagDictKernel8.add(146, "Issuer RSA Public Key Remainder", TagInfo.Format.B, 0, 255, true);
        TagDictKernel8.add(10453513, "Kernel Configuration", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(158, "Kernel Key Data", TagInfo.Format.B, 0, 132, false);
        TagDictKernel8.add(40747, "Kernel Qualifier", TagInfo.Format.B, 8, false);
        TagDictKernel8.add(10453530, "Kernel Reserved TVR Mask", TagInfo.Format.B, 5, false);
        TagDictKernel8.add(24365, "Language Preference", TagInfo.Format.AN, 2, 8, true);
        TagDictKernel8.add(40781, "Log Entry", TagInfo.Format.B, 2, true);
        TagDictKernel8.add(10453524, "Maximum Relay Resistance Grace Period", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(40725, "Merchant Category Code", TagInfo.Format.N, 2, false);
        TagDictKernel8.add(40726, "Merchant Identifier", TagInfo.Format.ANS, 15, false);
        TagDictKernel8.add(40782, "Merchant Name and Location", TagInfo.Format.ANS, 0, 65535, false);
        TagDictKernel8.add(10453521, "Message Hold Time", TagInfo.Format.N, 3, false);
        TagDictKernel8.add(10453533, "Message Identifiers On Restart", TagInfo.Format.B, 0, 32, false);
        TagDictKernel8.add(10453523, "Minimum Relay Resistance Grace Period", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(10453520, "Outcome Parameter Set", TagInfo.Format.B, 8, false);
        TagDictKernel8.add(40740, "Payment Account Reference", TagInfo.Format.AN, 29, true);
        TagDictKernel8.add(40760, "PDOL", TagInfo.Format.B, 0, 240, true);
        TagDictKernel8.add(10453506, "Proceed To First Write Flag", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(10453517, "Reader Contactless Floor Limit", TagInfo.Format.N, 6, false);
        TagDictKernel8.add(10453518, "Reader CVM Required Limit", TagInfo.Format.N, 6, false);
        TagDictKernel8.add(10453532, "Read Data Status", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(10453527, "Relay Resistance Accuracy Threshold", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(10453260, "RR Time Excess", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(10453528, "RR Transmission Time Mismatch Threshold", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(119, "Response Message Template Format 2", TagInfo.Format.B, 0, 253, true);
        TagDictKernel8.add(10453256, "Restart Indicator", TagInfo.Format.B, 2, 5, true);
        TagDictKernel8.add(10453514, "Security Capability", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(24368, "Service Code", TagInfo.Format.N, 2, true);
        TagDictKernel8.add(10453537, "Tag Mapping List", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(10453507, "Tags To Read", TagInfo.Format.B, 0, 65535, false);
        TagDictKernel8.add(10453515, "Terminal Action Code - Denial", TagInfo.Format.B, 5, false);
        TagDictKernel8.add(10453516, "Terminal Action Code - Online", TagInfo.Format.B, 5, false);
        TagDictKernel8.add(40755, "Terminal Capabilities", TagInfo.Format.B, 3, false);
        TagDictKernel8.add(40730, "Terminal Country Code", TagInfo.Format.N, 2, false);
        TagDictKernel8.add(10453525, "Terminal Expected Time For RR C-APDU", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(10453526, "Terminal Expected Time For RR R-APDU", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(40732, "Terminal Identification", TagInfo.Format.AN, 8, false);
        TagDictKernel8.add(40733, "Terminal Risk Management Data", TagInfo.Format.B, 8, false);
        TagDictKernel8.add(40757, "Terminal Type", TagInfo.Format.N, 1, false);
        TagDictKernel8.add(149, "Terminal Verification Results", TagInfo.Format.B, 5, false);
        TagDictKernel8.add(10453519, "Timeout Value", TagInfo.Format.B, 2, false);
        TagDictKernel8.add(40729, "Token Requester ID", TagInfo.Format.N, 6, true);
        TagDictKernel8.add(40735, "Track 1 Discretionary Data", TagInfo.Format.ANS, 0, 54, true);
        TagDictKernel8.add(40736, "Track 2 Discretionary Data", TagInfo.Format.CN, 0, 16, true);
        TagDictKernel8.add(87, "Track 2 Equivalent Data", TagInfo.Format.B, 0, 19, true);
        TagDictKernel8.add(24362, "Transaction Currency Code", TagInfo.Format.N, 2, false);
        TagDictKernel8.add(24374, "Transaction Currency Exponent", TagInfo.Format.N, 1, false);
        TagDictKernel8.add(154, "Transaction Date", TagInfo.Format.N, 3, false);
        TagDictKernel8.add(40737, "Transaction Time", TagInfo.Format.N, 3, false);
        TagDictKernel8.add(156, "Transaction Type", TagInfo.Format.N, 1, false);
        TagDictKernel8.add(40759, "Unpredictable Number", TagInfo.Format.B, 4, false);
        TagDictKernel8.add(10453509, "User Interface Request Data 1", TagInfo.Format.B, 13, false);
        TagDictKernel8.add(10453529, "User Interface Request Data 2", TagInfo.Format.B, 13, false);
        TagDictKernel8.add(10453531, "Write Data Status", TagInfo.Format.B, 1, false);
        TagDictKernel8.add(24352, "Cardholder Name", TagInfo.Format.ANS, 2, 26, true);
        TagDictKernel8.add(141, "CDOL2", TagInfo.Format.B, 0, 250, true);
        TagDictKernel8.add(40774, "ICC Public Key Certificate", TagInfo.Format.B, 0, 255, true);
        TagDictKernel8.add(145, "Issuer Authentication Data", TagInfo.Format.B, 8, 16, false);
    }
}

