/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.emv.kernel8.struct;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;
import org.denom.smartcard.emv.ITagDictionary;
import org.denom.smartcard.emv.TagInfo;

public class TlvDatabase {
    public HashMap<Integer, Binary> db = new HashMap();
    public ITagDictionary dict;

    public TlvDatabase(ITagDictionary dict) {
        this.dict = dict;
    }

    public TlvDatabase clone() {
        TlvDatabase newObj = new TlvDatabase(this.dict);
        newObj.append(this);
        return newObj;
    }

    public void append(TlvDatabase other) {
        for (Map.Entry<Integer, Binary> entry : other.db.entrySet()) {
            this.db.put(entry.getKey(), entry.getValue().clone());
        }
    }

    public void clear() {
        this.db.clear();
    }

    public void store(int tag, Binary value) {
        Ex.MUST(value != null, "TlvDatabase.store: Value == null");
        TagInfo info = this.dict.find(tag);
        if (info == null) {
            Ex.THROW("Unknown Tag " + Binary.Num_Bin(tag, 0).Hex());
        }
        if (!info.isGoodLen(value)) {
            Ex.THROW("Tag " + Binary.Num_Bin(tag, 0).Hex() + " wrong value len");
        }
        this.db.put(tag, value.clone());
    }

    public void store(BerTLV tlv) {
        this.store(tlv.tag, tlv.value);
    }

    public String toString(int offset) {
        Binary b = Binary.Bin();
        for (Map.Entry<Integer, Binary> e : this.db.entrySet()) {
            b.add(BerTLV.Tlv((int)e.getKey(), e.getValue()));
        }
        return new BerTLVList(b).toString(offset);
    }

    public boolean IsPresent(int tag) {
        return this.db.containsKey(tag);
    }

    public boolean IsNotPresent(int tag) {
        return !this.db.containsKey(tag);
    }

    public boolean IsNotEmpty(int tag) {
        Binary val = this.db.get(tag);
        return val != null && !val.empty();
    }

    public boolean IsEmpty(int tag) {
        Binary val = this.db.get(tag);
        return val != null && val.empty();
    }

    public void Initialise(int tag) {
        this.db.put(tag, new Binary());
    }

    public Binary GetTLV(int tag) {
        Binary val = this.db.get(tag);
        if (val == null) {
            return new Binary();
        }
        return BerTLV.Tlv(tag, val.clone());
    }

    public int GetLength(int tag) {
        Binary val = this.db.get(tag);
        if (val == null) {
            return -1;
        }
        return val.size();
    }

    public Binary GetValue(int tag) {
        Binary val = this.db.get(tag);
        if (val == null || val.empty()) {
            return null;
        }
        return val.clone();
    }

    public boolean IsKnown(int tag) {
        return this.dict.find(tag) != null;
    }

    public int TagOf(String name) {
        TagInfo info = this.dict.find(name);
        if (info == null) {
            return 0;
        }
        return info.tag;
    }

    public Binary GetRef(int tag) {
        return this.db.get(tag);
    }

    public boolean ParseAndStoreCardResponse(Binary tlvsBin, boolean override) {
        BerTLV curTlv;
        if (!BerTLV.isTLV(tlvsBin)) {
            return false;
        }
        BerTLV tlvMain = new BerTLV(tlvsBin);
        Arr<BerTLV> recs = new Arr<BerTLV>();
        recs.add(tlvMain);
        int i = 0;
        while (i < recs.size()) {
            curTlv = (BerTLV)recs.get(i);
            if (curTlv.isConstructed()) {
                BerTLVList innerList = new BerTLVList(curTlv.value);
                recs.addAll(innerList.recs);
            }
            ++i;
        }
        i = 0;
        while (i < recs.size()) {
            int tag;
            curTlv = (BerTLV)recs.get(i);
            if (!curTlv.isConstructed() && this.IsKnown(tag = curTlv.tag)) {
                if (override) {
                    this.db.put(tag, curTlv.value);
                } else if (this.IsNotPresent(tag) || this.IsEmpty(tag) || curTlv.value.equals(this.GetValue(tag))) {
                    TagInfo info = this.dict.find(tag);
                    if (!info.fromCard || !info.isGoodLen(curTlv)) {
                        return false;
                    }
                    this.db.put(tag, curTlv.value);
                } else {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private Binary calcDOLValue(int tag, int wantLen) {
        Binary myVal = this.GetValue(tag);
        if (myVal == null || BerTLV.isTagConstructed(tag)) {
            return Binary.Bin(wantLen);
        }
        TagInfo.Format format = TagInfo.Format.B;
        TagInfo tagInfo = this.dict.find(tag);
        if (tagInfo != null) {
            format = tagInfo.format;
        }
        if (wantLen < myVal.size()) {
            if (format == TagInfo.Format.N) {
                return myVal.last(wantLen);
            }
            return myVal.first(wantLen);
        }
        if (wantLen > myVal.size()) {
            int padLen = wantLen - myVal.size();
            if (format == TagInfo.Format.N) {
                return Binary.Bin(padLen).add(myVal);
            }
            if (format == TagInfo.Format.CN) {
                return myVal.add(Binary.Bin(padLen, 255));
            }
            return myVal.add(Binary.Bin(padLen));
        }
        return myVal;
    }

    public Binary formDOLValues(Binary dol) {
        Ex.MUST(dol != null, "DOL is absent on card");
        Binary res = Binary.Bin().reserve(200);
        Int offset = new Int(0);
        while (offset.val < dol.size()) {
            Int Tag = new Int(0);
            Ex.MUST(BerTLV.parseTag(dol, offset, Tag), "Wrong Tag in DOL");
            Int Len = new Int(0);
            Ex.MUST(BerTLV.parseLength(dol, offset, Len), "Wrong Length in DOL");
            Binary val = this.calcDOLValue(Tag.val, Len.val);
            res.add(val);
        }
        return res;
    }

    public HashMap<Integer, Integer> createTagMapping() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Binary tagMappingBin = this.GetValue(10453537);
        if (tagMappingBin == null || tagMappingBin.empty()) {
            return map;
        }
        Arr<Integer> arr = BerTLV.parseTagList(tagMappingBin);
        Ex.MUST((arr.size() & 1) == 0, "Wrong Tag Mapping List");
        int i = 0;
        while (i < arr.size()) {
            map.put((Integer)arr.get(i), (Integer)arr.get(i + 1));
            i += 2;
        }
        return map;
    }

    public Binary getMappedTlv(HashMap<Integer, Integer> map, int tag) {
        if (this.IsNotPresent(tag)) {
            return Binary.Bin();
        }
        Binary val = this.GetValue(tag);
        Integer mapToTag = map.get(tag);
        if (mapToTag != null) {
            return BerTLV.Tlv((int)mapToTag, val);
        }
        return BerTLV.Tlv(tag, val);
    }

    public Binary createDiscretionaryData() {
        HashMap<Integer, Integer> map = this.createTagMapping();
        Binary val = Binary.Bin();
        Binary tagList = this.GetValue(10453535);
        if (tagList != null && !tagList.empty()) {
            Arr<Integer> tags = BerTLV.parseTagList(tagList);
            Iterator iterator = tags.iterator();
            while (iterator.hasNext()) {
                int tag = (Integer)iterator.next();
                val.add(this.getMappedTlv(map, tag));
            }
        }
        return BerTLV.Tlv(12550403, val);
    }

    public Binary createDataRecord() {
        HashMap<Integer, Integer> map = this.createTagMapping();
        Binary val = Binary.Bin().reserve(1000);
        val.add(this.getMappedTlv(map, 40706));
        val.add(this.getMappedTlv(map, 40707));
        val.add(this.getMappedTlv(map, 40742));
        val.add(this.getMappedTlv(map, 24356));
        val.add(this.getMappedTlv(map, 130));
        val.add(this.getMappedTlv(map, 80));
        val.add(this.getMappedTlv(map, 90));
        val.add(this.getMappedTlv(map, 24372));
        val.add(this.getMappedTlv(map, 40722));
        val.add(this.getMappedTlv(map, 40758));
        val.add(this.getMappedTlv(map, 40711));
        val.add(this.getMappedTlv(map, 40713));
        val.add(this.getMappedTlv(map, 10453254));
        val.add(this.getMappedTlv(map, 10453261));
        val.add(this.getMappedTlv(map, 40743));
        val.add(this.getMappedTlv(map, 40756));
        val.add(this.getMappedTlv(map, 132));
        val.add(this.getMappedTlv(map, 40734));
        val.add(this.getMappedTlv(map, 40720));
        val.add(this.getMappedTlv(map, 10453257));
        val.add(this.getMappedTlv(map, 40721));
        val.add(this.getMappedTlv(map, 40740));
        val.add(this.getMappedTlv(map, 40755));
        val.add(this.getMappedTlv(map, 40730));
        val.add(this.getMappedTlv(map, 40757));
        val.add(this.getMappedTlv(map, 149));
        val.add(this.getMappedTlv(map, 40729));
        val.add(this.getMappedTlv(map, 87));
        val.add(this.getMappedTlv(map, 24362));
        val.add(this.getMappedTlv(map, 154));
        val.add(this.getMappedTlv(map, 156));
        val.add(this.getMappedTlv(map, 40759));
        return BerTLV.Tlv(12550402, val);
    }
}

