/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.etsi;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.format.BerTLV;

public class CTLV
implements Cloneable {
    public int tag;
    public Binary val;

    public CTLV() {
        this.tag = 0;
        this.val = new Binary();
    }

    public CTLV(int tag, Binary value) {
        Ex.MUST(Int.isU8(tag), "Wrong Comprehension TLV tag");
        this.tag = tag;
        this.val = value.clone();
    }

    public CTLV clone() {
        return new CTLV(this.tag, this.val);
    }

    public static CTLV parse(Binary bin, Int offset) {
        Int offs = new Int(offset.val);
        Int tagParsed = new Int(0);
        if (!CTLV.parseTag(bin, offs, tagParsed)) {
            return null;
        }
        Int lenParsed = new Int(0);
        if (!BerTLV.parseLength(bin, offs, lenParsed)) {
            return null;
        }
        if (offs.val + lenParsed.val > bin.size()) {
            return null;
        }
        CTLV rec = new CTLV();
        rec.tag = tagParsed.val;
        rec.val.assign(bin, offs.val, lenParsed.val);
        offset.val = offs.val + lenParsed.val;
        return rec;
    }

    public static boolean parseTag(Binary bin, Int offset, Int tag) {
        int b1;
        int offs = offset.val;
        if (offs >= bin.size()) {
            return false;
        }
        if ((b1 = bin.get(offs++)) == 0 || b1 == 128 || b1 == 255) {
            return false;
        }
        if (b1 == 127) {
            if (offs + 2 > bin.size()) {
                return false;
            }
            tag.val = b1 << 16 | bin.getU16(offs);
            offs += 2;
        } else {
            tag.val = b1;
        }
        offset.val = offs;
        return true;
    }

    public void toBin(Binary bin) {
        CTLV.appendTlvTag(bin, this.tag);
        BerTLV.appendTlvLen(bin, this.val.size());
        bin.add(this.val);
    }

    public Binary toBin() {
        Binary res = new Binary().reserve(5 + this.val.size());
        this.toBin(res);
        return res;
    }

    public static void appendTlvTag(Binary bin, int tag) {
        if (Int.isU8(tag)) {
            bin.add(tag);
        } else {
            bin.addU24(tag);
        }
    }

    public boolean isCRFlag() {
        return CTLV.isCRFlag(this.tag);
    }

    public static boolean isCRFlag(int tag) {
        Ex.MUST(Int.isU8(tag), "wrong Comprehension TLV tag");
        return (tag & 0x80) != 0;
    }

    public static int resetCRFlag(int tag) {
        if (Int.isU8(tag)) {
            return tag & 0x7F;
        }
        Ex.MUST(Int.isU24(tag) && (tag & 0xFF0000) == 0x7F0000, "CTLV: incorrect tag");
        return tag & 0xFF7FFF;
    }
}

