/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.etsi;

import java.util.Arrays;
import java.util.Locale;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.smartcard.etsi.CTLV;
import org.denom.smartcard.etsi.CTagCAT;

public class CTLVList {
    public Arr<CTLV> recs = new Arr();

    public CTLVList() {
        this.recs = new Arr();
    }

    public CTLVList(String hex) {
        this.assign(new Binary(hex));
    }

    public CTLVList(Binary bin) {
        this.assign(bin);
    }

    public CTLVList assign(Binary bin) {
        return this.assign(bin, new Int(0));
    }

    public void add(CTLV ctlv) {
        this.recs.add(ctlv.clone());
    }

    public void add(int tag, String hexVal) {
        this.recs.add(new CTLV(tag, new Binary(hexVal)));
    }

    public void add(int tag, Binary value) {
        this.recs.add(new CTLV(tag, value));
    }

    public CTLVList assign(Binary bin, Int offset) {
        this.recs.clear();
        while (offset.val < bin.size()) {
            CTLV rec = CTLV.parse(bin, offset);
            Ex.MUST(rec != null, "CTLV: cant parse array as CTLV list");
            this.recs.add(rec);
        }
        Ex.MUST(offset.val == bin.size(), "Wrong CTLV list");
        return this;
    }

    public static CTLVList parse(Binary bin) {
        return new CTLVList(bin);
    }

    public CTLV find(int tag, int nth) {
        int k = 0;
        int i = 0;
        while (i < this.recs.size()) {
            if (CTLV.resetCRFlag(((CTLV)this.recs.get((int)i)).tag) == CTLV.resetCRFlag(tag) && ++k == nth) {
                return (CTLV)this.recs.get(i);
            }
            ++i;
        }
        return null;
    }

    public CTLV find(int tag) {
        return this.find(tag, 1);
    }

    public void checkContains(int tag, String valueHex, String errorDecription) {
        CTLV ctlv = this.find(tag);
        Ex.MUST(ctlv != null && ctlv.val.equals(valueHex), errorDecription);
    }

    public void toBin(Binary bin) {
        for (CTLV ctlv : this.recs) {
            ctlv.toBin(bin);
        }
    }

    public Binary toBin() {
        Binary res = new Binary().reserve(this.recs.size() * 5);
        this.toBin(res);
        return res;
    }

    public String toString(int eachStringOffset, boolean withDescription) {
        char[] offsetArr = new char[eachStringOffset];
        Arrays.fill(offsetArr, ' ');
        StringBuilder res = new StringBuilder(300);
        Binary tagBin = new Binary();
        for (CTLV rec : this.recs) {
            String desc;
            res.append(offsetArr);
            res.append((rec.tag & 0x80) != 0 ? "CR " : "   ");
            tagBin.clear();
            CTLV.appendTlvTag(tagBin, rec.tag);
            res.append(tagBin.Hex());
            res.append(String.format(Locale.US, " [ %3d ] :  ", rec.val.size()));
            res.append(rec.val.Hex());
            if (withDescription && !(desc = CTagCAT.getDescription(rec.tag)).isEmpty()) {
                res.append("  --  " + desc);
            }
            res.append('\n');
        }
        return res.toString();
    }
}

