/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.freemem;

import org.denom.Binary;
import org.denom.smartcard.ApduIso;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.freemem.ApduFreeMem;
import org.denom.smartcard.gp.TerminalGP;

public class TerminalFreeMem {
    public static final String CAP_FREEMEM = "freemem_221.cap";
    public CardReader cr;
    public int ee;
    public int rtr;
    public int dtr;
    public Binary jcVersion = new Binary();
    public int trcBufSize;
    public boolean isGCSupported;
    private String instanceAid;

    public TerminalFreeMem(String instanceAid) {
        this.instanceAid = instanceAid;
    }

    public TerminalFreeMem setReader(CardReader reader) {
        this.cr = reader;
        return this;
    }

    public TerminalFreeMem getInfo() {
        this.cr.Cmd(ApduIso.SelectAID(this.instanceAid));
        this.cr.Cmd(ApduFreeMem.GetFreeMem());
        this.ee = this.cr.resp.getU16(0);
        this.rtr = this.cr.resp.getU16(2);
        this.dtr = this.cr.resp.getU16(4);
        this.jcVersion = this.cr.resp.slice(6, 2);
        this.trcBufSize = this.cr.resp.getU16(8);
        this.isGCSupported = this.cr.resp.get(10) == 1;
        return this;
    }

    public int allocEE() {
        this.cr.Cmd(ApduIso.SelectAID(this.instanceAid));
        int chunkSize = 5000;
        int allocated = 0;
        this.cr.Cmd(ApduFreeMem.GetFreeMem());
        while (this.cr.resp.getU16(0) == Short.MAX_VALUE) {
            this.cr.Cmd(ApduFreeMem.AllocEE(chunkSize));
            allocated += chunkSize;
            this.cr.Cmd(ApduFreeMem.GetFreeMem());
        }
        return allocated;
    }

    public int measureFreeEE() {
        int allocated = this.allocEE();
        this.getInfo();
        this.ee += allocated;
        this.cr.Cmd(ApduFreeMem.RunGC());
        return this.ee;
    }

    public int measureFreeEE(TerminalGP domain, String capFileName) {
        CapFile cap = new CapFile().load(capFileName);
        domain.reloadAndInstall(cap, this.instanceAid, "", "");
        int freeEE = this.measureFreeEE();
        domain.select();
        domain.connect();
        domain.delete(cap.packageAID);
        return freeEE;
    }
}

