/*
 * Decompiled with CFR 0.152.
 */
package org.denom.smartcard.gp;

import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Pair;
import org.denom.crypt.blockcipher.AlignMode;
import org.denom.crypt.blockcipher.TripleDES;
import org.denom.crypt.hash.SHA1;
import org.denom.format.BerTLV;
import org.denom.log.ILog;
import org.denom.log.LogDummy;
import org.denom.smartcard.AID;
import org.denom.smartcard.ApduIso;
import org.denom.smartcard.CApdu;
import org.denom.smartcard.CardReader;
import org.denom.smartcard.CardReaderNull;
import org.denom.smartcard.IApduLogger;
import org.denom.smartcard.ISM;
import org.denom.smartcard.cap.CapFile;
import org.denom.smartcard.gp.ApduGP;
import org.denom.smartcard.gp.GP;
import org.denom.smartcard.gp.GP_SM;
import org.denom.smartcard.gp.ISecurityModuleGP;

public class TerminalGP {
    private CardReader cr;
    private ILog log;
    private final Binary aid = new Binary();
    private ISecurityModuleGP securityModule = null;
    private boolean printApdu = false;
    private int keysVersion = 0;
    private int secLevel = 1;
    private static final int COLOR_INFO = -16711936;
    private static final int COLOR_WARNING = -999424;
    private GP_SM sm = null;
    private final String thisClassName = this.getClass().getName();

    public TerminalGP() {
        this.cr = new CardReaderNull();
        this.log = new LogDummy();
    }

    public TerminalGP(CardReader cr, ILog log) {
        this.cr = cr;
        this.log = log;
    }

    public TerminalGP setReader(CardReader cr) {
        this.cr = cr;
        return this;
    }

    public CardReader getReader() {
        return this.cr;
    }

    public final TerminalGP setLog(ILog log) {
        this.log = log;
        return this;
    }

    public final ILog getLog() {
        return this.log;
    }

    public TerminalGP enableApduLog(boolean enable) {
        this.printApdu = enable;
        return this;
    }

    public boolean isEnabledApduLog() {
        return this.printApdu;
    }

    public TerminalGP setAID(Binary aid) {
        this.aid.assign(aid);
        return this;
    }

    public Binary getAID() {
        return this.aid.clone();
    }

    public TerminalGP setSecurityModule(ISecurityModuleGP securityModule) {
        this.securityModule = securityModule;
        return this;
    }

    public ISecurityModuleGP getSecurityModule() {
        return this.securityModule;
    }

    public TerminalGP setSMParams(int keysVersion, int secLevel) {
        this.keysVersion = keysVersion;
        this.secLevel = secLevel;
        return this;
    }

    public TerminalGP clone() {
        TerminalGP copy = new TerminalGP(this.cr, this.log);
        copy.securityModule = this.securityModule;
        copy.aid.assign(this.aid);
        copy.printApdu = this.printApdu;
        copy.keysVersion = this.keysVersion;
        copy.secLevel = this.secLevel;
        return copy;
    }

    private void tuneApduLog(Runnable action) {
        IApduLogger apduLogger = this.cr.getApduLogger();
        if (!this.printApdu) {
            this.cr.setApduLogger(null);
        }
        try {
            action.run();
        }
        finally {
            this.cr.setApduLogger(apduLogger);
        }
    }

    public Binary select() {
        this.log.writeln(-16711936, "Select domain...");
        this.sm = null;
        this.tuneApduLog(() -> {
            if (this.aid.empty()) {
                this.aid.assign(this.selectTypicalISD());
            } else {
                this.Cmd(null, ApduIso.SelectAID(this.aid));
                Binary returnedAID = new BerTLV((Binary)this.cr.resp).find((String)"6F/84").value;
                if (!returnedAID.empty()) {
                    this.aid.assign(returnedAID);
                }
            }
            this.log.writeln(-16711936, this.aid.Hex());
        });
        return this.aid;
    }

    private Binary selectTypicalISD() {
        Binary aid = AID.ISD_VISA_OPENPLATFORM;
        this.Cmd(null, ApduIso.SelectAID(aid), 3);
        if (this.cr.rapdu.isOk()) {
            return aid;
        }
        aid = AID.ISD_GLOBAL_PLATFORM;
        this.Cmd(null, ApduIso.SelectAID(aid), 3);
        if (this.cr.rapdu.isOk()) {
            return aid;
        }
        aid = AID.ISD_MASTERCARD;
        this.Cmd(null, ApduIso.SelectAID(aid), 1);
        return aid;
    }

    private void connectTestDomain(int keyVersion, int secLevel) {
        Ex.MUST(!this.aid.empty(), "Domain not selected");
        Binary hostChallenge = Binary.Bin().random(8);
        this.Cmd(null, ApduGP.InitializeUpdate(hostChallenge, keyVersion));
        GP_SM.SessionKeys sessionKeys = null;
        Binary[][] binaryArray = GP.TEST_SD_KEYS;
        int n = GP.TEST_SD_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            Binary dekKey;
            Binary macKey;
            Binary[] curKeys = binaryArray[n2];
            Binary encKey = curKeys[0].clone();
            sessionKeys = GP_SM.genSessionKeys(encKey, macKey = curKeys.length > 1 ? curKeys[1].clone() : encKey.clone(), dekKey = curKeys.length > 2 ? curKeys[2].clone() : encKey.clone(), hostChallenge, this.cr.rapdu.response);
            if (sessionKeys != null) break;
            ++n2;
        }
        Ex.MUST(sessionKeys != null, "Test keys do not match selected domain: " + this.aid.Hex());
        this.sm = new GP_SM();
        CApdu ap = GP_SM.formExtAuth(this.cr.rapdu.response, secLevel, hostChallenge, sessionKeys, this.sm);
        this.Cmd(null, ap);
    }

    public GP_SM connect() {
        this.log.writeln(-16711936, "Connect domain...");
        Ex.MUST(!this.aid.empty(), "Domain not selected");
        this.tuneApduLog(() -> {
            if (this.securityModule != null) {
                try {
                    this.sm = GP_SM.open(this.cr, this.keysVersion, this.secLevel, this.securityModule);
                }
                catch (Throwable ex) {
                    Ex.THROW("Can't open SM with Security Module. " + ex.toString());
                }
            } else {
                this.connectTestDomain(this.keysVersion, this.secLevel);
            }
        });
        this.log.writeln(-16711936, "OK");
        return this.sm;
    }

    public boolean delete(Binary aid) {
        Ex.MUST(this.sm != null, "SM is not initialized with domain");
        this.log.writeln(-16711936, "Delete " + aid.Hex() + "... ");
        this.tuneApduLog(() -> {
            this.Cmd(this.sm, ApduGP.Delete(aid, 128), 3);
            if (!this.cr.rapdu.isOk()) {
                this.Cmd(this.sm, ApduGP.Delete(aid, 0), 3);
            }
        });
        if (!this.cr.rapdu.isOk()) {
            this.log.writeln(-999424, "Failed. Status: 0x" + Binary.Num_Bin(this.cr.rapdu.status, 2).Hex());
            return false;
        }
        this.log.writeln(-16711936, "OK");
        return true;
    }

    public boolean delete(String aid) {
        return this.delete(Binary.Bin(aid));
    }

    public void load(CapFile cap) {
        this.load(cap, null);
    }

    public void load(CapFile cap, Binary keyDap) {
        Ex.MUST(this.sm != null, "SM is not initialized with domain");
        this.log.writeln(-16711936, "Load package " + cap.packageAID.Hex() + "... ");
        this.tuneApduLog(() -> {
            Binary data = cap.toBinary(false);
            int size = data.size();
            Binary hash = Binary.Bin();
            Binary dap = Binary.Bin();
            if (keyDap != null && !keyDap.empty()) {
                hash = new SHA1().calc(data);
                dap = new TripleDES(keyDap).calcMACAlg3(hash, AlignMode.BLOCK, null);
            }
            this.Cmd(this.sm, ApduGP.InstallForLoad(capFile.packageAID, this.aid, hash), 3);
            if (!this.cr.rapdu.isOk()) {
                this.Cmd(this.sm, ApduGP.InstallForLoad(capFile.packageAID, Binary.Bin(), hash));
            }
            int block_num = 0;
            int offset = 0;
            while (offset < size) {
                int part_size = Math.min(220, size - offset);
                Binary part = data.slice(offset, part_size);
                CApdu ap = block_num == 0 ? ApduGP.LoadFirstBlock(size, part, dap) : ApduGP.LoadNextBlock(block_num, part, (offset += part_size) == size);
                this.Cmd(this.sm, ap);
                ++block_num;
            }
            this.log.writeln(-16711936, "OK");
        });
    }

    public void reload(CapFile cap) {
        this.delete(cap.packageAID);
        this.load(cap, null);
    }

    public void install(Binary packageAid, Binary classAid, Binary instanceAid, Binary appParams, Binary sysParams) {
        Ex.MUST(this.sm != null, "SM is not initialized with domain");
        this.log.write(-16711936, "Install (" + packageAid.Hex() + ", " + classAid.Hex() + ")  ->  " + instanceAid.Hex());
        if (!appParams.empty()) {
            this.log.writeln("");
            this.log.write(-16711936, "    params: " + appParams.Hex());
        }
        this.log.writeln(-16711936, "... ");
        this.tuneApduLog(() -> this.Cmd(this.sm, ApduGP.InstallForInstall(packageAid, classAid, instanceAid, appParams, 0, sysParams)));
        this.log.writeln(-16711936, "OK");
    }

    public void install(CapFile cap, Binary instanceAid, Binary appParams, Binary sysParams) {
        this.install(cap.packageAID, cap.classAIDs.get(0), instanceAid, appParams, sysParams);
    }

    public void install(CapFile cap, String instanceAidHex, String appParamsHex, String sysParamsHex) {
        this.install(cap.packageAID, cap.classAIDs.get(0), Binary.Bin(instanceAidHex), Binary.Bin(appParamsHex), Binary.Bin(sysParamsHex));
    }

    public void reloadAndInstall(CapFile cap, String instanceAidHex, String appParamsHex, String sysParamsHex) {
        this.select();
        this.connect();
        this.delete(cap.packageAID);
        this.load(cap, null);
        this.install(cap.packageAID, cap.classAIDs.get(0), Binary.Bin(instanceAidHex), Binary.Bin(appParamsHex), Binary.Bin(sysParamsHex));
    }

    public Arr<Pair<Binary, Binary>> getStatus(int getStatusTarget) {
        Ex.MUST(!this.aid.empty(), "Domain not selected");
        Ex.MUST(getStatusTarget != 16, "Dont call this method with 'getStatusTarget == 0x10'");
        this.log.writeln(-16711936, "Get Status 0x" + Binary.Num_Bin(getStatusTarget, 1).Hex() + "...");
        this.tuneApduLog(() -> this.cr.Cmd(this.sm, ApduGP.GetStatus(getStatusTarget, Binary.Bin(), false, false), 3));
        Arr<Pair<Binary, Binary>> res = new Arr<Pair<Binary, Binary>>(16);
        if (!this.cr.rapdu.isOk()) {
            this.log.writeln(-999424, "Failed. Status: 0x" + Binary.Num_Bin(this.cr.rapdu.status, 2).Hex());
            return res;
        }
        this.log.writeln(-16711936, "OK");
        Binary resp = this.cr.resp;
        int i = 0;
        while (i < resp.size()) {
            int aidLen = resp.get(i);
            Binary aid = resp.slice(++i, aidLen);
            Binary info = resp.slice(i += aidLen, 2);
            i += 2;
            res.add(Pair.of(aid, info));
        }
        return res;
    }

    public Binary getStatus(int target_P1, Binary aid, boolean isResponseDataNew) {
        Binary answer = Binary.Bin();
        this.log.writeln(-16711936, "GET STATUS...");
        this.tuneApduLog(() -> {
            CApdu ap = ApduGP.GetStatus(target_P1, aid, isResponseDataNew, false);
            this.cr.Cmd(this.sm, ap, 3);
            answer.assign(this.cr.resp);
            while (this.cr.rapdu.status == 25360) {
                ap = ApduGP.GetStatus(target_P1, aid, isResponseDataNew, true);
                this.cr.Cmd(this.sm, ap, 3);
                answer.add(this.cr.resp);
            }
            if (!this.cr.rapdu.isOk()) {
                this.log.writeln(-999424, "Failed. Status: 0x" + Binary.Num_Bin(this.cr.rapdu.status, 2).Hex());
                return;
            }
            this.log.writeln(-16711936, "Ok");
        });
        return answer;
    }

    public Arr<Pair<Binary, Arr<Binary>>> getPackagesAndClasses() {
        Arr<Pair<Binary, Arr<Binary>>> res = new Arr<Pair<Binary, Arr<Binary>>>(16);
        this.log.writeln(-16711936, "Get Packages and Applet Classes...");
        Binary info = this.getStatus(16, Binary.Bin(), false);
        int offset = 0;
        while (offset < info.size()) {
            Binary packageAid = info.slice(offset + 1, info.get(offset));
            offset += packageAid.size() + 3;
            int classNumber = info.get(offset++);
            Arr<Binary> classList = new Arr<Binary>(classNumber);
            int j = 0;
            while (j < classNumber) {
                int len = info.get(offset++);
                classList.add(info.slice(offset, len));
                offset += len;
                ++j;
            }
            res.add(Pair.of(packageAid, classList));
        }
        return res;
    }

    public Binary getData(int tag) {
        this.log.writeln(-16711936, "Get Data, tag: " + Binary.Num_Bin(tag, 1).Hex() + "...");
        this.tuneApduLog(() -> this.cr.Cmd(this.sm, ApduGP.GetData(tag), 3));
        if (!this.cr.rapdu.isOk()) {
            this.log.writeln(-3968, "Failed or absent");
            return Binary.Bin();
        }
        this.log.writeln(-16711936, "Ok");
        return new BerTLV((Binary)this.cr.resp).value;
    }

    public static Arr<Pair<String, Binary>> parseCPLC(Binary cplc) {
        Ex.MUST(cplc != null && cplc.size() >= 42, "Wrong CPLC size");
        Arr<Pair<String, Binary>> res = new Arr<Pair<String, Binary>>(18);
        res.add(Pair.of("IC Fabricator", cplc.slice(0, 2)));
        res.add(Pair.of("IC Type", cplc.slice(2, 2)));
        res.add(Pair.of("OS ID", cplc.slice(4, 2)));
        res.add(Pair.of("OS Release Date", cplc.slice(6, 2)));
        res.add(Pair.of("OS Release Level", cplc.slice(8, 2)));
        res.add(Pair.of("IC Fabrication Date", cplc.slice(10, 2)));
        res.add(Pair.of("IC Serial Number", cplc.slice(12, 4)));
        res.add(Pair.of("IC Batch Identifier", cplc.slice(16, 2)));
        res.add(Pair.of("IC Module Fabricator", cplc.slice(18, 2)));
        res.add(Pair.of("IC Module Packaging Date", cplc.slice(20, 2)));
        res.add(Pair.of("IC Manufacturer", cplc.slice(22, 2)));
        res.add(Pair.of("IC Embedding Date", cplc.slice(24, 2)));
        res.add(Pair.of("IC PrePersonalizer", cplc.slice(26, 2)));
        res.add(Pair.of("IC PrePersonalization Date", cplc.slice(28, 2)));
        res.add(Pair.of("IC PrePerso Equipment ID", cplc.slice(30, 4)));
        res.add(Pair.of("IC Personalizer", cplc.slice(34, 2)));
        res.add(Pair.of("IC Personalization Date", cplc.slice(36, 2)));
        res.add(Pair.of("IC Perso Equipment ID", cplc.slice(38, 4)));
        return res;
    }

    public void changeKey(int keyId, int keyVersionCurrent, int keyVersionNew, Binary keyValue) {
        this.log.writeln("Change Key, KeyId: " + keyId + ", KeyVersionCurrent: " + keyVersionCurrent + ", KeyVersionNew: " + keyVersionNew + " ...");
        Ex.MUST(keyValue.size() == 16, "Wrong key size, must be 16 bytes");
        this.tuneApduLog(() -> this.Cmd(this.sm, ApduGP.PutKey(keyId, 128, keyVersionCurrent, keyVersionNew, keyValue, this.sm.dekCipher.getKey())));
        this.log.writeln(-16711936, "OK");
    }

    public void createSmKeys(int keyVersionNew, Binary keyEnc, Binary keyMac, Binary keyDek) {
        this.log.writeln(-16711936, "Create KeySet for SM, KeyVersionNew: " + keyVersionNew + " ...");
        Ex.MUST(keyEnc.size() == 16 && keyMac.size() == 16 && keyDek.size() == 16, "Wrong key size, must be 16 bytes");
        this.tuneApduLog(() -> this.Cmd(this.sm, ApduGP.PutKey_KeySet(1, 128, 0, keyVersionNew, keyEnc, keyMac, keyDek, this.sm.dekCipher.getKey())));
        this.log.writeln(-16711936, "OK");
    }

    public void changeSmKeys(int keyVersionCurrent, int keyVersionNew, Binary keyEnc, Binary keyMac, Binary keyDek) {
        this.log.writeln(-16711936, "Change KeySet for SM, KeyVersionCurrent: " + keyVersionCurrent + ", KeyVersionNew: " + keyVersionNew + " ... ");
        Ex.MUST(keyEnc.size() == 16 && keyMac.size() == 16 && keyDek.size() == 16, "Wrong key size, must be 16 bytes");
        this.tuneApduLog(() -> this.Cmd(this.sm, ApduGP.PutKey_KeySet(1, 128, keyVersionCurrent, keyVersionNew, keyEnc, keyMac, keyDek, this.sm.dekCipher.getKey())));
        this.log.writeln(-16711936, "OK");
    }

    public void changeSmKeys(int keyVersionNew, Binary keyEnc, Binary keyMac, Binary keyDek) {
        this.log.writeln(-16711936, "Change KeySet for SM, KeyVersionCurrent: " + this.sm.keysVersion + ", KeyVersionNew: " + keyVersionNew + " ...");
        Ex.MUST(keyEnc.size() == 16 && keyMac.size() == 16 && keyDek.size() == 16, "Wrong key size, must be 16 bytes");
        this.tuneApduLog(() -> {
            if (this.sm.keysVersion == 255) {
                this.Cmd(this.sm, ApduGP.PutKey_KeySet(1, 128, 0, keyVersionNew, keyEnc, keyMac, keyDek, this.sm.dekCipher.getKey()));
            } else {
                this.Cmd(this.sm, ApduGP.PutKey_KeySet(1, 128, this.sm.keysVersion, keyVersionNew, keyEnc, keyMac, keyDek, this.sm.dekCipher.getKey()), 3);
                if (!this.cr.rapdu.isOk()) {
                    this.Cmd(this.sm, ApduGP.PutKey(1, 128, this.sm.keysVersion, keyVersionNew, keyEnc, this.sm.dekCipher.getKey()));
                    this.Cmd(this.sm, ApduGP.PutKey(2, 128, keyVersionNew, keyVersionNew, keyMac, this.sm.dekCipher.getKey()));
                    this.Cmd(this.sm, ApduGP.PutKey(3, 128, keyVersionNew, keyVersionNew, keyDek, this.sm.dekCipher.getKey()));
                }
            }
        });
        this.log.writeln(-16711936, "OK");
    }

    public void changeSmKeys(Binary keyEnc, Binary keyMac, Binary keyDek) {
        int newKeyVersion = this.sm.keysVersion;
        if (this.sm.keysVersion == 255) {
            newKeyVersion = 1;
        }
        this.changeSmKeys(newKeyVersion, keyEnc, keyMac, keyDek);
    }

    private void Cmd(ISM sm, CApdu capdu, int expectedStatus) {
        this.cr.callerClassName = this.thisClassName;
        this.cr.Cmd(sm, capdu, expectedStatus);
    }

    private void Cmd(ISM sm, CApdu capdu) {
        this.cr.callerClassName = this.thisClassName;
        this.cr.Cmd(sm, capdu, 1);
    }
}

