/*
 * Decompiled with CFR 0.152.
 */
package org.denom.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

public class DialogConfirm
extends JDialog {
    private Supplier<Boolean> isAccepted;
    private boolean isOk;

    public DialogConfirm(JFrame parent, String title, JComponent content, boolean resizable) {
        this(parent, title, content, resizable, "OK", "Cancel");
    }

    public DialogConfirm(JFrame parent, String title, JComponent content, boolean resizable, String buttonOkText, String buttonCancelText) {
        super(parent, title, true);
        this.setResizable(resizable);
        JButton buttonOk = new JButton(buttonOkText);
        buttonOk.addActionListener(e -> this.onOk());
        JButton buttonCancel = new JButton(buttonCancelText);
        buttonCancel.addActionListener(e -> this.onCancel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogConfirm.this.onCancel();
            }
        });
        JPanel panelButtons = new JPanel();
        panelButtons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GroupLayout group = new GroupLayout(panelButtons);
        panelButtons.setLayout(group);
        int prefSize = -2;
        group.setHorizontalGroup(group.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 0, Short.MAX_VALUE).addComponent(buttonOk).addGap(5).addComponent(buttonCancel));
        group.setVerticalGroup(group.createSequentialGroup().addGroup(group.createParallelGroup().addComponent(buttonOk, prefSize, 30, prefSize).addComponent(buttonCancel, prefSize, 30, prefSize)));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)content, "Center");
        panel.add((Component)panelButtons, "South");
        this.setContentPane(panel);
        Dimension dim = content.getMinimumSize();
        this.setMinimumSize(new Dimension(Math.max(dim.width, 200), dim.height + 90));
        dim = content.getPreferredSize();
        this.setSize(dim.width + 10, dim.height + 90);
        this.setLocationRelativeTo(parent);
        this.getRootPane().registerKeyboardAction(e -> this.onCancel(), KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().setDefaultButton(buttonOk);
    }

    public boolean showDialog(Supplier<Boolean> isAccepted) {
        this.isAccepted = isAccepted;
        this.isOk = false;
        this.setVisible(true);
        return this.isOk;
    }

    private void onCancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void onOk() {
        if (this.isAccepted == null || this.isAccepted.get().booleanValue()) {
            this.isOk = true;
            this.setVisible(false);
            this.dispose();
        }
    }
}

