/*
 * Decompiled with CFR 0.152.
 */
package org.denom.swing;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.denom.Ex;
import org.denom.swing.SwingUtils;

public class PanelPassword
extends JPanel {
    public String password = "";
    private JPasswordField textPassword;
    private JPasswordField textConfirmPassword = null;
    private final int minLen;
    private final int maxLen;

    public PanelPassword(int minLen, int maxLen, String labelText, boolean withConfirm) {
        this.minLen = minLen;
        this.maxLen = maxLen;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int prefSize = -2;
        int EDIT_WIDTH = 250;
        int EDIT_HEIGHT = 30;
        GroupLayout group = new GroupLayout(this);
        this.setLayout(group);
        JLabel labelPassword = new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:");
        this.textPassword = new JPasswordField(maxLen);
        this.textPassword.setDocument(SwingUtils.createLimitedSizeDocument(maxLen));
        this.textPassword.setToolTipText("\u043e\u0442 " + minLen + " \u0434\u043e " + maxLen + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
        GroupLayout.ParallelGroup horizGroup = group.createParallelGroup();
        group.setHorizontalGroup(horizGroup);
        GroupLayout.SequentialGroup vertGroup = group.createSequentialGroup();
        group.setVerticalGroup(vertGroup);
        if (!labelText.isEmpty()) {
            JLabel labelInfo = new JLabel(labelText);
            labelInfo.setForeground(new Color(50, 50, 155));
            horizGroup.addComponent(labelInfo);
            vertGroup.addComponent(labelInfo);
        }
        vertGroup.addGap(15);
        horizGroup.addGroup(group.createSequentialGroup().addComponent(labelPassword, prefSize, 90, prefSize).addComponent(this.textPassword, prefSize, EDIT_WIDTH, prefSize));
        vertGroup.addGroup(group.createParallelGroup().addComponent(labelPassword, prefSize, EDIT_HEIGHT, prefSize).addComponent(this.textPassword, prefSize, EDIT_HEIGHT, prefSize));
        if (withConfirm) {
            JLabel labelConfirmPassword = new JLabel("\u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435:");
            this.textConfirmPassword = new JPasswordField(maxLen);
            this.textConfirmPassword.setDocument(SwingUtils.createLimitedSizeDocument(maxLen));
            this.textConfirmPassword.setToolTipText("\u043e\u0442 " + minLen + " \u0434\u043e " + maxLen + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
            horizGroup.addGroup(group.createSequentialGroup().addComponent(labelConfirmPassword, prefSize, 90, prefSize).addComponent(this.textConfirmPassword, prefSize, EDIT_WIDTH, prefSize));
            vertGroup.addGap(10);
            vertGroup.addGroup(group.createParallelGroup().addComponent(labelConfirmPassword, prefSize, EDIT_HEIGHT, prefSize).addComponent(this.textConfirmPassword, prefSize, EDIT_HEIGHT, prefSize));
        }
    }

    public boolean onOk() {
        try {
            this.textPassword.requestFocusInWindow();
            String password = new String(this.textPassword.getPassword());
            if (password.length() < this.minLen || password.length() > this.maxLen) {
                Ex.THROW("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + this.minLen + " \u0434\u043e " + this.maxLen + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.");
            }
            if (this.textConfirmPassword != null) {
                this.textConfirmPassword.requestFocusInWindow();
                String confirmedPwd = new String(this.textConfirmPassword.getPassword());
                Ex.MUST(confirmedPwd.equals(password), "\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442.");
            }
            this.password = password;
            return true;
        }
        catch (Throwable ex) {
            SwingUtils.showMessage(this, ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0432\u043e\u0434\u0430", 2);
            return false;
        }
    }
}

