/*
 * Decompiled with CFR 0.152.
 */
package org.denom.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.denom.format.JSONObject;

public class SwingContainerParams {
    public static JSONObject toJSON(Container container) {
        JSONObject jo = new JSONObject();
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(container);
        SwingContainerParams.addChildComponents(container, components);
        int i = 0;
        for (Component component : components) {
            String compName = String.valueOf(component.getClass().getCanonicalName()) + i;
            JSONObject joComponent = SwingContainerParams.Component_JSON(component);
            if (!joComponent.keySet().isEmpty()) {
                jo.put(compName, joComponent);
            }
            ++i;
        }
        return jo;
    }

    public static void fromJSON(Container container, JSONObject json) {
        if (json == null) {
            return;
        }
        if (container instanceof JFrame) {
            JFrame f = new JFrame();
            String compName = String.valueOf(container.getClass().getCanonicalName()) + 0;
            SwingContainerParams.loadComponentParams(json.optJSONObject(compName), f);
            if (!SwingContainerParams.intersectsScreen(f.getBounds())) {
                return;
            }
        }
        LinkedList<Component> components = new LinkedList<Component>();
        components.add(container);
        SwingContainerParams.addChildComponents(container, components);
        int i = 0;
        for (Component component : components) {
            String compName = String.valueOf(component.getClass().getCanonicalName()) + i;
            SwingContainerParams.loadComponentParams(json.optJSONObject(compName), component);
            ++i;
        }
    }

    private static void addChildComponents(Container contaiter, List<Component> list) {
        Component[] componentArray = contaiter.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            list.add(comp);
            if (comp instanceof Container) {
                SwingContainerParams.addChildComponents((Container)comp, list);
            }
            ++n2;
        }
    }

    private static JSONObject Component_JSON(Component component) {
        JSONObject joComponent = new JSONObject();
        if (component instanceof JFrame) {
            int state = ((JFrame)component).getExtendedState();
            if ((state & 1) != 0) {
                state ^= 1;
            }
            joComponent.put("state", String.valueOf(state));
            ((JFrame)component).setExtendedState(0);
        }
        if (component instanceof JFrame || component instanceof JPanel || component instanceof JDialog) {
            joComponent.put("x", String.valueOf(component.getX()));
            joComponent.put("y", String.valueOf(component.getY()));
            joComponent.put("w", String.valueOf(component.getWidth()));
            joComponent.put("h", String.valueOf(component.getHeight()));
        }
        if (component instanceof JSplitPane) {
            JSplitPane sp = (JSplitPane)component;
            joComponent.put("div", String.valueOf(sp.getDividerLocation()));
        }
        return joComponent;
    }

    private static void loadComponentParams(JSONObject jo, Component component) {
        if (jo == null) {
            return;
        }
        if (component instanceof JFrame || component instanceof JPanel || component instanceof JDialog) {
            int x = jo.optInt("x", component.getX());
            int y = jo.optInt("y", component.getY());
            int w = jo.optInt("w", component.getWidth());
            int h = jo.optInt("h", component.getHeight());
            component.setBounds(x, y, w, h);
        }
        if (component instanceof JFrame) {
            int state = jo.optInt("state", ((JFrame)component).getExtendedState());
            ((JFrame)component).setExtendedState(state);
        }
        if (component instanceof JSplitPane) {
            JSplitPane sp = (JSplitPane)component;
            sp.setDividerLocation(jo.optInt("div", sp.getDividerLocation()));
        }
    }

    private static boolean intersectsScreen(Rectangle rect) {
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice gd = graphicsDeviceArray[n2];
            GraphicsConfiguration[] graphicsConfigurationArray = gd.getConfigurations();
            int n3 = graphicsConfigurationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GraphicsConfiguration gc = graphicsConfigurationArray[n4];
                Rectangle bounds = gc.getBounds();
                if (rect.intersects(bounds)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

