/*
 * Decompiled with CFR 0.152.
 */
package org.denom.swing;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.nimbus.AbstractRegionPainter;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.denom.Ex;

public class SwingUtils {
    public static final Font DEFAULT_FONT = new Font("Consolas", 0, 15);

    public static void invokeAndWait(Runnable runnable) {
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (InvocationTargetException ex) {
            Ex.THROW(ex.getCause().getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public static void setIcon(JFrame frame, String fileName) {
        URL pathURL = frame.getClass().getClassLoader().getResource(fileName);
        frame.setIconImage(new ImageIcon(pathURL).getImage());
    }

    public static void setNimbusStyle(JFrame frame) {
        SwingUtils.setNimbusStyle(frame, DEFAULT_FONT);
    }

    public static void setNimbusStyle(JFrame frame, Font defaultFont) {
        try {
            NimbusLookAndFeel nimbusLookAndFeel = new NimbusLookAndFeel();
            UIDefaults uiDefaults = nimbusLookAndFeel.getDefaults();
            uiDefaults.put("defaultFont", defaultFont);
            uiDefaults.put("TextPane[Enabled].backgroundPainter", new AbstractRegionPainter(){

                @Override
                protected AbstractRegionPainter.PaintContext getPaintContext() {
                    return new AbstractRegionPainter.PaintContext(null, null, false);
                }

                @Override
                protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
                }
            });
            uiDefaults.put("TabbedPane:TabbedPaneTab[Disabled].backgroundPainter", new AbstractRegionPainter(){

                @Override
                protected AbstractRegionPainter.PaintContext getPaintContext() {
                    return new AbstractRegionPainter.PaintContext(null, null, false);
                }

                @Override
                protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
                }
            });
            UIManager.setLookAndFeel(nimbusLookAndFeel);
            UIManager.put("InternalFrame.titleFont", defaultFont);
            UIManager.put("TitledBorder.font", defaultFont);
            UIManager.put("FileChooser.readOnly", Boolean.TRUE);
            UIManager.put("FileChooser.saveButtonText", "Save");
            UIManager.put("FileChooser.openButtonText", "Open");
            UIManager.put("FileChooser.cancelButtonText", "Cancel");
            UIManager.put("FileChooser.lookInLabelText", "Directory:");
            UIManager.put("FileChooser.filesOfTypeLabelText", "File type:");
            UIManager.put("FileChooser.fileNameLabelText", "File name:");
            UIManager.put("OptionPane.yesButtonText", "OK");
            UIManager.put("OptionPane.cancelButtonText", "Cancel");
            SwingUtilities.updateComponentTreeUI(frame);
        }
        catch (Throwable ex) {
            Ex.THROW(ex);
        }
    }

    public static JTextField CreateLimitedTextField(int maxSize) {
        final JTextField textField = new JTextField();
        textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem itemCopy = new JMenuItem("Copy");
                    JMenuItem itemPaste = new JMenuItem("Paste");
                    itemCopy.addActionListener(new DefaultEditorKit.CopyAction());
                    itemPaste.addActionListener(new DefaultEditorKit.PasteAction());
                    itemCopy.setEnabled(textField.getSelectionStart() != textField.getSelectionEnd());
                    itemPaste.setEnabled(true);
                    menu.add(itemCopy);
                    menu.add(itemPaste);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        textField.setDocument(SwingUtils.createLimitedSizeDocument(maxSize));
        SwingUtils.makeUndoable(textField);
        return textField;
    }

    public static Document createLimitedSizeDocument(final int max) {
        return new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (this.getLength() + str.length() > max) {
                    str = str.substring(0, max - this.getLength());
                }
                super.insertString(offs, str, a);
            }
        };
    }

    public static DefaultTableModel createTableModelReadOnly(Object[][] tableData, String[] header) {
        return new DefaultTableModel(tableData, header){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
    }

    public static JTable createTableWithCopy() {
        JTable table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point pt = e.getPoint();
                int row = this.rowAtPoint(pt);
                int column = this.columnAtPoint(pt);
                boolean check = row < 0 || column < 0;
                return check ? null : this.getValueAt(row, column).toString();
            }
        };
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(true);
        table.addMouseListener(SwingUtils.TableMouseListener(table));
        table.setAutoResizeMode(0);
        return table;
    }

    public static JScrollPane createScrollPane(Component component) {
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    public static JTextArea createTextArea() {
        final JTextArea textArea = new JTextArea();
        ((DefaultCaret)textArea.getCaret()).setUpdatePolicy(1);
        textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem itemCopy = new JMenuItem("Copy");
                    itemCopy.addActionListener(new DefaultEditorKit.CopyAction());
                    itemCopy.setEnabled(textArea.getSelectionStart() != textArea.getSelectionEnd());
                    menu.add(itemCopy);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return textArea;
    }

    public static void refreshTree(final JTree tree) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < tree.getRowCount()) {
                    TreePath path = tree.getPathForRow(i);
                    if (tree.isExpanded(i)) {
                        sb.append(path.toString());
                        sb.append(",");
                    }
                    ++i;
                }
                TreePath selectedPath = tree.getSelectionPath();
                ((DefaultTreeModel)tree.getModel()).reload();
                int i2 = 0;
                while (i2 < tree.getRowCount()) {
                    TreePath path = tree.getPathForRow(i2);
                    if (sb.toString().contains(path.toString())) {
                        tree.expandRow(i2);
                    }
                    ++i2;
                }
                tree.setSelectionPath(selectedPath);
            }
        });
    }

    public static MouseListener TableMouseListener(final JTable table) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showCopyMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showCopyMenu(e);
            }

            private void showCopyMenu(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                JMenuItem itemCopy = new JMenuItem("Copy");
                menu.add(itemCopy);
                menu.show(e.getComponent(), e.getX(), e.getY());
                int col = table.getSelectedColumn();
                int row = table.getSelectedRow();
                if (col == -1 || row == -1) {
                    return;
                }
                itemCopy.addActionListener(SwingUtils.TableItemClickListener(table));
            }
        };
    }

    static ActionListener TableItemClickListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < table.getRowCount()) {
                    int j = 0;
                    while (j < table.getColumnCount()) {
                        sb.append(table.isCellSelected(i, j) ? table.getValueAt(i, j) + "\t" : "");
                        ++j;
                    }
                    if (table.isRowSelected(i)) {
                        sb.deleteCharAt(sb.length() - 1);
                        sb.append("\n");
                    }
                    ++i;
                }
                StringSelection selection = new StringSelection(sb.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        };
    }

    public static void makeUndoable(JTextComponent comp) {
        final UndoManager undoMgr = new UndoManager();
        String UNDO = "Undo";
        String REDO = "Redo";
        comp.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent e) {
                undoMgr.addEdit(e.getEdit());
            }
        });
        comp.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (undoMgr.canUndo()) {
                    undoMgr.undo();
                }
            }
        });
        comp.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (undoMgr.canRedo()) {
                    undoMgr.redo();
                }
            }
        });
        comp.getInputMap().put(KeyStroke.getKeyStroke(89, 128), "Redo");
        comp.getInputMap().put(KeyStroke.getKeyStroke(90, 128), "Undo");
    }

    public static void showMessage(final Component parentComponent, final String message, final String title, final int msgType) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parentComponent, message, title, msgType);
            }
        });
    }

    public static void showMessageError(Component parentComponent, String message) {
        SwingUtils.showMessage(parentComponent, message, "Error", 0);
    }
}

