/*
 * Decompiled with CFR 0.152.
 */
package org.denom.swing;

import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class TrayMinimize {
    private JFrame frame;
    private TrayIcon trayIcon;
    private volatile boolean minimizeToTray = true;
    private long lastDeactivated;

    public TrayMinimize(Image image) {
        try {
            this.trayIcon = new TrayIcon(image);
            this.trayIcon.setImageAutoSize(true);
            SystemTray.getSystemTray().add(this.trayIcon);
            this.trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        TrayMinimize.this.onMouseLeftClicked();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public TrayMinimize setMinimizeToTray(boolean minimizeToTray) {
        this.minimizeToTray = minimizeToTray;
        return this;
    }

    public void setFrameMinimized() {
        if (this.frame == null || this.trayIcon == null) {
            return;
        }
        this.frame.setState(1);
        if (this.minimizeToTray) {
            this.frame.setVisible(false);
        }
    }

    public void setFrameOnFront() {
        if (this.frame == null || this.trayIcon == null) {
            return;
        }
        this.frame.setVisible(true);
        this.frame.setState(0);
        this.frame.toFront();
    }

    public boolean wasFrameActiveRecently() {
        return System.currentTimeMillis() - this.lastDeactivated < 300L;
    }

    private void onMouseLeftClicked() {
        if (this.frame == null) {
            return;
        }
        if (this.frame.getState() == 0 && this.wasFrameActiveRecently()) {
            this.setFrameMinimized();
        } else {
            this.setFrameOnFront();
        }
    }

    public TrayMinimize setParentFrame(JFrame frame) {
        this.frame = frame;
        if (frame == null) {
            return this;
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent e) {
                TrayMinimize.this.setFrameMinimized();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                TrayMinimize.this.lastDeactivated = System.currentTimeMillis();
            }
        });
        this.setMinimizeToTray(true);
        return this;
    }

    public TrayMinimize setTrayIconPopupMenu(PopupMenu popupMenu) {
        if (this.trayIcon != null) {
            this.trayIcon.setPopupMenu(popupMenu);
        }
        return this;
    }

    public TrayMinimize setTrayIconImage(Image image) {
        if (this.trayIcon != null) {
            this.trayIcon.setImage(image);
        }
        return this;
    }

    public TrayMinimize setTrayIconToolTip(String tooltip) {
        if (this.trayIcon != null) {
            this.trayIcon.setToolTip(tooltip);
        }
        return this;
    }
}

