/*
 * Decompiled with CFR 0.152.
 */
package org.denom.testrunner;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.denom.Arr;
import org.denom.Ex;
import org.denom.Strings;
import org.denom.Ticker;
import org.denom.log.ILog;
import org.denom.testrunner.TestSuite;

public final class TestRunner {
    private Arr<TestSuite> suites = new Arr();
    private Arr<String> excluded = new Arr();
    private ILog log;
    public int suitesRegistered;
    public int casesRegistered;
    public int casesExcluded;
    public int casesOK;
    public int casesFailed;
    public int initStateFailed;
    public int finalizerFailed;

    public TestRunner setLog(ILog log) {
        this.log = log;
        return this;
    }

    public void registerSuite(TestSuite suite) {
        for (TestSuite curSuite : this.suites) {
            String nameAddedSuite;
            String nameCurSuite = curSuite.getClass().getName();
            Ex.MUST(!nameCurSuite.equals(nameAddedSuite = suite.getClass().getName()), "Suite " + nameCurSuite + " already included");
        }
        this.suites.add(suite);
    }

    public Arr<TestSuite> getSuites() {
        return new Arr<TestSuite>(this.suites);
    }

    public static Arr<Method> getSuiteCases(TestSuite suite) {
        Arr<Method> list = new Arr<Method>();
        Method[] methodArray = suite.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method curMethod = methodArray[n2];
            if (curMethod.getName().startsWith("case")) {
                list.add(curMethod);
            }
            ++n2;
        }
        list.sort((m1, m2) -> m1.getName().compareToIgnoreCase(m2.getName()));
        return list;
    }

    public static String wrapTestCaseDecription(String desc) {
        String res = desc.replaceAll("\\n", "<br>").replaceAll("\\s{4}?", "<i>&nbsp;</i><i>&nbsp;</i><i>&nbsp;</i>").replace("\u0426\u0435\u043b\u044c:", "<b>\u0426\u0435\u043b\u044c:</b>").replace("\u041c\u0435\u0442\u043e\u0434\u0438\u043a\u0430:", "<b>\u041c\u0435\u0442\u043e\u0434\u0438\u043a\u0430:</b>");
        return "<html>" + res + "</html>";
    }

    public void exclude(String TestName) {
        Ex.MUST(!TestName.isEmpty(), "The name test can't be empty");
        this.excluded.add(TestName);
    }

    private Arr<Method> getCasesToRun(TestSuite curSuite, String testName) {
        Arr<Method> result = new Arr<Method>();
        Arr<Method> cases = TestRunner.getSuiteCases(curSuite);
        this.casesRegistered += cases.size();
        for (Method testCase : cases) {
            String fullMethodName = String.valueOf(curSuite.getClass().getName()) + "." + testCase.getName() + ".";
            if (testName.length() != 0 && !fullMethodName.startsWith(String.valueOf(testName) + ".")) continue;
            boolean exclude = false;
            for (String s : this.excluded) {
                if (!fullMethodName.startsWith(String.valueOf(s) + ".")) continue;
                exclude = true;
                ++this.casesExcluded;
                break;
            }
            if (exclude) continue;
            result.add(testCase);
        }
        return result;
    }

    private boolean runInitState(TestSuite curSuite) {
        this.log.writeln(-1, String.valueOf(curSuite.getClass().getName()) + ".initState:");
        try {
            Ticker t = new Ticker();
            curSuite.initState();
            this.log.writeln(-16732416, " Ok, " + t.getDiffMs() + " ms\n");
            return true;
        }
        catch (Throwable ex) {
            this.log.writeln(-65536, "    Error: " + Ex.getErrorDescription(ex));
            ++this.initStateFailed;
            return false;
        }
    }

    private boolean runFinalizer(TestSuite curSuite) {
        this.log.writeln(-1, String.valueOf(curSuite.getClass().getName()) + ".finalizer:");
        try {
            Ticker t = new Ticker();
            curSuite.finalizer();
            this.log.writeln(-16732416, " Ok, " + t.getDiffMs() + " ms\n\n");
            return true;
        }
        catch (Throwable ex) {
            this.log.writeln(-65536, "    Error: " + Ex.getErrorDescription(ex));
            ++this.finalizerFailed;
            return false;
        }
    }

    private void runTestCases(TestSuite curSuite, Iterator<Method> curMethod, BiConsumer<String, Boolean> onCaseEnd) {
        block5: {
            String fullMethodName = "";
            try {
                int caseCounter = 1;
                while (curMethod.hasNext()) {
                    Method method = curMethod.next();
                    fullMethodName = String.valueOf(curSuite.getClass().getName()) + "." + method.getName();
                    this.log.writeln(-1, "    " + caseCounter + ". " + fullMethodName + ":");
                    ++caseCounter;
                    Ticker t = new Ticker();
                    method.invoke((Object)curSuite, new Object[0]);
                    this.log.writeln(-16711936, "     Ok, " + t.getDiffMs() + " ms\n");
                    ++this.casesOK;
                    if (onCaseEnd == null) continue;
                    onCaseEnd.accept(fullMethodName, true);
                }
            }
            catch (InvocationTargetException ex) {
                ++this.casesFailed;
                this.log.writeln(-65536, "    Error: " + Ex.getErrorDescription(ex.getCause()));
                if (onCaseEnd != null) {
                    onCaseEnd.accept(fullMethodName, false);
                }
            }
            catch (Throwable ex) {
                ++this.casesFailed;
                this.log.writeln(-65536, "    Error: " + Ex.getErrorDescription(ex));
                if (onCaseEnd == null) break block5;
                onCaseEnd.accept(fullMethodName, false);
            }
        }
    }

    private void clearStats() {
        this.suitesRegistered = 0;
        this.casesRegistered = 0;
        this.casesExcluded = 0;
        this.casesOK = 0;
        this.casesFailed = 0;
        this.initStateFailed = 0;
        this.finalizerFailed = 0;
    }

    public long runTests(String testName, BiConsumer<String, Boolean> onCaseEnd) {
        this.clearStats();
        this.suitesRegistered = this.suites.size();
        Ticker t = new Ticker();
        block0: for (TestSuite curSuite : this.suites) {
            Arr<Method> list = this.getCasesToRun(curSuite, testName);
            if (list.size() == 0) continue;
            Iterator<Method> cur = list.iterator();
            while (this.runInitState(curSuite)) {
                this.runTestCases(curSuite, cur, onCaseEnd);
                this.runFinalizer(curSuite);
                if (cur.hasNext()) continue;
                continue block0;
            }
        }
        return t.getDiffMs();
    }

    public long runTests(String testName) {
        return this.runTests(testName, null);
    }

    public void printTestResults() {
        this.log.writeln(-1, "======  Tests statistic  ======");
        this.log.writeln(-1, "  All suites           : " + this.suitesRegistered);
        this.log.writeln(-1, "  All cases            : " + this.casesRegistered);
        this.log.writeln(-1, "  Excluded cases       : " + this.casesExcluded);
        this.log.writeln(-1, "  OK cases             : " + this.casesOK);
        if (this.casesFailed != 0 || this.initStateFailed != 0 || this.finalizerFailed != 0) {
            this.log.writeln(-65536, "  =============================");
            this.log.writeln(-65536, "  Failed initStates: " + this.initStateFailed);
            this.log.writeln(-65536, "  Failed cases     : " + this.casesFailed);
            this.log.writeln(-65536, "  Failed finalizers: " + this.finalizerFailed);
        } else {
            this.log.writeln(-16711936, String.valueOf(Strings.ln) + "  No errors" + Strings.ln);
        }
        this.log.writeln(-1, "===============================");
    }
}

