/*
 * Decompiled with CFR 0.152.
 */
package org.denom.vrcp;

import java.net.SocketException;
import org.denom.Arr;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.log.ILog;
import org.denom.log.LogDummy;
import org.denom.net.SocketClient;
import org.denom.vrcp.VRAU;
import org.denom.vrcp.VRCU;

public class VRCPClient
implements AutoCloseable {
    private static final int DEFAULT_VRAU_DATA_LIMIT = 500000000;
    private SocketClient socketClient = null;
    private int vrauDataLimit = 500000000;
    private Binary buf = new Binary().reserve(512);
    private int commandIndex = 0;
    protected VRCU vrcu = new VRCU();
    protected VRAU vrau = new VRAU();
    protected ILog log = null;

    public VRCPClient() {
    }

    public VRCPClient(SocketClient socketClient) {
        this.socketClient = socketClient;
    }

    public VRCPClient(String host, int port) {
        this(host, port, 10);
    }

    public VRCPClient(String host, int port, int connectTimeoutSec) {
        SocketClient socket = new SocketClient(connectTimeoutSec);
        socket.connectHard(host, port);
        this.socketClient = socket;
    }

    public VRCPClient setLog(ILog log) {
        this.log = log;
        return this;
    }

    public void setSocketClient(SocketClient socketClient) {
        this.socketClient = socketClient;
    }

    public SocketClient getSocketClient() {
        return this.socketClient;
    }

    public void setReadTimeoutSec(int sec) {
        Ex.MUST(this.socketClient != null, "Null SocketClient");
        try {
            this.socketClient.getSocket().setSoTimeout(sec * 1000);
        }
        catch (SocketException ex) {
            throw new Ex(ex.toString());
        }
    }

    public int getReadTimeoutSec() {
        Ex.MUST(this.socketClient != null, "Null SocketClient");
        try {
            return this.socketClient.getSocket().getSoTimeout() / 1000;
        }
        catch (SocketException ex) {
            throw new Ex(ex.toString());
        }
    }

    public void setVrauDataLimit(int newLimit) {
        this.vrauDataLimit = newLimit;
    }

    protected void transmit(Binary buf) {
        Ex.MUST(this.socketClient != null, "socketClient not set for VRCPCLient");
        this.socketClient.write(buf);
        buf.clear();
        this.socketClient.read(buf, 16);
        int vrauSize = buf.getIntBE(12);
        Ex.MUST(vrauSize >= 0, "Negative VRAU size");
        Ex.MUST(vrauSize <= this.vrauDataLimit, "Too large answer from server");
        this.socketClient.read(buf, vrauSize);
    }

    public VRAU command(VRCU vrcu, VRAU vrau) {
        if (this.log != null && !(this.log instanceof LogDummy)) {
            this.log.writeln(String.format("VRCU: %08X %08X %08X %s", vrcu.index, vrcu.commandCode, vrcu.data.size(), vrcu.data.Hex()));
        }
        vrcu.encode(this.buf);
        this.transmit(this.buf);
        Ex.MUST(vrau.decode(this.buf), "Wrong VRAU syntax");
        if (this.log != null && !(this.log instanceof LogDummy)) {
            this.log.writeln(String.format("VRAU: %08X %08X %08X %08X %s", vrau.index, vrau.answerCode, vrau.status, vrau.data.size(), vrau.data.Hex()));
        }
        if (vrau.status != 0) {
            Ex.THROW(vrau.status, String.format("(0x%08X) %s", vrau.status, vrau.data.asUTF8()));
        }
        return vrau;
    }

    public VRAU command(int commandCode, Binary commandData) {
        ++this.commandIndex;
        this.vrcu.index = this.commandIndex;
        this.vrcu.commandCode = commandCode;
        this.vrcu.data = commandData;
        return this.command(this.vrcu, this.vrau);
    }

    public Arr<Integer> commandEnumCommands() {
        Arr<Integer> arr = new Arr<Integer>();
        this.command(-1073741823, Binary.Bin());
        int offset = 0;
        while (offset < this.vrau.data.size()) {
            arr.add(this.vrau.data.getIntBE(offset));
            offset += 4;
        }
        return arr;
    }

    public void commandStopServer() {
        this.command(-1056964609, Binary.Bin());
    }

    @Override
    public void close() {
        if (this.socketClient != null) {
            this.socketClient.close();
        }
    }
}

