/*
 * Decompiled with CFR 0.152.
 */
package org.denom.vrcp;

import org.denom.Ex;

public class VRCPError
extends RuntimeException {
    public static final int COMMAND_NOT_SUPPORTED = -536870911;
    public static final int WRONG_VRCU_SYNTAX = -536870910;
    public static final int WRONG_COMMAND_DATA = -536870909;
    public static final int READER_NOT_FOUND = -536870908;
    public static final int READER_IS_BUSY = -536870907;
    public static final int WRONG_HANDLE = -536870906;
    public static final int NO_CARD_IN_READER = -536870905;
    public static final int WRONG_PASSWORD = -536870904;
    public static final int READER_NAME_IS_BUSY = -536870903;
    public static final int IMPL_SPECIFIC = -301989888;
    public static final int NO_CODE = -1;
    private int mCode;
    private String mMessage;
    private static final long serialVersionUID = 1L;

    public VRCPError(int code) {
        this.mCode = code;
        this.mMessage = VRCPError.getErrorDescription(code);
    }

    public VRCPError(String msg) {
        this.mCode = -1;
        this.mMessage = msg;
    }

    public VRCPError(int code, String msg) {
        this.mCode = code;
        this.mMessage = msg;
    }

    public int getCode() {
        return this.mCode;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    public static String getErrorDescription(int code) {
        switch (code) {
            case -536870911: {
                return "{VRCP ERROR} Command not supported";
            }
            case -536870910: {
                return "{VRCP ERROR} Wrong VRCU syntax";
            }
            case -536870909: {
                return "{VRCP ERROR} Wrong Command data";
            }
            case -536870908: {
                return "{VRCP ERROR} Reader not found";
            }
            case -536870907: {
                return "{VRCP ERROR} Reader is busy";
            }
            case -536870906: {
                return "{VRCP ERROR} Wrong Handle";
            }
            case -536870905: {
                return "{VRCP ERROR} No card in reader";
            }
            case -536870904: {
                return "{VRCP ERROR} Wrong Password";
            }
            case -536870903: {
                return "{VRCP ERROR} Reader Name is busy";
            }
        }
        Ex.THROW("Wrong VRCP error code");
        return "";
    }

    public static void MUST(boolean expression, int code) {
        if (!expression) {
            throw new VRCPError(code);
        }
    }

    public static void MUST(boolean expression, String msg) {
        if (!expression) {
            throw new VRCPError(msg);
        }
    }

    public static void MUST(boolean expression, int code, String msg) {
        if (!expression) {
            throw new VRCPError(code, msg);
        }
    }
}

