// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.cap;

import org.denom.Binary;

import static org.denom.Binary.Bin;
import static org.denom.Ex.MUST;

/**
 * CAP-file component - Header.
 */
public class ComponentHeader extends CapComponent
{
	public int tag;
	public int size;

	public int magic;
	public int minorVersion;
	public int majorVersion;

	public static final int ACC_INT    = 0x01;
	public static final int ACC_EXPORT = 0x02;
	public static final int ACC_APPLET = 0x04;
	public int flags;

	public PackageInfo pkg;
	public String pkgName = "";

	// -----------------------------------------------------------------------------------------------------------------
	public ComponentHeader( CapFile cap, String fullName, final Binary b )
	{
		super( cap, TAG_HEADER, fullName );

		int offs = 0;

		tag = b.get( offs++ );
		size = b.getU16( offs ); offs += 2;
		magic = b.getIntBE( offs ); offs += 4;
		minorVersion = b.get( offs++ );
		majorVersion = b.get( offs++ );
		flags = b.get( offs++ );

		pkg = new PackageInfo();
		offs = pkg.parse( b, offs );

		if( minorVersion == 2 )
		{
			int nameLen = b.get( offs++ );
			if( nameLen != 0 )
				pkgName = b.slice( offs, nameLen ).asUTF8();
			offs += nameLen;
		}
		
		MUST( (tag == TAG_HEADER) && (size == (b.size() - 3))
				&& (offs == b.size()), "Wrong component Header" );
	}

	// -----------------------------------------------------------------------------------------------------------------
	public Binary toBin()
	{
		Binary b = Bin().reserve( size + 3 );

		b.add( tag );
		b.addU16( size );
		b.addInt( magic );
		b.add( minorVersion );
		b.add( majorVersion );
		b.add( flags );
		pkg.toBin( b );

		if( minorVersion == 2 )
		{
			Binary bName = Bin().fromUTF8( pkgName );
			b.add( bName.size() );
			b.add( bName );
		}

		return b;
	}

	// =================================================================================================================
	public static class PackageInfo
	{
		public int minorVersion;
		public int majorVersion;
		public Binary AID;

		protected int parse( Binary b, int offs )
		{
			minorVersion = b.get( offs++ );
			majorVersion = b.get( offs++ );
			int aidLen = b.get( offs++ );
			AID = b.slice( offs, aidLen );
			offs += aidLen;
			return offs;
		}

		protected void toBin( Binary b )
		{
			b.add( minorVersion );
			b.add( majorVersion );
			b.add( AID.size() );
			b.add( AID );
		}
	}

}
