// Denom.org
// Author:  Sergey Novochenko,  Digrol@gmail.com

package org.denom.smartcard.emv;

import java.util.Arrays;

import org.denom.format.BerTLV;
import org.denom.format.BerTLVList;

/**
 * Интерфейс для использования 'словаря' со списком тегов и информацией о них.
 */
public interface ITagDictionary
{
	/**
	 * @return null, если тега нет в словаре.
	 */
	TagInfo find( int tag );

	/**
	 * @return null, если тега нет в словаре.
	 */
	TagInfo find( String name );
	
	// ---------------------------------------------------------------------------------------------------------------------
	/**
	 * Представить список BER-TLV в виде многострочного текста для вывода на печать.
	 * @param offset - Сколько пробелов добавлять слева.
	 */
	default public String BerTLVListToString( BerTLVList tlvs, int offset )
	{
		char[] offset_arr = new char[offset];
		Arrays.fill( offset_arr, ' ' );

		StringBuilder res = new StringBuilder( 300 );
		for( int i = 0; i < tlvs.recs.size(); ++i )
		{
			final BerTLV rec = tlvs.recs.get( i );
			res.append( offset_arr );
			String tag = Integer.toHexString( rec.tag ).toUpperCase();
			res.append( tag.length() % 2 == 0 ? tag : "0" + tag );

			if( !rec.isConstructed() && (rec.value.size() > 8) )
			{
				res.append( " [" + rec.value.size() + "]" );
			}

			TagInfo tagInfo = find( rec.tag );
			if( tagInfo != null  )
				res.append( " -- " + tagInfo.name );

			res.append( ":\n" );

			if( rec.isConstructed() )
			{
				res.append( BerTLVListToString( new BerTLVList( rec.value ), offset + 4 ) );
				continue;
			}

			StringBuilder str = new StringBuilder( 200 );
			str.append( offset_arr );
			str.append( "    " );
			str.append( rec.value.Hex( 1, 8, 32, 0 ) );

			for( int k = 0; k < str.length(); ++k )
			{
				if( str.charAt( k ) == '\n' )
				{
					++k;
					str.insert( k, offset_arr );
					str.insert( k, "    " );
				}
			}
			res.append( str );
			res.append( '\n' );
		}
		return res.toString();
	}
}
