/*
 * Decompiled with CFR 0.152.
 */
package org.denom;

public class Ex
extends RuntimeException {
    private static String ln = "\n";
    public int code;
    public String place = "";
    private static final long serialVersionUID = 1L;

    static {
        try {
            ln = System.getProperty("line.separator");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Ex() {
        super("");
    }

    public Ex(int errorCode) {
        super("");
        this.code = errorCode;
    }

    public Ex(int errorCode, String message) {
        super(message);
        this.code = errorCode;
    }

    public Ex(String message) {
        super(message);
    }

    public Ex(String message, Throwable cause) {
        super(message, cause);
    }

    public Ex(int errorCode, String message, Throwable cause) {
        super(message, cause);
        this.code = errorCode;
    }

    public Ex(Throwable cause) {
        super(cause);
    }

    public Ex(String message, String place) {
        super(message);
        this.place = place;
    }

    @Override
    public String toString() {
        String msg = super.toString();
        if (this.code != 0) {
            msg = String.valueOf(msg) + ln + "Error code: " + this.code;
        }
        if (!this.place.isEmpty()) {
            msg = String.valueOf(msg) + ln + "Place: " + this.place;
        }
        return msg;
    }

    public static void THROW(String message) {
        throw new Ex(message);
    }

    public static void THROW(int errorCode) {
        throw new Ex(errorCode);
    }

    public static void THROW(int errorCode, String message) {
        throw new Ex(errorCode, message);
    }

    public static void THROW(Throwable ex) {
        throw new Ex(ex);
    }

    public static void MUST(boolean expression, String message) {
        if (!expression) {
            throw new Ex(message);
        }
    }

    public static void MUST(boolean expression) {
        if (!expression) {
            throw new Ex("No message");
        }
    }

    public static void MUST(boolean expression, int errorCode) {
        if (!expression) {
            throw new Ex(errorCode);
        }
    }

    public static void MUST(boolean expression, int errorCode, String message) {
        if (!expression) {
            throw new Ex(errorCode, message);
        }
    }

    public static String getStackStr(Throwable ex) {
        StringBuilder str = new StringBuilder(1000);
        StackTraceElement[] stack = ex.getStackTrace();
        int i = 0;
        while (i < stack.length) {
            if (!stack[i].getMethodName().equals("MUST") && !stack[i].getMethodName().equals("THROW")) {
                str.append(ln);
                str.append("    ");
                str.append(stack[i].toString());
            }
            ++i;
        }
        return str.toString();
    }

    public static String getErrorDescription(Throwable ex) {
        StringBuilder str = new StringBuilder(1000);
        str.append(ex.toString());
        str.append(ln);
        str.append("Stack:");
        str.append(Ex.getStackStr(ex));
        return str.toString();
    }

    public static String getCallerPlace(String className) {
        StackTraceElement elem;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        if (stack.length < 2) {
            return "";
        }
        int i = 0;
        while (i < stack.length) {
            elem = stack[i];
            if (elem.getClassName().equals(className)) break;
            ++i;
        }
        while (i < stack.length) {
            elem = stack[i];
            if (!elem.getClassName().equals(className)) {
                return elem.toString();
            }
            ++i;
        }
        return "";
    }
}

