/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;
import org.denom.crypt.blockcipher.CAST5;

public final class CAST6
extends BlockCipher {
    protected static final int BLOCK_SIZE = 16;
    private int[] Kr = new int[48];
    private int[] Km = new int[48];

    public CAST6() {
        this(Binary.Bin(16));
    }

    public CAST6(Binary key) {
        super.initialize(16);
        this.setKey(key);
    }

    @Override
    public CAST6 clone() {
        return new CAST6(this.key);
    }

    @Override
    public String getAlgName() {
        return "CAST6";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() >= 16 && key.size() <= 32, "Invalid key size");
        this.key = key.clone();
        int Cm = 1518500249;
        int Mm = 1859775393;
        int Cr = 19;
        int Mr = 17;
        int[] Tr = new int[192];
        int[] Tm = new int[192];
        int i = 0;
        while (i < 24) {
            int j = 0;
            while (j < 8) {
                Tm[i * 8 + j] = Cm;
                Cm += Mm;
                Tr[i * 8 + j] = Cr;
                Cr = Cr + Mr & 0x1F;
                ++j;
            }
            ++i;
        }
        Binary key64 = new Binary(64);
        key64.set(0, key, 0, key.size());
        int[] wKey = new int[8];
        int i2 = 0;
        while (i2 < 8) {
            wKey[i2] = key64.getIntBE(i2 * 4);
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            int i22 = i2 * 2 * 8;
            wKey[6] = wKey[6] ^ CAST5.F1(wKey[7], Tm[i22], Tr[i22]);
            wKey[5] = wKey[5] ^ CAST5.F2(wKey[6], Tm[i22 + 1], Tr[i22 + 1]);
            wKey[4] = wKey[4] ^ CAST5.F3(wKey[5], Tm[i22 + 2], Tr[i22 + 2]);
            wKey[3] = wKey[3] ^ CAST5.F1(wKey[4], Tm[i22 + 3], Tr[i22 + 3]);
            wKey[2] = wKey[2] ^ CAST5.F2(wKey[3], Tm[i22 + 4], Tr[i22 + 4]);
            wKey[1] = wKey[1] ^ CAST5.F3(wKey[2], Tm[i22 + 5], Tr[i22 + 5]);
            wKey[0] = wKey[0] ^ CAST5.F1(wKey[1], Tm[i22 + 6], Tr[i22 + 6]);
            wKey[7] = wKey[7] ^ CAST5.F2(wKey[0], Tm[i22 + 7], Tr[i22 + 7]);
            i22 = (i2 * 2 + 1) * 8;
            wKey[6] = wKey[6] ^ CAST5.F1(wKey[7], Tm[i22], Tr[i22]);
            wKey[5] = wKey[5] ^ CAST5.F2(wKey[6], Tm[i22 + 1], Tr[i22 + 1]);
            wKey[4] = wKey[4] ^ CAST5.F3(wKey[5], Tm[i22 + 2], Tr[i22 + 2]);
            wKey[3] = wKey[3] ^ CAST5.F1(wKey[4], Tm[i22 + 3], Tr[i22 + 3]);
            wKey[2] = wKey[2] ^ CAST5.F2(wKey[3], Tm[i22 + 4], Tr[i22 + 4]);
            wKey[1] = wKey[1] ^ CAST5.F3(wKey[2], Tm[i22 + 5], Tr[i22 + 5]);
            wKey[0] = wKey[0] ^ CAST5.F1(wKey[1], Tm[i22 + 6], Tr[i22 + 6]);
            wKey[7] = wKey[7] ^ CAST5.F2(wKey[0], Tm[i22 + 7], Tr[i22 + 7]);
            this.Kr[i2 * 4] = wKey[0] & 0x1F;
            this.Kr[i2 * 4 + 1] = wKey[2] & 0x1F;
            this.Kr[i2 * 4 + 2] = wKey[4] & 0x1F;
            this.Kr[i2 * 4 + 3] = wKey[6] & 0x1F;
            this.Km[i2 * 4] = wKey[7];
            this.Km[i2 * 4 + 1] = wKey[5];
            this.Km[i2 * 4 + 2] = wKey[3];
            this.Km[i2 * 4 + 3] = wKey[1];
            ++i2;
        }
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize >= 16 && keySize <= 32, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(16);
        this.setKey(k);
        return k;
    }

    @Override
    public void encryptBlock(Binary block) {
        int x;
        Ex.MUST(block.size() == 16, "Incorrect block size");
        int A = block.getIntBE(0);
        int B = block.getIntBE(4);
        int C = block.getIntBE(8);
        int D = block.getIntBE(12);
        int i = 0;
        while (i < 6) {
            x = i * 4;
            D ^= CAST5.F1(A ^= CAST5.F3(B ^= CAST5.F2(C ^= CAST5.F1(D, this.Km[x], this.Kr[x]), this.Km[x + 1], this.Kr[x + 1]), this.Km[x + 2], this.Kr[x + 2]), this.Km[x + 3], this.Kr[x + 3]);
            ++i;
        }
        i = 6;
        while (i < 12) {
            x = i * 4;
            C ^= CAST5.F1(D ^= CAST5.F1(A ^= CAST5.F3(B ^= CAST5.F2(C, this.Km[x + 1], this.Kr[x + 1]), this.Km[x + 2], this.Kr[x + 2]), this.Km[x + 3], this.Kr[x + 3]), this.Km[x], this.Kr[x]);
            ++i;
        }
        block.setIntBE(0, A);
        block.setIntBE(4, B);
        block.setIntBE(8, C);
        block.setIntBE(12, D);
    }

    @Override
    public void decryptBlock(Binary block) {
        int x;
        Ex.MUST(block.size() == 16, "Incorrect block size");
        int A = block.getIntBE(0);
        int B = block.getIntBE(4);
        int C = block.getIntBE(8);
        int D = block.getIntBE(12);
        int i = 0;
        while (i < 6) {
            x = (11 - i) * 4;
            D ^= CAST5.F1(A ^= CAST5.F3(B ^= CAST5.F2(C ^= CAST5.F1(D, this.Km[x], this.Kr[x]), this.Km[x + 1], this.Kr[x + 1]), this.Km[x + 2], this.Kr[x + 2]), this.Km[x + 3], this.Kr[x + 3]);
            ++i;
        }
        i = 6;
        while (i < 12) {
            x = (11 - i) * 4;
            C ^= CAST5.F1(D ^= CAST5.F1(A ^= CAST5.F3(B ^= CAST5.F2(C, this.Km[x + 1], this.Kr[x + 1]), this.Km[x + 2], this.Kr[x + 2]), this.Km[x + 3], this.Kr[x + 3]), this.Km[x], this.Kr[x]);
            ++i;
        }
        block.setIntBE(0, A);
        block.setIntBE(4, B);
        block.setIntBE(8, C);
        block.setIntBE(12, D);
    }
}

