/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;
import org.denom.crypt.blockcipher.Camellia128;

public class Camellia256
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private int[] subkeyE = new int[96];
    private int[] kwE = new int[8];
    private int[] keE = new int[12];
    private int[] subkeyD = new int[96];
    private int[] kwD = new int[8];
    private int[] keD = new int[12];
    private int[] state = new int[4];

    public Camellia256() {
        this(Binary.Bin(32));
    }

    public Camellia256(Binary key) {
        super.initialize(16);
        this.setKey(key);
    }

    @Override
    public Camellia256 clone() {
        return new Camellia256(this.key);
    }

    @Override
    public String getAlgName() {
        return "Camellia256";
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize == 24 || keySize == 32, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        return this.generateKey(32);
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 24 || key.size() == 32, "Invalid key size");
        this.key = key.clone();
        int[] k = new int[8];
        int[] ka = new int[4];
        int[] kb = new int[4];
        k[0] = key.getIntBE(0);
        k[1] = key.getIntBE(4);
        k[2] = key.getIntBE(8);
        k[3] = key.getIntBE(12);
        k[4] = key.getIntBE(16);
        k[5] = key.getIntBE(20);
        if (key.size() == 24) {
            k[6] = ~k[4];
            k[7] = ~k[5];
        } else {
            k[6] = key.getIntBE(24);
            k[7] = key.getIntBE(28);
        }
        int i = 0;
        while (i < 4) {
            ka[i] = k[i] ^ k[i + 4];
            ++i;
        }
        Camellia128.camelliaF2(ka, Camellia128.SIGMA, 0);
        i = 0;
        while (i < 4) {
            int n = i;
            ka[n] = ka[n] ^ k[i];
            ++i;
        }
        Camellia128.camelliaF2(ka, Camellia128.SIGMA, 4);
        i = 0;
        while (i < 4) {
            kb[i] = ka[i] ^ k[i + 4];
            ++i;
        }
        Camellia128.camelliaF2(kb, Camellia128.SIGMA, 8);
        this.kwE[0] = k[0];
        this.kwE[1] = k[1];
        this.kwE[2] = k[2];
        this.kwE[3] = k[3];
        Camellia128.roldqo32(45, k, 0, this.subkeyE, 16);
        Camellia128.roldq(15, k, 0, this.keE, 4);
        Camellia128.roldq(17, k, 0, this.subkeyE, 32);
        Camellia128.roldqo32(34, k, 0, this.subkeyE, 44);
        Camellia128.roldq(15, k, 4, this.subkeyE, 4);
        Camellia128.roldq(15, k, 4, this.keE, 0);
        Camellia128.roldq(30, k, 4, this.subkeyE, 24);
        Camellia128.roldqo32(34, k, 4, this.subkeyE, 36);
        Camellia128.roldq(15, ka, 0, this.subkeyE, 8);
        Camellia128.roldq(30, ka, 0, this.subkeyE, 20);
        this.keE[8] = ka[1];
        this.keE[9] = ka[2];
        this.keE[10] = ka[3];
        this.keE[11] = ka[0];
        Camellia128.roldqo32(49, ka, 0, this.subkeyE, 40);
        this.subkeyE[0] = kb[0];
        this.subkeyE[1] = kb[1];
        this.subkeyE[2] = kb[2];
        this.subkeyE[3] = kb[3];
        Camellia128.roldq(30, kb, 0, this.subkeyE, 12);
        Camellia128.roldq(30, kb, 0, this.subkeyE, 28);
        Camellia128.roldqo32(51, kb, 0, this.kwE, 4);
        k = new int[8];
        ka = new int[4];
        kb = new int[4];
        k[0] = key.getIntBE(0);
        k[1] = key.getIntBE(4);
        k[2] = key.getIntBE(8);
        k[3] = key.getIntBE(12);
        k[4] = key.getIntBE(16);
        k[5] = key.getIntBE(20);
        if (key.size() == 24) {
            k[6] = ~k[4];
            k[7] = ~k[5];
        } else {
            k[6] = key.getIntBE(24);
            k[7] = key.getIntBE(28);
        }
        i = 0;
        while (i < 4) {
            ka[i] = k[i] ^ k[i + 4];
            ++i;
        }
        Camellia128.camelliaF2(ka, Camellia128.SIGMA, 0);
        i = 0;
        while (i < 4) {
            int n = i;
            ka[n] = ka[n] ^ k[i];
            ++i;
        }
        Camellia128.camelliaF2(ka, Camellia128.SIGMA, 4);
        i = 0;
        while (i < 4) {
            kb[i] = ka[i] ^ k[i + 4];
            ++i;
        }
        Camellia128.camelliaF2(kb, Camellia128.SIGMA, 8);
        this.kwD[4] = k[0];
        this.kwD[5] = k[1];
        this.kwD[6] = k[2];
        this.kwD[7] = k[3];
        Camellia128.decroldqo32(45, k, 0, this.subkeyD, 28);
        Camellia128.decroldq(15, k, 0, this.keD, 4);
        Camellia128.decroldq(17, k, 0, this.subkeyD, 12);
        Camellia128.decroldqo32(34, k, 0, this.subkeyD, 0);
        Camellia128.decroldq(15, k, 4, this.subkeyD, 40);
        Camellia128.decroldq(15, k, 4, this.keD, 8);
        Camellia128.decroldq(30, k, 4, this.subkeyD, 20);
        Camellia128.decroldqo32(34, k, 4, this.subkeyD, 8);
        Camellia128.decroldq(15, ka, 0, this.subkeyD, 36);
        Camellia128.decroldq(30, ka, 0, this.subkeyD, 24);
        this.keD[2] = ka[1];
        this.keD[3] = ka[2];
        this.keD[0] = ka[3];
        this.keD[1] = ka[0];
        Camellia128.decroldqo32(49, ka, 0, this.subkeyD, 4);
        this.subkeyD[46] = kb[0];
        this.subkeyD[47] = kb[1];
        this.subkeyD[44] = kb[2];
        this.subkeyD[45] = kb[3];
        Camellia128.decroldq(30, kb, 0, this.subkeyD, 32);
        Camellia128.decroldq(30, kb, 0, this.subkeyD, 16);
        Camellia128.roldqo32(51, kb, 0, this.kwD, 0);
    }

    private void processBlock(Binary block, int[] subkey, int[] kw, int[] ke) {
        int i = 0;
        while (i < 4) {
            this.state[i] = block.getIntBE(i * 4);
            int n = i;
            this.state[n] = this.state[n] ^ kw[i];
            ++i;
        }
        Camellia128.camelliaF2(this.state, subkey, 0);
        Camellia128.camelliaF2(this.state, subkey, 4);
        Camellia128.camelliaF2(this.state, subkey, 8);
        Camellia128.camelliaFLs(this.state, ke, 0);
        Camellia128.camelliaF2(this.state, subkey, 12);
        Camellia128.camelliaF2(this.state, subkey, 16);
        Camellia128.camelliaF2(this.state, subkey, 20);
        Camellia128.camelliaFLs(this.state, ke, 4);
        Camellia128.camelliaF2(this.state, subkey, 24);
        Camellia128.camelliaF2(this.state, subkey, 28);
        Camellia128.camelliaF2(this.state, subkey, 32);
        Camellia128.camelliaFLs(this.state, ke, 8);
        Camellia128.camelliaF2(this.state, subkey, 36);
        Camellia128.camelliaF2(this.state, subkey, 40);
        Camellia128.camelliaF2(this.state, subkey, 44);
        block.setIntBE(0, this.state[2] ^ kw[4]);
        block.setIntBE(4, this.state[3] ^ kw[5]);
        block.setIntBE(8, this.state[0] ^ kw[6]);
        block.setIntBE(12, this.state[1] ^ kw[7]);
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        this.processBlock(block, this.subkeyE, this.kwE, this.keE);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        this.processBlock(block, this.subkeyD, this.kwD, this.keD);
    }
}

