/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class IDEA
extends BlockCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 16;
    private int[] keyE = null;
    private int[] keyD = null;

    public IDEA() {
        this(Binary.Bin(16));
    }

    public IDEA(Binary key) {
        super.initialize(8);
        this.setKey(key);
    }

    @Override
    public IDEA clone() {
        return new IDEA(this.key);
    }

    @Override
    public String getAlgName() {
        return "IDEA";
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(16);
        this.setKey(k);
        return k;
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16, "Invalid key size");
        this.key = key.clone();
        this.expandKey();
        this.invertKey();
    }

    @Override
    public void encryptBlock(Binary block) {
        this.processBlock(this.keyE, block);
    }

    @Override
    public void decryptBlock(Binary block) {
        this.processBlock(this.keyD, block);
    }

    private int mul(int x, int y) {
        int p;
        x = x == 0 ? 65537 - y : (y == 0 ? 65537 - x : y - x + ((y = (p = x * y) & 0xFFFF) < (x = p >>> 16) ? 1 : 0));
        return x & 0xFFFF;
    }

    private void processBlock(int[] wKey, Binary block) {
        Ex.MUST(block.size() == 8, "Incorrect block size");
        int x0 = block.getU16(0);
        int x1 = block.getU16(2);
        int x2 = block.getU16(4);
        int x3 = block.getU16(6);
        int keyOff = 0;
        int round = 0;
        while (round < 8) {
            x0 = this.mul(x0, wKey[keyOff++]);
            x1 += wKey[keyOff++];
            x2 += wKey[keyOff++];
            x3 = this.mul(x3, wKey[keyOff++]);
            int t0 = x1 &= 0xFFFF;
            int t1 = x2 &= 0xFFFF;
            x2 ^= x0;
            x1 ^= x3;
            x2 = this.mul(x2, wKey[keyOff++]);
            x1 += x2;
            x1 &= 0xFFFF;
            x1 = this.mul(x1, wKey[keyOff++]);
            x2 += x1;
            x0 ^= x1;
            x3 ^= (x2 &= 0xFFFF);
            x1 ^= t1;
            x2 ^= t0;
            ++round;
        }
        block.setU16(0, this.mul(x0, wKey[keyOff++]));
        block.setU16(2, x2 + wKey[keyOff++]);
        block.setU16(4, x1 + wKey[keyOff++]);
        block.setU16(6, this.mul(x3, wKey[keyOff]));
    }

    private void expandKey() {
        this.keyE = new int[52];
        int i = 0;
        while (i < 8) {
            this.keyE[i] = this.key.getU16(i * 2);
            ++i;
        }
        i = 8;
        while (i < 52) {
            this.keyE[i] = (i & 7) < 6 ? ((this.keyE[i - 7] & 0x7F) << 9 | this.keyE[i - 6] >> 7) & 0xFFFF : ((i & 7) == 6 ? ((this.keyE[i - 7] & 0x7F) << 9 | this.keyE[i - 14] >> 7) & 0xFFFF : ((this.keyE[i - 15] & 0x7F) << 9 | this.keyE[i - 14] >> 7) & 0xFFFF);
            ++i;
        }
    }

    private int mulInv(int x) {
        if (x < 2) {
            return x;
        }
        int t0 = 1;
        int t1 = 65537 / x;
        int y = 65537 % x;
        while (y != 1) {
            int q = x / y;
            t0 = t0 + t1 * q & 0xFFFF;
            if ((x %= y) == 1) {
                return t0;
            }
            q = y / x;
            y %= x;
            t1 = t1 + t0 * q & 0xFFFF;
        }
        return 1 - t1 & 0xFFFF;
    }

    private int addInv(int x) {
        return 0 - x & 0xFFFF;
    }

    private void invertKey() {
        int p = 52;
        this.keyD = new int[52];
        int inOff = 0;
        int t1 = this.mulInv(this.keyE[inOff++]);
        int t2 = this.addInv(this.keyE[inOff++]);
        int t3 = this.addInv(this.keyE[inOff++]);
        int t4 = this.mulInv(this.keyE[inOff++]);
        this.keyD[--p] = t4;
        this.keyD[--p] = t3;
        this.keyD[--p] = t2;
        this.keyD[--p] = t1;
        int round = 1;
        while (round < 8) {
            t1 = this.keyE[inOff++];
            t2 = this.keyE[inOff++];
            this.keyD[--p] = t2;
            this.keyD[--p] = t1;
            t1 = this.mulInv(this.keyE[inOff++]);
            t2 = this.addInv(this.keyE[inOff++]);
            t3 = this.addInv(this.keyE[inOff++]);
            t4 = this.mulInv(this.keyE[inOff++]);
            this.keyD[--p] = t4;
            this.keyD[--p] = t2;
            this.keyD[--p] = t3;
            this.keyD[--p] = t1;
            ++round;
        }
        t1 = this.keyE[inOff++];
        t2 = this.keyE[inOff++];
        this.keyD[--p] = t2;
        this.keyD[--p] = t1;
        t1 = this.mulInv(this.keyE[inOff++]);
        t2 = this.addInv(this.keyE[inOff++]);
        t3 = this.addInv(this.keyE[inOff++]);
        t4 = this.mulInv(this.keyE[inOff]);
        this.keyD[--p] = t4;
        this.keyD[--p] = t3;
        this.keyD[--p] = t2;
        this.keyD[--p] = t1;
    }
}

