/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class Kuznyechik
extends BlockCipher {
    private static final int BLOCK_SIZE = 16;
    private static final int KEY_SIZE = 32;
    private byte[][] wKey = new byte[10][16];
    private byte[] tmp = new byte[16];
    private byte[] x = new byte[16];
    private byte[] y = new byte[16];
    private static byte[][] GFMul = new byte[256][256];
    private static final byte[] PI;
    private static final byte[] inversePI;
    private static final byte[] lFactors;

    static {
        int x = 0;
        while (x < 256) {
            int y = 0;
            while (y < 256) {
                Kuznyechik.GFMul[x][y] = Kuznyechik.mulGF256((byte)x, (byte)y);
                ++y;
            }
            ++x;
        }
        byte[] byArray = new byte[256];
        byArray[0] = -4;
        byArray[1] = -18;
        byArray[2] = -35;
        byArray[3] = 17;
        byArray[4] = -49;
        byArray[5] = 110;
        byArray[6] = 49;
        byArray[7] = 22;
        byArray[8] = -5;
        byArray[9] = -60;
        byArray[10] = -6;
        byArray[11] = -38;
        byArray[12] = 35;
        byArray[13] = -59;
        byArray[14] = 4;
        byArray[15] = 77;
        byArray[16] = -23;
        byArray[17] = 119;
        byArray[18] = -16;
        byArray[19] = -37;
        byArray[20] = -109;
        byArray[21] = 46;
        byArray[22] = -103;
        byArray[23] = -70;
        byArray[24] = 23;
        byArray[25] = 54;
        byArray[26] = -15;
        byArray[27] = -69;
        byArray[28] = 20;
        byArray[29] = -51;
        byArray[30] = 95;
        byArray[31] = -63;
        byArray[32] = -7;
        byArray[33] = 24;
        byArray[34] = 101;
        byArray[35] = 90;
        byArray[36] = -30;
        byArray[37] = 92;
        byArray[38] = -17;
        byArray[39] = 33;
        byArray[40] = -127;
        byArray[41] = 28;
        byArray[42] = 60;
        byArray[43] = 66;
        byArray[44] = -117;
        byArray[45] = 1;
        byArray[46] = -114;
        byArray[47] = 79;
        byArray[48] = 5;
        byArray[49] = -124;
        byArray[50] = 2;
        byArray[51] = -82;
        byArray[52] = -29;
        byArray[53] = 106;
        byArray[54] = -113;
        byArray[55] = -96;
        byArray[56] = 6;
        byArray[57] = 11;
        byArray[58] = -19;
        byArray[59] = -104;
        byArray[60] = 127;
        byArray[61] = -44;
        byArray[62] = -45;
        byArray[63] = 31;
        byArray[64] = -21;
        byArray[65] = 52;
        byArray[66] = 44;
        byArray[67] = 81;
        byArray[68] = -22;
        byArray[69] = -56;
        byArray[70] = 72;
        byArray[71] = -85;
        byArray[72] = -14;
        byArray[73] = 42;
        byArray[74] = 104;
        byArray[75] = -94;
        byArray[76] = -3;
        byArray[77] = 58;
        byArray[78] = -50;
        byArray[79] = -52;
        byArray[80] = -75;
        byArray[81] = 112;
        byArray[82] = 14;
        byArray[83] = 86;
        byArray[84] = 8;
        byArray[85] = 12;
        byArray[86] = 118;
        byArray[87] = 18;
        byArray[88] = -65;
        byArray[89] = 114;
        byArray[90] = 19;
        byArray[91] = 71;
        byArray[92] = -100;
        byArray[93] = -73;
        byArray[94] = 93;
        byArray[95] = -121;
        byArray[96] = 21;
        byArray[97] = -95;
        byArray[98] = -106;
        byArray[99] = 41;
        byArray[100] = 16;
        byArray[101] = 123;
        byArray[102] = -102;
        byArray[103] = -57;
        byArray[104] = -13;
        byArray[105] = -111;
        byArray[106] = 120;
        byArray[107] = 111;
        byArray[108] = -99;
        byArray[109] = -98;
        byArray[110] = -78;
        byArray[111] = -79;
        byArray[112] = 50;
        byArray[113] = 117;
        byArray[114] = 25;
        byArray[115] = 61;
        byArray[116] = -1;
        byArray[117] = 53;
        byArray[118] = -118;
        byArray[119] = 126;
        byArray[120] = 109;
        byArray[121] = 84;
        byArray[122] = -58;
        byArray[123] = -128;
        byArray[124] = -61;
        byArray[125] = -67;
        byArray[126] = 13;
        byArray[127] = 87;
        byArray[128] = -33;
        byArray[129] = -11;
        byArray[130] = 36;
        byArray[131] = -87;
        byArray[132] = 62;
        byArray[133] = -88;
        byArray[134] = 67;
        byArray[135] = -55;
        byArray[136] = -41;
        byArray[137] = 121;
        byArray[138] = -42;
        byArray[139] = -10;
        byArray[140] = 124;
        byArray[141] = 34;
        byArray[142] = -71;
        byArray[143] = 3;
        byArray[144] = -32;
        byArray[145] = 15;
        byArray[146] = -20;
        byArray[147] = -34;
        byArray[148] = 122;
        byArray[149] = -108;
        byArray[150] = -80;
        byArray[151] = -68;
        byArray[152] = -36;
        byArray[153] = -24;
        byArray[154] = 40;
        byArray[155] = 80;
        byArray[156] = 78;
        byArray[157] = 51;
        byArray[158] = 10;
        byArray[159] = 74;
        byArray[160] = -89;
        byArray[161] = -105;
        byArray[162] = 96;
        byArray[163] = 115;
        byArray[164] = 30;
        byArray[166] = 98;
        byArray[167] = 68;
        byArray[168] = 26;
        byArray[169] = -72;
        byArray[170] = 56;
        byArray[171] = -126;
        byArray[172] = 100;
        byArray[173] = -97;
        byArray[174] = 38;
        byArray[175] = 65;
        byArray[176] = -83;
        byArray[177] = 69;
        byArray[178] = 70;
        byArray[179] = -110;
        byArray[180] = 39;
        byArray[181] = 94;
        byArray[182] = 85;
        byArray[183] = 47;
        byArray[184] = -116;
        byArray[185] = -93;
        byArray[186] = -91;
        byArray[187] = 125;
        byArray[188] = 105;
        byArray[189] = -43;
        byArray[190] = -107;
        byArray[191] = 59;
        byArray[192] = 7;
        byArray[193] = 88;
        byArray[194] = -77;
        byArray[195] = 64;
        byArray[196] = -122;
        byArray[197] = -84;
        byArray[198] = 29;
        byArray[199] = -9;
        byArray[200] = 48;
        byArray[201] = 55;
        byArray[202] = 107;
        byArray[203] = -28;
        byArray[204] = -120;
        byArray[205] = -39;
        byArray[206] = -25;
        byArray[207] = -119;
        byArray[208] = -31;
        byArray[209] = 27;
        byArray[210] = -125;
        byArray[211] = 73;
        byArray[212] = 76;
        byArray[213] = 63;
        byArray[214] = -8;
        byArray[215] = -2;
        byArray[216] = -115;
        byArray[217] = 83;
        byArray[218] = -86;
        byArray[219] = -112;
        byArray[220] = -54;
        byArray[221] = -40;
        byArray[222] = -123;
        byArray[223] = 97;
        byArray[224] = 32;
        byArray[225] = 113;
        byArray[226] = 103;
        byArray[227] = -92;
        byArray[228] = 45;
        byArray[229] = 43;
        byArray[230] = 9;
        byArray[231] = 91;
        byArray[232] = -53;
        byArray[233] = -101;
        byArray[234] = 37;
        byArray[235] = -48;
        byArray[236] = -66;
        byArray[237] = -27;
        byArray[238] = 108;
        byArray[239] = 82;
        byArray[240] = 89;
        byArray[241] = -90;
        byArray[242] = 116;
        byArray[243] = -46;
        byArray[244] = -26;
        byArray[245] = -12;
        byArray[246] = -76;
        byArray[247] = -64;
        byArray[248] = -47;
        byArray[249] = 102;
        byArray[250] = -81;
        byArray[251] = -62;
        byArray[252] = 57;
        byArray[253] = 75;
        byArray[254] = 99;
        byArray[255] = -74;
        PI = byArray;
        byte[] byArray2 = new byte[256];
        byArray2[0] = -91;
        byArray2[1] = 45;
        byArray2[2] = 50;
        byArray2[3] = -113;
        byArray2[4] = 14;
        byArray2[5] = 48;
        byArray2[6] = 56;
        byArray2[7] = -64;
        byArray2[8] = 84;
        byArray2[9] = -26;
        byArray2[10] = -98;
        byArray2[11] = 57;
        byArray2[12] = 85;
        byArray2[13] = 126;
        byArray2[14] = 82;
        byArray2[15] = -111;
        byArray2[16] = 100;
        byArray2[17] = 3;
        byArray2[18] = 87;
        byArray2[19] = 90;
        byArray2[20] = 28;
        byArray2[21] = 96;
        byArray2[22] = 7;
        byArray2[23] = 24;
        byArray2[24] = 33;
        byArray2[25] = 114;
        byArray2[26] = -88;
        byArray2[27] = -47;
        byArray2[28] = 41;
        byArray2[29] = -58;
        byArray2[30] = -92;
        byArray2[31] = 63;
        byArray2[32] = -32;
        byArray2[33] = 39;
        byArray2[34] = -115;
        byArray2[35] = 12;
        byArray2[36] = -126;
        byArray2[37] = -22;
        byArray2[38] = -82;
        byArray2[39] = -76;
        byArray2[40] = -102;
        byArray2[41] = 99;
        byArray2[42] = 73;
        byArray2[43] = -27;
        byArray2[44] = 66;
        byArray2[45] = -28;
        byArray2[46] = 21;
        byArray2[47] = -73;
        byArray2[48] = -56;
        byArray2[49] = 6;
        byArray2[50] = 112;
        byArray2[51] = -99;
        byArray2[52] = 65;
        byArray2[53] = 117;
        byArray2[54] = 25;
        byArray2[55] = -55;
        byArray2[56] = -86;
        byArray2[57] = -4;
        byArray2[58] = 77;
        byArray2[59] = -65;
        byArray2[60] = 42;
        byArray2[61] = 115;
        byArray2[62] = -124;
        byArray2[63] = -43;
        byArray2[64] = -61;
        byArray2[65] = -81;
        byArray2[66] = 43;
        byArray2[67] = -122;
        byArray2[68] = -89;
        byArray2[69] = -79;
        byArray2[70] = -78;
        byArray2[71] = 91;
        byArray2[72] = 70;
        byArray2[73] = -45;
        byArray2[74] = -97;
        byArray2[75] = -3;
        byArray2[76] = -44;
        byArray2[77] = 15;
        byArray2[78] = -100;
        byArray2[79] = 47;
        byArray2[80] = -101;
        byArray2[81] = 67;
        byArray2[82] = -17;
        byArray2[83] = -39;
        byArray2[84] = 121;
        byArray2[85] = -74;
        byArray2[86] = 83;
        byArray2[87] = 127;
        byArray2[88] = -63;
        byArray2[89] = -16;
        byArray2[90] = 35;
        byArray2[91] = -25;
        byArray2[92] = 37;
        byArray2[93] = 94;
        byArray2[94] = -75;
        byArray2[95] = 30;
        byArray2[96] = -94;
        byArray2[97] = -33;
        byArray2[98] = -90;
        byArray2[99] = -2;
        byArray2[100] = -84;
        byArray2[101] = 34;
        byArray2[102] = -7;
        byArray2[103] = -30;
        byArray2[104] = 74;
        byArray2[105] = -68;
        byArray2[106] = 53;
        byArray2[107] = -54;
        byArray2[108] = -18;
        byArray2[109] = 120;
        byArray2[110] = 5;
        byArray2[111] = 107;
        byArray2[112] = 81;
        byArray2[113] = -31;
        byArray2[114] = 89;
        byArray2[115] = -93;
        byArray2[116] = -14;
        byArray2[117] = 113;
        byArray2[118] = 86;
        byArray2[119] = 17;
        byArray2[120] = 106;
        byArray2[121] = -119;
        byArray2[122] = -108;
        byArray2[123] = 101;
        byArray2[124] = -116;
        byArray2[125] = -69;
        byArray2[126] = 119;
        byArray2[127] = 60;
        byArray2[128] = 123;
        byArray2[129] = 40;
        byArray2[130] = -85;
        byArray2[131] = -46;
        byArray2[132] = 49;
        byArray2[133] = -34;
        byArray2[134] = -60;
        byArray2[135] = 95;
        byArray2[136] = -52;
        byArray2[137] = -49;
        byArray2[138] = 118;
        byArray2[139] = 44;
        byArray2[140] = -72;
        byArray2[141] = -40;
        byArray2[142] = 46;
        byArray2[143] = 54;
        byArray2[144] = -37;
        byArray2[145] = 105;
        byArray2[146] = -77;
        byArray2[147] = 20;
        byArray2[148] = -107;
        byArray2[149] = -66;
        byArray2[150] = 98;
        byArray2[151] = -95;
        byArray2[152] = 59;
        byArray2[153] = 22;
        byArray2[154] = 102;
        byArray2[155] = -23;
        byArray2[156] = 92;
        byArray2[157] = 108;
        byArray2[158] = 109;
        byArray2[159] = -83;
        byArray2[160] = 55;
        byArray2[161] = 97;
        byArray2[162] = 75;
        byArray2[163] = -71;
        byArray2[164] = -29;
        byArray2[165] = -70;
        byArray2[166] = -15;
        byArray2[167] = -96;
        byArray2[168] = -123;
        byArray2[169] = -125;
        byArray2[170] = -38;
        byArray2[171] = 71;
        byArray2[172] = -59;
        byArray2[173] = -80;
        byArray2[174] = 51;
        byArray2[175] = -6;
        byArray2[176] = -106;
        byArray2[177] = 111;
        byArray2[178] = 110;
        byArray2[179] = -62;
        byArray2[180] = -10;
        byArray2[181] = 80;
        byArray2[182] = -1;
        byArray2[183] = 93;
        byArray2[184] = -87;
        byArray2[185] = -114;
        byArray2[186] = 23;
        byArray2[187] = 27;
        byArray2[188] = -105;
        byArray2[189] = 125;
        byArray2[190] = -20;
        byArray2[191] = 88;
        byArray2[192] = -9;
        byArray2[193] = 31;
        byArray2[194] = -5;
        byArray2[195] = 124;
        byArray2[196] = 9;
        byArray2[197] = 13;
        byArray2[198] = 122;
        byArray2[199] = 103;
        byArray2[200] = 69;
        byArray2[201] = -121;
        byArray2[202] = -36;
        byArray2[203] = -24;
        byArray2[204] = 79;
        byArray2[205] = 29;
        byArray2[206] = 78;
        byArray2[207] = 4;
        byArray2[208] = -21;
        byArray2[209] = -8;
        byArray2[210] = -13;
        byArray2[211] = 62;
        byArray2[212] = 61;
        byArray2[213] = -67;
        byArray2[214] = -118;
        byArray2[215] = -120;
        byArray2[216] = -35;
        byArray2[217] = -51;
        byArray2[218] = 11;
        byArray2[219] = 19;
        byArray2[220] = -104;
        byArray2[221] = 2;
        byArray2[222] = -109;
        byArray2[223] = -128;
        byArray2[224] = -112;
        byArray2[225] = -48;
        byArray2[226] = 36;
        byArray2[227] = 52;
        byArray2[228] = -53;
        byArray2[229] = -19;
        byArray2[230] = -12;
        byArray2[231] = -50;
        byArray2[232] = -103;
        byArray2[233] = 16;
        byArray2[234] = 68;
        byArray2[235] = 64;
        byArray2[236] = -110;
        byArray2[237] = 58;
        byArray2[238] = 1;
        byArray2[239] = 38;
        byArray2[240] = 18;
        byArray2[241] = 26;
        byArray2[242] = 72;
        byArray2[243] = 104;
        byArray2[244] = -11;
        byArray2[245] = -127;
        byArray2[246] = -117;
        byArray2[247] = -57;
        byArray2[248] = -42;
        byArray2[249] = 32;
        byArray2[250] = 10;
        byArray2[251] = 8;
        byArray2[253] = 76;
        byArray2[254] = -41;
        byArray2[255] = 116;
        inversePI = byArray2;
        lFactors = new byte[]{-108, 32, -123, 16, -62, -64, 1, -5, 1, -64, -62, 16, -123, 32, -108, 1};
    }

    private static byte mulGF256(byte a, byte b) {
        byte p = 0;
        int counter = 0;
        while (counter < 8 && a != 0 && b != 0) {
            if ((b & 1) != 0) {
                p = (byte)(p ^ a);
            }
            boolean hiBitSet = (byte)(a & 0x80) != 0;
            a = (byte)(a << 1);
            if (hiBitSet) {
                a = (byte)(a ^ 0xC3);
            }
            b = (byte)(b >> 1);
            counter = (byte)(counter + 1);
        }
        return p;
    }

    public Kuznyechik() {
        this(Binary.Bin(32));
    }

    public Kuznyechik(Binary key) {
        super.initialize(16);
        this.setKey(key);
    }

    @Override
    public Kuznyechik clone() {
        return new Kuznyechik(this.key);
    }

    @Override
    public String getAlgName() {
        return "Kuznyechik";
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(32);
        this.setKey(k);
        return k;
    }

    private void XOR(byte[] res, byte[] a) {
        int i = 0;
        while (i < 16) {
            int n = i;
            res[n] = (byte)(res[n] ^ a[i]);
            ++i;
        }
    }

    private byte l(byte[] data) {
        byte x = data[15];
        int i = 14;
        while (i >= 0) {
            x = (byte)(x ^ GFMul[data[i] & 0xFF][lFactors[i] & 0xFF]);
            --i;
        }
        return x;
    }

    private void L(byte[] data) {
        int i = 0;
        while (i < 16) {
            byte z = this.l(data);
            System.arraycopy(data, 0, data, 1, 15);
            data[0] = z;
            ++i;
        }
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 32, "Invalid key size");
        this.key = key.clone();
        byte[] keyArr = key.getDataRef();
        System.arraycopy(keyArr, 0, this.x, 0, 16);
        System.arraycopy(keyArr, 0, this.wKey[0], 0, 16);
        System.arraycopy(keyArr, 16, this.y, 0, 16);
        System.arraycopy(keyArr, 16, this.wKey[1], 0, 16);
        int k = 1;
        while (k < 5) {
            int j = 1;
            while (j <= 8) {
                Arrays.fill(this.tmp, (byte)0);
                this.tmp[15] = (byte)(8 * (k - 1) + j);
                this.L(this.tmp);
                this.XOR(this.tmp, this.x);
                int i = 0;
                while (i < 16) {
                    this.tmp[i] = PI[this.tmp[i] & 0xFF];
                    ++i;
                }
                this.L(this.tmp);
                this.XOR(this.tmp, this.y);
                System.arraycopy(this.x, 0, this.y, 0, 16);
                System.arraycopy(this.tmp, 0, this.x, 0, 16);
                ++j;
            }
            System.arraycopy(this.x, 0, this.wKey[2 * k], 0, 16);
            System.arraycopy(this.y, 0, this.wKey[2 * k + 1], 0, 16);
            ++k;
        }
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int i = 0;
        while (i < 9) {
            this.XOR(arr, this.wKey[i]);
            int j = 0;
            while (j < 16) {
                arr[j] = PI[arr[j] & 0xFF];
                ++j;
            }
            this.L(arr);
            ++i;
        }
        this.XOR(arr, this.wKey[9]);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int i = 9;
        while (i > 0) {
            this.XOR(arr, this.wKey[i]);
            int k = 0;
            while (k < 16) {
                System.arraycopy(arr, 1, this.tmp, 0, 15);
                this.tmp[15] = arr[0];
                byte z = this.l(this.tmp);
                System.arraycopy(arr, 1, arr, 0, 15);
                arr[15] = z;
                ++k;
            }
            int j = 0;
            while (j < arr.length) {
                arr[j] = inversePI[arr[j] & 0xFF];
                ++j;
            }
            --i;
        }
        this.XOR(arr, this.wKey[0]);
    }
}

