/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class RC5_32
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;
    private int roundsNum;
    private int[] sKey;

    public RC5_32() {
        this(12, Binary.Bin(16));
    }

    public RC5_32(int roundsNumber) {
        this(roundsNumber, Binary.Bin(16));
    }

    public RC5_32(int roundsNumber, Binary key) {
        super.initialize(8);
        this.roundsNum = roundsNumber;
        this.sKey = new int[2 * (this.roundsNum + 1)];
        this.setKey(key);
    }

    @Override
    public RC5_32 clone() {
        return new RC5_32(this.roundsNum, this.key);
    }

    @Override
    public String getAlgName() {
        return "RC5-32";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() >= 1 && key.size() <= 255, "Invalid key size");
        this.key = key.clone();
        int[] L = new int[(key.size() + 3) / 4];
        int i = 0;
        while (i != key.size()) {
            int n = i / 4;
            L[n] = L[n] + (key.get(i) << 8 * (i % 4));
            ++i;
        }
        this.sKey[0] = -1209970333;
        i = 1;
        while (i < this.sKey.length) {
            this.sKey[i] = this.sKey[i - 1] + -1640531527;
            ++i;
        }
        int iter = L.length > this.sKey.length ? 3 * L.length : 3 * this.sKey.length;
        int A = 0;
        int B = 0;
        int i2 = 0;
        int j = 0;
        int k = 0;
        while (k < iter) {
            A = this.sKey[i2] = Integer.rotateLeft(this.sKey[i2] + A + B, 3);
            B = L[j] = Integer.rotateLeft(L[j] + A + B, A + B);
            i2 = (i2 + 1) % this.sKey.length;
            j = (j + 1) % L.length;
            ++k;
        }
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize >= 1 && keySize <= 255, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(16);
        this.setKey(k);
        return k;
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 8, "Incorrect block size");
        int A = block.getIntLE(0) + this.sKey[0];
        int B = block.getIntLE(4) + this.sKey[1];
        int i = 1;
        while (i <= this.roundsNum) {
            A = Integer.rotateLeft(A ^ B, B) + this.sKey[2 * i];
            B = Integer.rotateLeft(B ^ A, A) + this.sKey[2 * i + 1];
            ++i;
        }
        block.setIntLE(0, A);
        block.setIntLE(4, B);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 8, "Incorrect block size");
        int A = block.getIntLE(0);
        int B = block.getIntLE(4);
        int i = this.roundsNum;
        while (i >= 1) {
            B = Integer.rotateRight(B - this.sKey[2 * i + 1], A) ^ A;
            A = Integer.rotateRight(A - this.sKey[2 * i], B) ^ B;
            --i;
        }
        block.setIntLE(0, A - this.sKey[0]);
        block.setIntLE(4, B - this.sKey[1]);
    }
}

