/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class RC6
extends BlockCipher {
    public static final int BLOCK_SIZE = 16;
    private static final int roundsNum = 20;
    private int[] S = new int[44];
    private static final int P32 = -1209970333;
    private static final int Q32 = -1640531527;

    public RC6() {
        this(Binary.Bin(16));
    }

    public RC6(Binary key) {
        super.initialize(16);
        this.setKey(key);
    }

    @Override
    public RC6 clone() {
        return new RC6(this.key);
    }

    @Override
    public String getAlgName() {
        return "RC6";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16 || key.size() == 24 || key.size() == 32, "Invalid key size");
        this.key = key.clone();
        int c = (key.size() + 3) / 4;
        if (c == 0) {
            c = 1;
        }
        int[] L = new int[(key.size() + 3) / 4];
        int i = key.size() - 1;
        while (i >= 0) {
            L[i / 4] = (L[i / 4] << 8) + key.get(i);
            --i;
        }
        this.S[0] = -1209970333;
        i = 1;
        while (i < this.S.length) {
            this.S[i] = this.S[i - 1] + -1640531527;
            ++i;
        }
        int iter = L.length > this.S.length ? 3 * L.length : 3 * this.S.length;
        int A = 0;
        int B = 0;
        int i2 = 0;
        int j = 0;
        int k = 0;
        while (k < iter) {
            A = this.S[i2] = Integer.rotateLeft(this.S[i2] + A + B, 3);
            B = L[j] = Integer.rotateLeft(L[j] + A + B, A + B);
            i2 = (i2 + 1) % this.S.length;
            j = (j + 1) % L.length;
            ++k;
        }
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize == 16 || keySize == 24 || keySize == 32, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        return this.generateKey(16);
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        int A = block.getIntLE(0);
        int B = block.getIntLE(4);
        int C = block.getIntLE(8);
        int D = block.getIntLE(12);
        B += this.S[0];
        D += this.S[1];
        int i = 1;
        while (i <= 20) {
            int t = 0;
            int u = 0;
            t = B * (2 * B + 1);
            t = Integer.rotateLeft(t, 5);
            u = D * (2 * D + 1);
            u = Integer.rotateLeft(u, 5);
            A ^= t;
            A = Integer.rotateLeft(A, u);
            C ^= u;
            C = Integer.rotateLeft(C, t);
            int temp = A += this.S[2 * i];
            A = B;
            B = C += this.S[2 * i + 1];
            C = D;
            D = temp;
            ++i;
        }
        block.setIntLE(0, A += this.S[42]);
        block.setIntLE(4, B);
        block.setIntLE(8, C += this.S[43]);
        block.setIntLE(12, D);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 16, "Incorrect block size");
        int A = block.getIntLE(0);
        int B = block.getIntLE(4);
        int C = block.getIntLE(8);
        int D = block.getIntLE(12);
        C -= this.S[43];
        A -= this.S[42];
        int i = 20;
        while (i >= 1) {
            int t = 0;
            int u = 0;
            int temp = D;
            D = C;
            C = B;
            B = A;
            A = temp;
            t = B * (2 * B + 1);
            t = Integer.rotateLeft(t, 5);
            u = D * (2 * D + 1);
            u = Integer.rotateLeft(u, 5);
            C -= this.S[2 * i + 1];
            C = Integer.rotateRight(C, t);
            C ^= u;
            A -= this.S[2 * i];
            A = Integer.rotateRight(A, u);
            A ^= t;
            --i;
        }
        block.setIntLE(0, A);
        block.setIntLE(4, B -= this.S[0]);
        block.setIntLE(8, C);
        block.setIntLE(12, D -= this.S[1]);
    }
}

