/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import java.util.Arrays;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class Shacal2
extends BlockCipher {
    public static final int BLOCK_SIZE = 32;
    private int[] wKey = new int[64];
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public Shacal2() {
        this(Binary.Bin(16));
    }

    public Shacal2(Binary key) {
        super.initialize(32);
        this.setKey(key);
    }

    @Override
    public String getAlgName() {
        return "Shacal2";
    }

    @Override
    public Shacal2 clone() {
        return new Shacal2(this.key);
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() >= 16 && key.size() <= 64 && key.size() % 8 == 0, "Invalid key size");
        this.key = key.clone();
        Arrays.fill(this.wKey, 0);
        int i = 0;
        while (i < key.size() / 4) {
            this.wKey[i] = key.getIntBE(i << 2);
            ++i;
        }
        i = 16;
        while (i < 64) {
            this.wKey[i] = (Integer.rotateRight(this.wKey[i - 2], 17) ^ Integer.rotateRight(this.wKey[i - 2], 19) ^ this.wKey[i - 2] >>> 10) + this.wKey[i - 7] + (Integer.rotateRight(this.wKey[i - 15], 7) ^ Integer.rotateRight(this.wKey[i - 15], 18) ^ this.wKey[i - 15] >>> 3) + this.wKey[i - 16];
            ++i;
        }
    }

    public Binary generateKey(int keySize) {
        Ex.MUST(keySize >= 16 && keySize <= 64 && keySize % 8 == 0, "Invalid key size");
        Binary akey = new Binary().randomSecure(keySize);
        this.setKey(akey);
        return akey;
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(16);
        this.setKey(k);
        return k;
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 32, "Incorrect block size");
        this.encryptBlock(block, block.getDataRef(), 0, block.getDataRef(), 0);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 32, "Incorrect block size");
        byte[] arr = block.getDataRef();
        int b0 = Binary.getIntBE(arr, 0);
        int b1 = Binary.getIntBE(arr, 4);
        int b2 = Binary.getIntBE(arr, 8);
        int b3 = Binary.getIntBE(arr, 12);
        int b4 = Binary.getIntBE(arr, 16);
        int b5 = Binary.getIntBE(arr, 20);
        int b6 = Binary.getIntBE(arr, 24);
        int b7 = Binary.getIntBE(arr, 28);
        int i = 63;
        while (i >= 0) {
            int tmp = b0 - (Integer.rotateRight(b1, 2) ^ Integer.rotateRight(b1, 13) ^ Integer.rotateRight(b1, 22)) - (b1 & b2 ^ b1 & b3 ^ b2 & b3);
            b0 = b1;
            b1 = b2;
            b2 = b3;
            b3 = b4 - tmp;
            b4 = b5;
            b5 = b6;
            b6 = b7;
            b7 = tmp - K[i] - this.wKey[i] - (Integer.rotateRight(b4, 6) ^ Integer.rotateRight(b4, 11) ^ Integer.rotateRight(b4, 25)) - (b4 & b5 ^ ~b4 & b6);
            --i;
        }
        Binary.setIntBE(arr, 0, b0);
        Binary.setIntBE(arr, 4, b1);
        Binary.setIntBE(arr, 8, b2);
        Binary.setIntBE(arr, 12, b3);
        Binary.setIntBE(arr, 16, b4);
        Binary.setIntBE(arr, 20, b5);
        Binary.setIntBE(arr, 24, b6);
        Binary.setIntBE(arr, 28, b7);
    }

    private void encryptBlock(Binary block, byte[] in, int inOffset, byte[] out, int outOffset) {
        byte[] arr = block.getDataRef();
        int b0 = Binary.getIntBE(arr, 0);
        int b1 = Binary.getIntBE(arr, 4);
        int b2 = Binary.getIntBE(arr, 8);
        int b3 = Binary.getIntBE(arr, 12);
        int b4 = Binary.getIntBE(arr, 16);
        int b5 = Binary.getIntBE(arr, 20);
        int b6 = Binary.getIntBE(arr, 24);
        int b7 = Binary.getIntBE(arr, 28);
        int i = 0;
        while (i < 64) {
            int tmp = (Integer.rotateRight(b4, 6) ^ Integer.rotateRight(b4, 11) ^ Integer.rotateRight(b4, 25)) + (b4 & b5 ^ ~b4 & b6) + b7 + K[i] + this.wKey[i];
            b7 = b6;
            b6 = b5;
            b5 = b4;
            b4 = b3 + tmp;
            b3 = b2;
            b2 = b1;
            b1 = b0;
            b0 = tmp + (Integer.rotateRight(b0, 2) ^ Integer.rotateRight(b0, 13) ^ Integer.rotateRight(b0, 22)) + (b0 & b2 ^ b0 & b3 ^ b2 & b3);
            ++i;
        }
        Binary.setIntBE(arr, 0, b0);
        Binary.setIntBE(arr, 4, b1);
        Binary.setIntBE(arr, 8, b2);
        Binary.setIntBE(arr, 12, b3);
        Binary.setIntBE(arr, 16, b4);
        Binary.setIntBE(arr, 20, b5);
        Binary.setIntBE(arr, 24, b6);
        Binary.setIntBE(arr, 28, b7);
    }
}

