/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class Threefish1024
extends BlockCipher {
    public static final int BLOCK_SIZE = 128;
    public static final int KEY_SIZE = 128;
    private static final int BLOCK_SIZE_WORDS = 16;
    private static final int ROUNDS_NUM = 80;
    private static int[] MOD3 = new int[80];
    private static int[] MOD17 = new int[80];
    private long[] tw = new long[5];
    private long[] kw = new long[33];

    static {
        int i = 0;
        while (i < MOD3.length) {
            Threefish1024.MOD3[i] = i % 3;
            Threefish1024.MOD17[i] = i % 17;
            ++i;
        }
    }

    public Threefish1024() {
        this(Binary.Bin(128));
    }

    public Threefish1024(Binary key) {
        super.initialize(128);
        this.setKey(Binary.Bin(128));
    }

    @Override
    public Threefish1024 clone() {
        return new Threefish1024(this.key);
    }

    @Override
    public String getAlgName() {
        return "Threefish-1024";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 128, "Invalid key size");
        this.key = key.clone();
        byte[] arr = key.getDataRef();
        long knw = 2004413935125273122L;
        int i = 0;
        while (i < 16) {
            this.kw[i] = Binary.getLongLE(arr, i << 3);
            knw ^= this.kw[i];
            ++i;
        }
        this.kw[16] = knw;
        System.arraycopy(this.kw, 0, this.kw, 17, 16);
    }

    @Override
    public Binary generateKey() {
        Binary akey = new Binary().randomSecure(128);
        this.setKey(akey);
        return akey;
    }

    public void setTweak(Binary tweak) {
        Ex.MUST(tweak.size() == 16, "Incorrect tweak size");
        byte[] arr = tweak.getDataRef();
        this.tw[0] = Binary.getLongLE(arr, 0);
        this.tw[1] = Binary.getLongLE(arr, 8);
        this.tw[2] = this.tw[0] ^ this.tw[1];
        this.tw[3] = this.tw[0];
        this.tw[4] = this.tw[1];
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 128, "Incorrect block size");
        byte[] arr = block.getDataRef();
        long b0 = Binary.getLongLE(arr, 0) + this.kw[0];
        long b1 = Binary.getLongLE(arr, 8) + this.kw[1];
        long b2 = Binary.getLongLE(arr, 16) + this.kw[2];
        long b3 = Binary.getLongLE(arr, 24) + this.kw[3];
        long b4 = Binary.getLongLE(arr, 32) + this.kw[4];
        long b5 = Binary.getLongLE(arr, 40) + this.kw[5];
        long b6 = Binary.getLongLE(arr, 48) + this.kw[6];
        long b7 = Binary.getLongLE(arr, 56) + this.kw[7];
        long b8 = Binary.getLongLE(arr, 64) + this.kw[8];
        long b9 = Binary.getLongLE(arr, 72) + this.kw[9];
        long b10 = Binary.getLongLE(arr, 80) + this.kw[10];
        long b11 = Binary.getLongLE(arr, 88) + this.kw[11];
        long b12 = Binary.getLongLE(arr, 96) + this.kw[12];
        long b13 = Binary.getLongLE(arr, 104) + this.kw[13] + this.tw[0];
        long b14 = Binary.getLongLE(arr, 112) + this.kw[14] + this.tw[1];
        long b15 = Binary.getLongLE(arr, 120) + this.kw[15];
        int d = 1;
        while (d < 20) {
            int dm17 = MOD17[d];
            int dm3 = MOD3[d];
            b0 += b1;
            b1 = Long.rotateLeft(b1, 24) ^ b0;
            b2 += b3;
            b3 = Long.rotateLeft(b3, 13) ^ b2;
            b4 += b5;
            b5 = Long.rotateLeft(b5, 8) ^ b4;
            b6 += b7;
            b7 = Long.rotateLeft(b7, 47) ^ b6;
            b8 += b9;
            b9 = Long.rotateLeft(b9, 8) ^ b8;
            b10 += b11;
            b11 = Long.rotateLeft(b11, 17) ^ b10;
            b12 += b13;
            b13 = Long.rotateLeft(b13, 22) ^ b12;
            b14 += b15;
            b15 = Long.rotateLeft(b15, 37) ^ b14;
            b0 += b9;
            b9 = Long.rotateLeft(b9, 38) ^ b0;
            b2 += b13;
            b13 = Long.rotateLeft(b13, 19) ^ b2;
            b6 += b11;
            b11 = Long.rotateLeft(b11, 10) ^ b6;
            b4 += b15;
            b15 = Long.rotateLeft(b15, 55) ^ b4;
            b10 += b7;
            b7 = Long.rotateLeft(b7, 49) ^ b10;
            b12 += b3;
            b3 = Long.rotateLeft(b3, 18) ^ b12;
            b14 += b5;
            b5 = Long.rotateLeft(b5, 23) ^ b14;
            b8 += b1;
            b1 = Long.rotateLeft(b1, 52) ^ b8;
            b0 += b7;
            b7 = Long.rotateLeft(b7, 33) ^ b0;
            b2 += b5;
            b5 = Long.rotateLeft(b5, 4) ^ b2;
            b4 += b3;
            b3 = Long.rotateLeft(b3, 51) ^ b4;
            b6 += b1;
            b1 = Long.rotateLeft(b1, 13) ^ b6;
            b12 += b15;
            b15 = Long.rotateLeft(b15, 34) ^ b12;
            b14 += b13;
            b13 = Long.rotateLeft(b13, 41) ^ b14;
            b8 += b11;
            b11 = Long.rotateLeft(b11, 59) ^ b8;
            b10 += b9;
            b9 = Long.rotateLeft(b9, 17) ^ b10;
            b0 += b15;
            b15 = Long.rotateLeft(b15, 5) ^ b0;
            b2 += b11;
            b11 = Long.rotateLeft(b11, 20) ^ b2;
            b6 += b13;
            b13 = Long.rotateLeft(b13, 48) ^ b6;
            b4 += b9;
            b9 = Long.rotateLeft(b9, 41) ^ b4;
            b14 += b1;
            b1 = Long.rotateLeft(b1, 47) ^ b14;
            b8 += b5;
            b5 = Long.rotateLeft(b5, 28) ^ b8;
            b10 += b3;
            b3 = Long.rotateLeft(b3, 16) ^ b10;
            b12 += b7;
            b7 = Long.rotateLeft(b7, 25) ^ b12;
            b0 += this.kw[dm17];
            b1 += this.kw[dm17 + 1];
            b2 += this.kw[dm17 + 2];
            b3 += this.kw[dm17 + 3];
            b4 += this.kw[dm17 + 4];
            b5 += this.kw[dm17 + 5];
            b6 += this.kw[dm17 + 6];
            b7 += this.kw[dm17 + 7];
            b8 += this.kw[dm17 + 8];
            b9 += this.kw[dm17 + 9];
            b10 += this.kw[dm17 + 10];
            b11 += this.kw[dm17 + 11];
            b12 += this.kw[dm17 + 12];
            b13 += this.kw[dm17 + 13] + this.tw[dm3];
            b14 += this.kw[dm17 + 14] + this.tw[dm3 + 1];
            b15 += this.kw[dm17 + 15] + (long)d;
            b0 += b1;
            b1 = Long.rotateLeft(b1, 41) ^ b0;
            b2 += b3;
            b3 = Long.rotateLeft(b3, 9) ^ b2;
            b4 += b5;
            b5 = Long.rotateLeft(b5, 37) ^ b4;
            b6 += b7;
            b7 = Long.rotateLeft(b7, 31) ^ b6;
            b8 += b9;
            b9 = Long.rotateLeft(b9, 12) ^ b8;
            b10 += b11;
            b11 = Long.rotateLeft(b11, 47) ^ b10;
            b12 += b13;
            b13 = Long.rotateLeft(b13, 44) ^ b12;
            b14 += b15;
            b15 = Long.rotateLeft(b15, 30) ^ b14;
            b0 += b9;
            b9 = Long.rotateLeft(b9, 16) ^ b0;
            b2 += b13;
            b13 = Long.rotateLeft(b13, 34) ^ b2;
            b6 += b11;
            b11 = Long.rotateLeft(b11, 56) ^ b6;
            b4 += b15;
            b15 = Long.rotateLeft(b15, 51) ^ b4;
            b10 += b7;
            b7 = Long.rotateLeft(b7, 4) ^ b10;
            b12 += b3;
            b3 = Long.rotateLeft(b3, 53) ^ b12;
            b14 += b5;
            b5 = Long.rotateLeft(b5, 42) ^ b14;
            b8 += b1;
            b1 = Long.rotateLeft(b1, 41) ^ b8;
            b0 += b7;
            b7 = Long.rotateLeft(b7, 31) ^ b0;
            b2 += b5;
            b5 = Long.rotateLeft(b5, 44) ^ b2;
            b4 += b3;
            b3 = Long.rotateLeft(b3, 47) ^ b4;
            b6 += b1;
            b1 = Long.rotateLeft(b1, 46) ^ b6;
            b12 += b15;
            b15 = Long.rotateLeft(b15, 19) ^ b12;
            b14 += b13;
            b13 = Long.rotateLeft(b13, 42) ^ b14;
            b8 += b11;
            b11 = Long.rotateLeft(b11, 44) ^ b8;
            b10 += b9;
            b9 = Long.rotateLeft(b9, 25) ^ b10;
            b0 += b15;
            b15 = Long.rotateLeft(b15, 9) ^ b0;
            b2 += b11;
            b11 = Long.rotateLeft(b11, 48) ^ b2;
            b6 += b13;
            b13 = Long.rotateLeft(b13, 35) ^ b6;
            b4 += b9;
            b9 = Long.rotateLeft(b9, 52) ^ b4;
            b14 += b1;
            b1 = Long.rotateLeft(b1, 23) ^ b14;
            b8 += b5;
            b5 = Long.rotateLeft(b5, 31) ^ b8;
            b10 += b3;
            b3 = Long.rotateLeft(b3, 37) ^ b10;
            b12 += b7;
            b7 = Long.rotateLeft(b7, 20) ^ b12;
            b0 += this.kw[dm17 + 1];
            b1 += this.kw[dm17 + 2];
            b2 += this.kw[dm17 + 3];
            b3 += this.kw[dm17 + 4];
            b4 += this.kw[dm17 + 5];
            b5 += this.kw[dm17 + 6];
            b6 += this.kw[dm17 + 7];
            b7 += this.kw[dm17 + 8];
            b8 += this.kw[dm17 + 9];
            b9 += this.kw[dm17 + 10];
            b10 += this.kw[dm17 + 11];
            b11 += this.kw[dm17 + 12];
            b12 += this.kw[dm17 + 13];
            b13 += this.kw[dm17 + 14] + this.tw[dm3 + 1];
            b14 += this.kw[dm17 + 15] + this.tw[dm3 + 2];
            b15 += this.kw[dm17 + 16] + (long)d + 1L;
            d += 2;
        }
        Binary.setLongLE(arr, 0, b0);
        Binary.setLongLE(arr, 8, b1);
        Binary.setLongLE(arr, 16, b2);
        Binary.setLongLE(arr, 24, b3);
        Binary.setLongLE(arr, 32, b4);
        Binary.setLongLE(arr, 40, b5);
        Binary.setLongLE(arr, 48, b6);
        Binary.setLongLE(arr, 56, b7);
        Binary.setLongLE(arr, 64, b8);
        Binary.setLongLE(arr, 72, b9);
        Binary.setLongLE(arr, 80, b10);
        Binary.setLongLE(arr, 88, b11);
        Binary.setLongLE(arr, 96, b12);
        Binary.setLongLE(arr, 104, b13);
        Binary.setLongLE(arr, 112, b14);
        Binary.setLongLE(arr, 120, b15);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 128, "Incorrect block size");
        byte[] arr = block.getDataRef();
        long b0 = Binary.getLongLE(arr, 0);
        long b1 = Binary.getLongLE(arr, 8);
        long b2 = Binary.getLongLE(arr, 16);
        long b3 = Binary.getLongLE(arr, 24);
        long b4 = Binary.getLongLE(arr, 32);
        long b5 = Binary.getLongLE(arr, 40);
        long b6 = Binary.getLongLE(arr, 48);
        long b7 = Binary.getLongLE(arr, 56);
        long b8 = Binary.getLongLE(arr, 64);
        long b9 = Binary.getLongLE(arr, 72);
        long b10 = Binary.getLongLE(arr, 80);
        long b11 = Binary.getLongLE(arr, 88);
        long b12 = Binary.getLongLE(arr, 96);
        long b13 = Binary.getLongLE(arr, 104);
        long b14 = Binary.getLongLE(arr, 112);
        long b15 = Binary.getLongLE(arr, 120);
        int d = 19;
        while (d >= 1) {
            int dm17 = MOD17[d];
            int dm3 = MOD3[d];
            b0 -= this.kw[dm17 + 1];
            b1 -= this.kw[dm17 + 2];
            b2 -= this.kw[dm17 + 3];
            b3 -= this.kw[dm17 + 4];
            b4 -= this.kw[dm17 + 5];
            b5 -= this.kw[dm17 + 6];
            b6 -= this.kw[dm17 + 7];
            b7 -= this.kw[dm17 + 8];
            b8 -= this.kw[dm17 + 9];
            b9 -= this.kw[dm17 + 10];
            b10 -= this.kw[dm17 + 11];
            b11 -= this.kw[dm17 + 12];
            b12 -= this.kw[dm17 + 13];
            b13 -= this.kw[dm17 + 14] + this.tw[dm3 + 1];
            b14 -= this.kw[dm17 + 15] + this.tw[dm3 + 2];
            b15 -= this.kw[dm17 + 16] + (long)d + 1L;
            b15 = Long.rotateRight(b15 ^ b0, 9);
            b0 -= b15;
            b11 = Long.rotateRight(b11 ^ b2, 48);
            b2 -= b11;
            b13 = Long.rotateRight(b13 ^ b6, 35);
            b6 -= b13;
            b9 = Long.rotateRight(b9 ^ b4, 52);
            b4 -= b9;
            b1 = Long.rotateRight(b1 ^ b14, 23);
            b14 -= b1;
            b5 = Long.rotateRight(b5 ^ b8, 31);
            b8 -= b5;
            b3 = Long.rotateRight(b3 ^ b10, 37);
            b10 -= b3;
            b7 = Long.rotateRight(b7 ^ b12, 20);
            b12 -= b7;
            b7 = Long.rotateRight(b7 ^ b0, 31);
            b0 -= b7;
            b5 = Long.rotateRight(b5 ^ b2, 44);
            b2 -= b5;
            b3 = Long.rotateRight(b3 ^ b4, 47);
            b4 -= b3;
            b1 = Long.rotateRight(b1 ^ b6, 46);
            b6 -= b1;
            b15 = Long.rotateRight(b15 ^ b12, 19);
            b12 -= b15;
            b13 = Long.rotateRight(b13 ^ b14, 42);
            b14 -= b13;
            b11 = Long.rotateRight(b11 ^ b8, 44);
            b8 -= b11;
            b9 = Long.rotateRight(b9 ^ b10, 25);
            b10 -= b9;
            b9 = Long.rotateRight(b9 ^ b0, 16);
            b0 -= b9;
            b13 = Long.rotateRight(b13 ^ b2, 34);
            b2 -= b13;
            b11 = Long.rotateRight(b11 ^ b6, 56);
            b6 -= b11;
            b15 = Long.rotateRight(b15 ^ b4, 51);
            b4 -= b15;
            b7 = Long.rotateRight(b7 ^ b10, 4);
            b10 -= b7;
            b3 = Long.rotateRight(b3 ^ b12, 53);
            b12 -= b3;
            b5 = Long.rotateRight(b5 ^ b14, 42);
            b14 -= b5;
            b1 = Long.rotateRight(b1 ^ b8, 41);
            b8 -= b1;
            b1 = Long.rotateRight(b1 ^ b0, 41);
            b0 -= b1;
            b3 = Long.rotateRight(b3 ^ b2, 9);
            b2 -= b3;
            b5 = Long.rotateRight(b5 ^ b4, 37);
            b4 -= b5;
            b7 = Long.rotateRight(b7 ^ b6, 31);
            b6 -= b7;
            b9 = Long.rotateRight(b9 ^ b8, 12);
            b8 -= b9;
            b11 = Long.rotateRight(b11 ^ b10, 47);
            b10 -= b11;
            b13 = Long.rotateRight(b13 ^ b12, 44);
            b12 -= b13;
            b15 = Long.rotateRight(b15 ^ b14, 30);
            b14 -= b15;
            b0 -= this.kw[dm17];
            b1 -= this.kw[dm17 + 1];
            b2 -= this.kw[dm17 + 2];
            b3 -= this.kw[dm17 + 3];
            b4 -= this.kw[dm17 + 4];
            b5 -= this.kw[dm17 + 5];
            b6 -= this.kw[dm17 + 6];
            b7 -= this.kw[dm17 + 7];
            b8 -= this.kw[dm17 + 8];
            b9 -= this.kw[dm17 + 9];
            b10 -= this.kw[dm17 + 10];
            b11 -= this.kw[dm17 + 11];
            b12 -= this.kw[dm17 + 12];
            b13 -= this.kw[dm17 + 13] + this.tw[dm3];
            b14 -= this.kw[dm17 + 14] + this.tw[dm3 + 1];
            b15 -= this.kw[dm17 + 15] + (long)d;
            b15 = Long.rotateRight(b15 ^ b0, 5);
            b0 -= b15;
            b11 = Long.rotateRight(b11 ^ b2, 20);
            b2 -= b11;
            b13 = Long.rotateRight(b13 ^ b6, 48);
            b6 -= b13;
            b9 = Long.rotateRight(b9 ^ b4, 41);
            b4 -= b9;
            b1 = Long.rotateRight(b1 ^ b14, 47);
            b14 -= b1;
            b5 = Long.rotateRight(b5 ^ b8, 28);
            b8 -= b5;
            b3 = Long.rotateRight(b3 ^ b10, 16);
            b10 -= b3;
            b7 = Long.rotateRight(b7 ^ b12, 25);
            b12 -= b7;
            b7 = Long.rotateRight(b7 ^ b0, 33);
            b0 -= b7;
            b5 = Long.rotateRight(b5 ^ b2, 4);
            b2 -= b5;
            b3 = Long.rotateRight(b3 ^ b4, 51);
            b4 -= b3;
            b1 = Long.rotateRight(b1 ^ b6, 13);
            b6 -= b1;
            b15 = Long.rotateRight(b15 ^ b12, 34);
            b12 -= b15;
            b13 = Long.rotateRight(b13 ^ b14, 41);
            b14 -= b13;
            b11 = Long.rotateRight(b11 ^ b8, 59);
            b8 -= b11;
            b9 = Long.rotateRight(b9 ^ b10, 17);
            b10 -= b9;
            b9 = Long.rotateRight(b9 ^ b0, 38);
            b0 -= b9;
            b13 = Long.rotateRight(b13 ^ b2, 19);
            b2 -= b13;
            b11 = Long.rotateRight(b11 ^ b6, 10);
            b6 -= b11;
            b15 = Long.rotateRight(b15 ^ b4, 55);
            b4 -= b15;
            b7 = Long.rotateRight(b7 ^ b10, 49);
            b10 -= b7;
            b3 = Long.rotateRight(b3 ^ b12, 18);
            b12 -= b3;
            b5 = Long.rotateRight(b5 ^ b14, 23);
            b14 -= b5;
            b1 = Long.rotateRight(b1 ^ b8, 52);
            b8 -= b1;
            b1 = Long.rotateRight(b1 ^ b0, 24);
            b0 -= b1;
            b3 = Long.rotateRight(b3 ^ b2, 13);
            b2 -= b3;
            b5 = Long.rotateRight(b5 ^ b4, 8);
            b4 -= b5;
            b7 = Long.rotateRight(b7 ^ b6, 47);
            b6 -= b7;
            b9 = Long.rotateRight(b9 ^ b8, 8);
            b8 -= b9;
            b11 = Long.rotateRight(b11 ^ b10, 17);
            b10 -= b11;
            b13 = Long.rotateRight(b13 ^ b12, 22);
            b12 -= b13;
            b15 = Long.rotateRight(b15 ^ b14, 37);
            b14 -= b15;
            d -= 2;
        }
        Binary.setLongLE(arr, 0, b0 - this.kw[0]);
        Binary.setLongLE(arr, 8, b1 - this.kw[1]);
        Binary.setLongLE(arr, 16, b2 - this.kw[2]);
        Binary.setLongLE(arr, 24, b3 - this.kw[3]);
        Binary.setLongLE(arr, 32, b4 - this.kw[4]);
        Binary.setLongLE(arr, 40, b5 - this.kw[5]);
        Binary.setLongLE(arr, 48, b6 - this.kw[6]);
        Binary.setLongLE(arr, 56, b7 - this.kw[7]);
        Binary.setLongLE(arr, 64, b8 - this.kw[8]);
        Binary.setLongLE(arr, 72, b9 - this.kw[9]);
        Binary.setLongLE(arr, 80, b10 - this.kw[10]);
        Binary.setLongLE(arr, 88, b11 - this.kw[11]);
        Binary.setLongLE(arr, 96, b12 - this.kw[12]);
        Binary.setLongLE(arr, 104, b13 - this.kw[13] - this.tw[0]);
        Binary.setLongLE(arr, 112, b14 - this.kw[14] - this.tw[1]);
        Binary.setLongLE(arr, 120, b15 - this.kw[15]);
    }
}

