/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class Threefish256
extends BlockCipher {
    public static final int BLOCK_SIZE = 32;
    public static final int KEY_SIZE = 32;
    private static final int BLOCK_SIZE_WORDS = 4;
    private static final int ROUNDS_NUM = 72;
    private static int[] MOD5 = new int[72];
    private static int[] MOD3 = new int[72];
    private long[] tw = new long[5];
    private long[] kw = new long[9];

    static {
        int i = 0;
        while (i < MOD5.length) {
            Threefish256.MOD5[i] = i % 5;
            Threefish256.MOD3[i] = i % 3;
            ++i;
        }
    }

    public Threefish256() {
        this(Binary.Bin(32));
    }

    public Threefish256(Binary key) {
        super.initialize(32);
        this.setKey(Binary.Bin(32));
    }

    @Override
    public Threefish256 clone() {
        return new Threefish256(this.key);
    }

    @Override
    public String getAlgName() {
        return "Threefish-256";
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 32, "Invalid key size");
        this.key = key.clone();
        long knw = 2004413935125273122L;
        int i = 0;
        while (i < 4) {
            this.kw[i] = key.getLongLE(i << 3);
            knw ^= this.kw[i];
            ++i;
        }
        this.kw[4] = knw;
        System.arraycopy(this.kw, 0, this.kw, 5, 4);
    }

    @Override
    public Binary generateKey() {
        Binary akey = new Binary().randomSecure(32);
        this.setKey(akey);
        return akey;
    }

    public void setTweak(Binary tweak) {
        Ex.MUST(tweak.size() == 16, "Incorrect tweak size");
        byte[] arr = tweak.getDataRef();
        this.tw[0] = Binary.getLongLE(arr, 0);
        this.tw[1] = Binary.getLongLE(arr, 8);
        this.tw[2] = this.tw[0] ^ this.tw[1];
        this.tw[3] = this.tw[0];
        this.tw[4] = this.tw[1];
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 32, "Incorrect block size");
        byte[] arr = block.getDataRef();
        long b0 = Binary.getLongLE(arr, 0);
        long b1 = Binary.getLongLE(arr, 8);
        long b2 = Binary.getLongLE(arr, 16);
        long b3 = Binary.getLongLE(arr, 24);
        b0 += this.kw[0];
        b1 += this.kw[1] + this.tw[0];
        b2 += this.kw[2] + this.tw[1];
        b3 += this.kw[3];
        int d = 1;
        while (d < 18) {
            int dm5 = MOD5[d];
            int dm3 = MOD3[d];
            b0 += b1;
            b1 = Long.rotateLeft(b1, 14) ^ b0;
            b2 += b3;
            b3 = Long.rotateLeft(b3, 16) ^ b2;
            b0 += b3;
            b3 = Long.rotateLeft(b3, 52) ^ b0;
            b2 += b1;
            b1 = Long.rotateLeft(b1, 57) ^ b2;
            b0 += b1;
            b1 = Long.rotateLeft(b1, 23) ^ b0;
            b2 += b3;
            b3 = Long.rotateLeft(b3, 40) ^ b2;
            b0 += b3;
            b3 = Long.rotateLeft(b3, 5) ^ b0;
            b2 += b1;
            b1 = Long.rotateLeft(b1, 37) ^ b2;
            b0 += this.kw[dm5];
            b2 += this.kw[dm5 + 2] + this.tw[dm3 + 1];
            b1 = Long.rotateLeft(b1, 25) ^ (b0 += (b1 += this.kw[dm5 + 1] + this.tw[dm3]));
            b3 = Long.rotateLeft(b3, 33) ^ (b2 += (b3 += this.kw[dm5 + 3] + (long)d));
            b0 += b3;
            b3 = Long.rotateLeft(b3, 46) ^ b0;
            b2 += b1;
            b1 = Long.rotateLeft(b1, 12) ^ b2;
            b0 += b1;
            b1 = Long.rotateLeft(b1, 58) ^ b0;
            b2 += b3;
            b3 = Long.rotateLeft(b3, 22) ^ b2;
            b0 += b3;
            b3 = Long.rotateLeft(b3, 32) ^ b0;
            b2 += b1;
            b1 = Long.rotateLeft(b1, 32) ^ b2;
            b0 += this.kw[dm5 + 1];
            b1 += this.kw[dm5 + 2] + this.tw[dm3 + 1];
            b2 += this.kw[dm5 + 3] + this.tw[dm3 + 2];
            b3 += this.kw[dm5 + 4] + (long)d + 1L;
            d += 2;
        }
        Binary.setLongLE(arr, 0, b0);
        Binary.setLongLE(arr, 8, b1);
        Binary.setLongLE(arr, 16, b2);
        Binary.setLongLE(arr, 24, b3);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 32, "Incorrect block size");
        byte[] arr = block.getDataRef();
        long b0 = Binary.getLongLE(arr, 0);
        long b1 = Binary.getLongLE(arr, 8);
        long b2 = Binary.getLongLE(arr, 16);
        long b3 = Binary.getLongLE(arr, 24);
        int d = 17;
        while (d >= 1) {
            int dm5 = MOD5[d];
            int dm3 = MOD3[d];
            b1 -= this.kw[dm5 + 2] + this.tw[dm3 + 1];
            b3 -= this.kw[dm5 + 4] + (long)d + 1L;
            b3 = Long.rotateRight(b3 ^ (b0 -= this.kw[dm5 + 1]), 32);
            b1 = Long.rotateRight(b1 ^ (b2 -= this.kw[dm5 + 3] + this.tw[dm3 + 2]), 32);
            b2 -= b1;
            b1 = Long.rotateRight(b1 ^ (b0 -= b3), 58);
            b3 = Long.rotateRight(b3 ^ b2, 22);
            b2 -= b3;
            b3 = Long.rotateRight(b3 ^ (b0 -= b1), 46);
            b1 = Long.rotateRight(b1 ^ b2, 12);
            b2 -= b1;
            b1 = Long.rotateRight(b1 ^ (b0 -= b3), 25);
            b0 -= b1;
            b3 = Long.rotateRight(b3 ^ b2, 33);
            b2 -= b3;
            b1 -= this.kw[dm5 + 1] + this.tw[dm3];
            b3 -= this.kw[dm5 + 3] + (long)d;
            b3 = Long.rotateRight(b3 ^ (b0 -= this.kw[dm5]), 5);
            b1 = Long.rotateRight(b1 ^ (b2 -= this.kw[dm5 + 2] + this.tw[dm3 + 1]), 37);
            b2 -= b1;
            b1 = Long.rotateRight(b1 ^ (b0 -= b3), 23);
            b3 = Long.rotateRight(b3 ^ b2, 40);
            b2 -= b3;
            b3 = Long.rotateRight(b3 ^ (b0 -= b1), 52);
            b1 = Long.rotateRight(b1 ^ b2, 57);
            b2 -= b1;
            b1 = Long.rotateRight(b1 ^ (b0 -= b3), 14);
            b0 -= b1;
            b3 = Long.rotateRight(b3 ^ b2, 16);
            b2 -= b3;
            d -= 2;
        }
        Binary.setLongLE(arr, 0, b0 - this.kw[0]);
        Binary.setLongLE(arr, 8, b1 - this.kw[1] - this.tw[0]);
        Binary.setLongLE(arr, 16, b2 - this.kw[2] - this.tw[1]);
        Binary.setLongLE(arr, 24, b3 - this.kw[3]);
    }
}

