/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.blockcipher;

import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.blockcipher.BlockCipher;

public class XTEA
extends BlockCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 16;
    private static final int ROUNDS = 32;
    private static final int DELTA = -1640531527;
    private int[] sKey = new int[4];
    private int[] sum0 = new int[32];
    private int[] sum1 = new int[32];

    public XTEA() {
        this(Binary.Bin(16));
    }

    public XTEA(Binary key) {
        super.initialize(8);
        this.setKey(key);
    }

    @Override
    public XTEA clone() {
        return new XTEA(this.key);
    }

    @Override
    public String getAlgName() {
        return "XTEA";
    }

    @Override
    public Binary generateKey() {
        Binary k = new Binary().randomSecure(16);
        this.setKey(k);
        return k;
    }

    @Override
    public void setKey(Binary key) {
        Ex.MUST(key.size() == 16, "Invalid key size");
        this.key = key.clone();
        int i = 0;
        int j = 0;
        while (i < 4) {
            this.sKey[i] = key.getIntBE(j);
            ++i;
            j += 4;
        }
        i = 0;
        j = 0;
        while (i < 32) {
            this.sum0[i] = j + this.sKey[j & 3];
            this.sum1[i] = (j += -1640531527) + this.sKey[j >>> 11 & 3];
            ++i;
        }
    }

    @Override
    public void encryptBlock(Binary block) {
        Ex.MUST(block.size() == 8, "Incorrect block size");
        int v0 = block.getIntBE(0);
        int v1 = block.getIntBE(4);
        int i = 0;
        while (i < 32) {
            v1 += ((v0 += (v1 << 4 ^ v1 >>> 5) + v1 ^ this.sum0[i]) << 4 ^ v0 >>> 5) + v0 ^ this.sum1[i];
            ++i;
        }
        block.setIntBE(0, v0);
        block.setIntBE(4, v1);
    }

    @Override
    public void decryptBlock(Binary block) {
        Ex.MUST(block.size() == 8, "Incorrect block size");
        int v0 = block.getIntBE(0);
        int v1 = block.getIntBE(4);
        int i = 31;
        while (i >= 0) {
            v0 -= ((v1 -= (v0 << 4 ^ v0 >>> 5) + v0 ^ this.sum1[i]) << 4 ^ v1 >>> 5) + v1 ^ this.sum0[i];
            --i;
        }
        block.setIntBE(0, v0);
        block.setIntBE(4, v1);
    }
}

