/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec;

import java.math.BigInteger;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.Int;
import org.denom.crypt.ec.Nat;

public abstract class ECCurve {
    private String oid;
    private ECElement a;
    private ECElement b;
    private BigInteger order;
    private BigInteger cofactor;
    private ECPoint G;
    private ECPoint infinity;
    protected ECElement myElement;
    private static final int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};

    protected ECCurve() {
    }

    public static BigInteger Hex2BigInt(String hexStr) {
        return new BigInteger(1, new Binary(hexStr).getBytes());
    }

    public static Binary BigInt2Bin(int len, BigInteger bi) {
        byte[] bytes = bi.toByteArray();
        if (bytes.length == len) {
            return Binary.Bin(bytes);
        }
        int start = 0;
        int count = bytes.length;
        if (bytes[0] == 0) {
            start = 1;
            count = bytes.length - 1;
        }
        Ex.MUST(count <= len, "standard length exceeded for value");
        Binary res = Binary.Bin(len);
        res.set(len - count, bytes, start, count);
        return res;
    }

    protected void init(ECElement element, ECPoint infinity, String oid, String aHex, String bHex, String orderHex, String cofactorHex, String gPointHex) {
        this.myElement = element;
        this.infinity = infinity;
        this.oid = oid;
        this.a = this.fromBigInteger(ECCurve.Hex2BigInt(aHex));
        this.b = this.fromBigInteger(ECCurve.Hex2BigInt(bHex));
        this.order = ECCurve.Hex2BigInt(orderHex);
        this.cofactor = ECCurve.Hex2BigInt(cofactorHex);
        this.G = this.decodePoint(Binary.Bin(gPointHex));
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public final String getOid() {
        return this.oid;
    }

    public final ECPoint getG() {
        return this.G;
    }

    public final ECElement getA() {
        return this.a;
    }

    public final ECElement getB() {
        return this.b;
    }

    public final BigInteger getOrder() {
        return this.order;
    }

    public final BigInteger getCofactor() {
        return this.cofactor;
    }

    public final ECElement fromBigInteger(BigInteger x) {
        return this.myElement.create(x);
    }

    protected final ECPoint createRawPoint(ECElement x, ECElement y) {
        return this.infinity.create(x, y);
    }

    protected final ECPoint createRawPoint(ECElement x, ECElement y, ECElement[] zs) {
        return this.infinity.create(x, y, zs);
    }

    public ECPoint createPoint(BigInteger x, BigInteger y) {
        return this.infinity.create(this.fromBigInteger(x), this.fromBigInteger(y));
    }

    public abstract int getFieldSize();

    protected abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECPoint importPoint(ECPoint p) {
        if (this == p.getCurve()) {
            return p;
        }
        if (p.isInfinity()) {
            return this.getInfinity();
        }
        p = p.normalize();
        return this.createPoint(p.getXCoord().toBigInteger(), p.getYCoord().toBigInteger());
    }

    public ECPoint cleanPoint(ECPoint p) {
        return this.decodePoint(p.getEncoded(false));
    }

    private static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] mag = buf;
        if (off != 0 || length != buf.length) {
            mag = new byte[length];
            System.arraycopy(buf, off, mag, 0, length);
        }
        return new BigInteger(1, mag);
    }

    public ECPoint decodePoint(Binary encoded) {
        ECPoint p = null;
        int expectedLength = (this.getFieldSize() + 7) / 8;
        int type = encoded.get(0);
        switch (type) {
            case 0: {
                Ex.MUST(encoded.size() == 1, "Incorrect length for infinity encoding");
                p = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                Ex.MUST(encoded.size() == expectedLength + 1, "Incorrect length for compressed encoding");
                int yTilde = type & 1;
                BigInteger X = ECCurve.fromUnsignedByteArray(encoded.getBytes(), 1, expectedLength);
                p = this.decompressPoint(yTilde, X);
                break;
            }
            case 4: {
                Ex.MUST(encoded.size() == 2 * expectedLength + 1, "Incorrect length for uncompressed encoding");
                BigInteger X = ECCurve.fromUnsignedByteArray(encoded.getBytes(), 1, expectedLength);
                BigInteger Y = ECCurve.fromUnsignedByteArray(encoded.getBytes(), 1 + expectedLength, expectedLength);
                p = this.createPoint(X, Y);
                break;
            }
            case 6: 
            case 7: {
                Ex.MUST(encoded.size() == 2 * expectedLength + 1, "Incorrect length for uncompressed encoding");
                BigInteger X = ECCurve.fromUnsignedByteArray(encoded.getBytes(), 1, expectedLength);
                BigInteger Y = ECCurve.fromUnsignedByteArray(encoded.getBytes(), 1 + expectedLength, expectedLength);
                Ex.MUST(Y.testBit(0) == (type == 7), "Inconsistent Y coordinate in hybrid encoding");
                p = this.createPoint(X, Y);
                break;
            }
            default: {
                Ex.THROW("Invalid point encoding 0x" + Integer.toString(type, 16));
            }
        }
        Ex.MUST(p.isValid(), "Invalid point");
        Ex.MUST(type == 0 || !p.isInfinity(), "Invalid infinity encoding");
        return p;
    }

    public ECPoint GMul(BigInteger k) {
        return this.G.multiplyComb(k);
    }

    public ECPoint sumOfTwoMultiplies(ECPoint P, BigInteger a, ECPoint Q, BigInteger b) {
        Q = this.importPoint(Q);
        return ECCurve.implShamirsTrickWNaf(P, a, Q, b);
    }

    public boolean equals(ECCurve other) {
        return this == other || other != null && this.getOrder().equals(other.getOrder()) && this.a.toBigInteger().equals(other.a.toBigInteger()) && this.b.toBigInteger().equals(other.b.toBigInteger());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ECCurve && this.equals((ECCurve)obj);
    }

    public int hashCode() {
        return this.getOrder().hashCode() ^ Integer.rotateLeft(this.a.toBigInteger().hashCode(), 8) ^ Integer.rotateLeft(this.b.toBigInteger().hashCode(), 16);
    }

    static int getNafWeight(BigInteger k) {
        if (k.signum() == 0) {
            return 0;
        }
        BigInteger _3k = k.shiftLeft(1).add(k);
        BigInteger diff = _3k.xor(k);
        return diff.bitCount();
    }

    private static int[] generateCompactNaf(BigInteger k) {
        Ex.MUST(k.bitLength() >>> 16 == 0, "'k' must have bitlength < 2^16");
        if (k.signum() == 0) {
            return new int[0];
        }
        BigInteger _3k = k.shiftLeft(1).add(k);
        int bits = _3k.bitLength();
        int[] naf = new int[bits >> 1];
        BigInteger diff = _3k.xor(k);
        int highBit = bits - 1;
        int length = 0;
        int zeroes = 0;
        int i = 1;
        while (i < highBit) {
            if (!diff.testBit(i)) {
                ++zeroes;
            } else {
                int digit = k.testBit(i) ? -1 : 1;
                naf[length++] = digit << 16 | zeroes;
                zeroes = 1;
                ++i;
            }
            ++i;
        }
        naf[length++] = 0x10000 | zeroes;
        if (naf.length > length) {
            naf = ECCurve.trim(naf, length);
        }
        return naf;
    }

    private static int[] generateCompactWindowNaf(int width, BigInteger k) {
        if (width == 2) {
            return ECCurve.generateCompactNaf(k);
        }
        Ex.MUST(width >= 2 && width <= 16, "'width' must be in the range [2, 16]");
        Ex.MUST(Int.isU16(k.bitLength()), "'k' must have bitlength < 2^16");
        if (k.signum() == 0) {
            return new int[0];
        }
        int[] wnaf = new int[k.bitLength() / width + 1];
        int pow2 = 1 << width;
        int mask = pow2 - 1;
        int sign = pow2 >>> 1;
        boolean carry = false;
        int length = 0;
        int pos = 0;
        while (pos <= k.bitLength()) {
            if (k.testBit(pos) == carry) {
                ++pos;
                continue;
            }
            k = k.shiftRight(pos);
            int digit = k.intValue() & mask;
            if (carry) {
                ++digit;
            }
            boolean bl = carry = (digit & sign) != 0;
            if (carry) {
                digit -= pow2;
            }
            int zeroes = length > 0 ? pos - 1 : pos;
            wnaf[length++] = digit << 16 | zeroes;
            pos = width;
        }
        if (wnaf.length > length) {
            wnaf = ECCurve.trim(wnaf, length);
        }
        return wnaf;
    }

    private static byte[] generateNaf(BigInteger k) {
        if (k.signum() == 0) {
            return new byte[0];
        }
        BigInteger _3k = k.shiftLeft(1).add(k);
        int digits = _3k.bitLength() - 1;
        byte[] naf = new byte[digits];
        BigInteger diff = _3k.xor(k);
        int i = 1;
        while (i < digits) {
            if (diff.testBit(i)) {
                naf[i - 1] = (byte)(k.testBit(i) ? -1 : 1);
                ++i;
            }
            ++i;
        }
        naf[digits - 1] = 1;
        return naf;
    }

    private static byte[] generateWindowNaf(int width, BigInteger k) {
        if (width == 2) {
            return ECCurve.generateNaf(k);
        }
        Ex.MUST(width >= 2 && width <= 8);
        if (k.signum() == 0) {
            return new byte[0];
        }
        byte[] wnaf = new byte[k.bitLength() + 1];
        int pow2 = 1 << width;
        int mask = pow2 - 1;
        int sign = pow2 >>> 1;
        boolean carry = false;
        int length = 0;
        int pos = 0;
        while (pos <= k.bitLength()) {
            if (k.testBit(pos) == carry) {
                ++pos;
                continue;
            }
            k = k.shiftRight(pos);
            int digit = k.intValue() & mask;
            if (carry) {
                ++digit;
            }
            boolean bl = carry = (digit & sign) != 0;
            if (carry) {
                digit -= pow2;
            }
            length += length > 0 ? pos - 1 : pos;
            wnaf[length++] = (byte)digit;
            pos = width;
        }
        if (wnaf.length > length) {
            wnaf = ECCurve.trim(wnaf, length);
        }
        return wnaf;
    }

    private static int getWindowSize(int bits) {
        return ECCurve.getWindowSize(bits, DEFAULT_WINDOW_SIZE_CUTOFFS);
    }

    private static int getWindowSize(int bits, int[] windowSizeCutoffs) {
        int w = 0;
        while (w < windowSizeCutoffs.length) {
            if (bits < windowSizeCutoffs[w]) break;
            ++w;
        }
        return w + 2;
    }

    private static byte[] trim(byte[] a, int length) {
        byte[] result = new byte[length];
        System.arraycopy(a, 0, result, 0, result.length);
        return result;
    }

    private static int[] trim(int[] a, int length) {
        int[] result = new int[length];
        System.arraycopy(a, 0, result, 0, result.length);
        return result;
    }

    private static ECPoint[] resizeTable(ECPoint[] a, int length) {
        ECPoint[] result = new ECPoint[length];
        System.arraycopy(a, 0, result, 0, a.length);
        return result;
    }

    static ECPoint implShamirsTrickWNaf(ECPoint P, BigInteger k, ECPoint Q, BigInteger l) {
        boolean negK = k.signum() < 0;
        boolean negL = l.signum() < 0;
        k = k.abs();
        l = l.abs();
        int widthP = Math.max(2, Math.min(16, ECCurve.getWindowSize(k.bitLength())));
        int widthQ = Math.max(2, Math.min(16, ECCurve.getWindowSize(l.bitLength())));
        P.precomputeWNaf(widthP);
        Q.precomputeWNaf(widthQ);
        ECPoint[] preCompP = negK ? P.preCompWNafNeg : P.preCompWNaf;
        ECPoint[] preCompQ = negL ? Q.preCompWNafNeg : Q.preCompWNaf;
        ECPoint[] preCompNegP = negK ? P.preCompWNaf : P.preCompWNafNeg;
        ECPoint[] preCompNegQ = negL ? Q.preCompWNaf : Q.preCompWNafNeg;
        byte[] wnafP = ECCurve.generateWindowNaf(widthP, k);
        byte[] wnafQ = ECCurve.generateWindowNaf(widthQ, l);
        return ECCurve.implShamirsTrickWNaf(preCompP, preCompNegP, wnafP, preCompQ, preCompNegQ, wnafQ);
    }

    private static ECPoint implShamirsTrickWNaf(ECPoint[] preCompP, ECPoint[] preCompNegP, byte[] wnafP, ECPoint[] preCompQ, ECPoint[] preCompNegQ, byte[] wnafQ) {
        ECPoint infinity;
        int len = Math.max(wnafP.length, wnafQ.length);
        ECCurve curve = preCompP[0].getCurve();
        ECPoint R = infinity = curve.getInfinity();
        int zeroes = 0;
        int i = len - 1;
        while (i >= 0) {
            byte wiQ;
            byte wiP = i < wnafP.length ? wnafP[i] : (byte)0;
            byte by = wiQ = i < wnafQ.length ? wnafQ[i] : (byte)0;
            if ((wiP | wiQ) == 0) {
                ++zeroes;
            } else {
                ECPoint r = infinity;
                if (wiP != 0) {
                    int nP = Math.abs(wiP);
                    ECPoint[] tableP = wiP < 0 ? preCompNegP : preCompP;
                    r = r.add(tableP[nP >>> 1]);
                }
                if (wiQ != 0) {
                    int nQ = Math.abs(wiQ);
                    ECPoint[] tableQ = wiQ < 0 ? preCompNegQ : preCompQ;
                    r = r.add(tableQ[nQ >>> 1]);
                }
                if (zeroes > 0) {
                    R = R.timesPow2(zeroes);
                    zeroes = 0;
                }
                R = R.twicePlus(r);
            }
            --i;
        }
        if (zeroes > 0) {
            R = R.timesPow2(zeroes);
        }
        return R;
    }

    public abstract class ECElement {
        public Binary toBin() {
            int len = (this.getFieldSize() + 7) / 8;
            return ECCurve.BigInt2Bin(len, this.toBigInteger());
        }

        public abstract ECElement create(BigInteger var1);

        public abstract BigInteger toBigInteger();

        public abstract int getFieldSize();

        public abstract ECElement add(ECElement var1);

        public abstract ECElement addOne();

        public abstract ECElement subtract(ECElement var1);

        public abstract ECElement multiply(ECElement var1);

        public abstract ECElement divide(ECElement var1);

        public abstract ECElement negate();

        public abstract ECElement square();

        public abstract ECElement invert();

        public abstract ECElement sqrt();

        public int bitLength() {
            return this.toBigInteger().bitLength();
        }

        public boolean isOne() {
            return this.bitLength() == 1;
        }

        public boolean isZero() {
            return this.toBigInteger().signum() == 0;
        }

        public ECElement multiplyPlusProduct(ECElement b, ECElement x, ECElement y) {
            return this.multiply(b).add(x.multiply(y));
        }

        public ECElement squarePlusProduct(ECElement x, ECElement y) {
            return this.square().add(x.multiply(y));
        }

        public ECElement squarePow(int pow) {
            ECElement r = this;
            int i = 0;
            while (i < pow) {
                r = r.square();
                ++i;
            }
            return r;
        }

        public boolean testBitZero() {
            return this.toBigInteger().testBit(0);
        }
    }

    public abstract class ECPoint {
        public final ECElement x;
        public final ECElement y;
        public final ECElement[] zs;
        private ECPoint[] preComputedComb = null;
        private ECPoint preComputedCombOffset = null;
        private int preComputedCombWidth = 0;
        private ECPoint[] preCompWNaf = null;
        private ECPoint[] preCompWNafNeg = null;

        protected ECPoint(ECElement x, ECElement y, ECElement[] zs) {
            Ex.MUST(x == null == (y == null));
            this.x = x;
            this.y = y;
            this.zs = zs;
        }

        protected abstract ECPoint create(ECElement var1, ECElement var2);

        protected abstract ECPoint create(ECElement var1, ECElement var2, ECElement[] var3);

        protected abstract boolean satisfiesCurveEquation();

        protected boolean satisfiesOrder() {
            if (ECCurve.this.getCofactor().equals(BigInteger.ONE)) {
                return true;
            }
            return this.referenceMultiply(ECCurve.this.getOrder()).isInfinity();
        }

        public ECCurve getCurve() {
            return ECCurve.this;
        }

        public ECElement getAffineXCoord() {
            Ex.MUST(this.isNormalized());
            return this.getXCoord();
        }

        public ECElement getAffineYCoord() {
            Ex.MUST(this.isNormalized());
            return this.getYCoord();
        }

        public ECElement getXCoord() {
            return this.x;
        }

        public ECElement getYCoord() {
            return this.y;
        }

        public ECElement getZCoord(int index) {
            return index < 0 || index >= this.zs.length ? null : this.zs[index];
        }

        public final ECElement getRawXCoord() {
            return this.x;
        }

        public final ECElement getRawYCoord() {
            return this.y;
        }

        protected final ECElement[] getRawZCoords() {
            return this.zs;
        }

        public boolean isNormalized() {
            return this.isInfinity() || this.zs[0].isOne();
        }

        public abstract ECPoint normalize();

        public boolean isInfinity() {
            return this.x == null || this.y == null || this.zs.length > 0 && this.zs[0].isZero();
        }

        public boolean isValid() {
            if (this.isInfinity()) {
                return true;
            }
            return this.satisfiesCurveEquation() && this.satisfiesOrder();
        }

        public boolean equals(ECPoint other) {
            if (other == null) {
                return false;
            }
            ECCurve c1 = this.getCurve();
            ECCurve c2 = other.getCurve();
            boolean i1 = this.isInfinity();
            boolean i2 = other.isInfinity();
            if (i1 || i2) {
                return i1 && i2 && c1.equals(c2);
            }
            ECPoint p2 = other.normalize();
            ECPoint p1 = this.normalize();
            p2 = c1.importPoint(p2).normalize();
            return p1.getXCoord().equals(p2.getXCoord()) && p1.getYCoord().equals(p2.getYCoord());
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ECPoint)) {
                return false;
            }
            return this.equals((ECPoint)other);
        }

        public int hashCode() {
            int hc;
            ECCurve c = this.getCurve();
            int n = hc = c == null ? 0 : ~c.hashCode();
            if (!this.isInfinity()) {
                ECPoint p = this.normalize();
                hc ^= p.getXCoord().hashCode() * 17;
                hc ^= p.getYCoord().hashCode() * 257;
            }
            return hc;
        }

        public Binary getEncoded(boolean compressed) {
            if (this.isInfinity()) {
                return Binary.Bin(1);
            }
            ECPoint normed = this.normalize();
            Binary X = normed.getXCoord().toBin();
            if (compressed) {
                Binary res = Binary.Bin().reserve(X.size() + 1);
                res.add(normed.getCompressionYTilde() ? 3 : 2);
                res.add(X);
                return res;
            }
            Binary res = Binary.Bin().reserve(X.size() * 2 + 1);
            res.add(4);
            res.add(X);
            res.add(normed.getYCoord().toBin());
            return res;
        }

        protected abstract boolean getCompressionYTilde();

        public abstract ECPoint add(ECPoint var1);

        public abstract ECPoint negate();

        public final ECPoint subtract(ECPoint b) {
            if (b.isInfinity()) {
                return this;
            }
            return this.add(b.negate());
        }

        public ECPoint timesPow2(int e) {
            Ex.MUST(e >= 0, "'e' cannot be negative");
            ECPoint p = this;
            while (--e >= 0) {
                p = p.twice();
            }
            return p;
        }

        public abstract ECPoint twice();

        public ECPoint twicePlus(ECPoint b) {
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this.twice();
            }
            ECElement Y1 = this.y;
            if (Y1.isZero()) {
                return b;
            }
            return this.twice().add(b);
        }

        public ECPoint referenceMultiply(BigInteger k) {
            BigInteger x = k.abs();
            ECPoint q = ECCurve.this.getInfinity();
            ECPoint p = this;
            int t = x.bitLength();
            if (t > 0) {
                if (x.testBit(0)) {
                    q = p;
                }
                int i = 1;
                while (i < t) {
                    p = p.twice();
                    if (x.testBit(i)) {
                        q = q.add(p);
                    }
                    ++i;
                }
            }
            return k.signum() < 0 ? q.negate() : q;
        }

        private int getCombSize() {
            BigInteger order = ECCurve.this.getOrder();
            return order == null ? ECCurve.this.getFieldSize() + 1 : order.bitLength();
        }

        private void precomputeMultComb() {
            if (this.preComputedComb != null) {
                return;
            }
            int bits = this.getCombSize();
            int width = bits > 257 ? 6 : 5;
            int n = 1 << width;
            int d = (bits + width - 1) / width;
            ECPoint[] pow2Table = new ECPoint[width + 1];
            pow2Table[0] = this.normalize();
            int i = 1;
            while (i < width) {
                pow2Table[i] = pow2Table[i - 1].timesPow2(d).normalize();
                ++i;
            }
            pow2Table[width] = pow2Table[0].subtract(pow2Table[1]).normalize();
            ECPoint[] points = new ECPoint[n];
            points[0] = pow2Table[0];
            int bit = width - 1;
            while (bit >= 0) {
                int step;
                ECPoint pow2 = pow2Table[bit];
                int i2 = step = 1 << bit;
                while (i2 < n) {
                    points[i2] = points[i2 - step].add(pow2).normalize();
                    i2 += step << 1;
                }
                --bit;
            }
            this.preComputedComb = points;
            this.preComputedCombWidth = width;
            this.preComputedCombOffset = pow2Table[width];
        }

        ECPoint multiplyComb(BigInteger k) {
            int sign = k.signum();
            if (sign == 0 || this.isInfinity()) {
                return ECCurve.this.getInfinity();
            }
            k = k.abs();
            int size = this.getCombSize();
            Ex.MUST(k.bitLength() <= size, "fixed-point comb doesn't support scalars larger than the curve order");
            this.precomputeMultComb();
            int d = (size + this.preComputedCombWidth - 1) / this.preComputedCombWidth;
            ECPoint R = ECCurve.this.getInfinity();
            int fullComb = d * this.preComputedCombWidth;
            int[] K = Nat.fromBigInteger(fullComb, k);
            int top = fullComb - 1;
            int i = 0;
            while (i < d) {
                int index = 0;
                int j = top - i;
                while (j >= 0) {
                    index <<= 1;
                    index |= Nat.getBit(K, j);
                    j -= d;
                }
                ECPoint add = this.preComputedComb[index];
                R = R.twicePlus(add);
                ++i;
            }
            R = R.add(this.preComputedCombOffset);
            return sign > 0 ? R : R.negate();
        }

        public ECPoint multiply(BigInteger k) {
            ECPoint[] table;
            int n;
            int zeroes;
            int digit;
            int wi;
            int sign = k.signum();
            if (sign == 0 || this.isInfinity()) {
                return ECCurve.this.getInfinity();
            }
            k = k.abs();
            int width = Math.max(2, Math.min(16, ECCurve.getWindowSize(k.bitLength())));
            this.precomputeWNaf(width);
            int[] wnaf = ECCurve.generateCompactWindowNaf(width, k);
            ECPoint R = ECCurve.this.getInfinity();
            int i = wnaf.length;
            if (i > 1) {
                wi = wnaf[--i];
                digit = wi >> 16;
                zeroes = wi & 0xFFFF;
                n = Math.abs(digit);
                ECPoint[] eCPointArray = table = digit < 0 ? this.preCompWNafNeg : this.preCompWNaf;
                if (n << 2 < 1 << width) {
                    int highest = 32 - Integer.numberOfLeadingZeros(n);
                    int scale = width - highest;
                    int lowBits = n ^ 1 << highest - 1;
                    int i1 = (1 << width - 1) - 1;
                    int i2 = (lowBits << scale) + 1;
                    R = table[i1 >>> 1].add(table[i2 >>> 1]);
                    zeroes -= scale;
                } else {
                    R = table[n >>> 1];
                }
                R = R.timesPow2(zeroes);
            }
            while (i > 0) {
                wi = wnaf[--i];
                digit = wi >> 16;
                zeroes = wi & 0xFFFF;
                n = Math.abs(digit);
                table = digit < 0 ? this.preCompWNafNeg : this.preCompWNaf;
                ECPoint r = table[n >>> 1];
                R = R.twicePlus(r);
                R = R.timesPow2(zeroes);
            }
            return sign > 0 ? R : R.negate();
        }

        private void precomputeWNaf(int width) {
            int pos;
            int reqPreCompLen = 1 << Math.max(0, width - 2);
            if (this.preCompWNaf != null && this.preCompWNaf.length >= reqPreCompLen && this.preCompWNafNeg != null && this.preCompWNafNeg.length >= reqPreCompLen) {
                return;
            }
            int iniPreCompLen = 0;
            if (this.preCompWNaf == null) {
                this.preCompWNaf = new ECPoint[0];
            } else {
                iniPreCompLen = this.preCompWNaf.length;
            }
            if (iniPreCompLen < reqPreCompLen) {
                this.preCompWNaf = ECCurve.resizeTable(this.preCompWNaf, reqPreCompLen);
                if (reqPreCompLen == 1) {
                    this.preCompWNaf[0] = this.normalize();
                } else {
                    int curPreCompLen = iniPreCompLen;
                    if (curPreCompLen == 0) {
                        this.preCompWNaf[0] = this.normalize();
                        curPreCompLen = 1;
                    }
                    ECPoint twiceP = this.preCompWNaf[0].twice();
                    if (reqPreCompLen == 2) {
                        this.preCompWNaf[1] = twiceP.add(this).normalize();
                    } else {
                        ECPoint last = this.preCompWNaf[curPreCompLen - 1];
                        while (curPreCompLen < reqPreCompLen) {
                            last = last.add(twiceP).normalize();
                            this.preCompWNaf[curPreCompLen++] = last;
                        }
                    }
                }
            }
            if (this.preCompWNafNeg == null) {
                pos = 0;
                this.preCompWNafNeg = new ECPoint[reqPreCompLen];
            } else {
                pos = this.preCompWNafNeg.length;
                if (pos < reqPreCompLen) {
                    this.preCompWNafNeg = ECCurve.resizeTable(this.preCompWNafNeg, reqPreCompLen);
                }
            }
            while (pos < reqPreCompLen) {
                this.preCompWNafNeg[pos] = this.preCompWNaf[pos].negate();
                ++pos;
            }
        }
    }
}

