/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec;

import java.math.BigInteger;
import org.denom.Binary;
import org.denom.Ex;
import org.denom.crypt.ec.ECAlg;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.hash.IHash;

public class ECQV {
    private ECAlg issuerKey;
    private IHash hashAlg;

    public ECQV(ECAlg issuerKey, IHash hashAlg) {
        this.issuerKey = issuerKey;
        this.hashAlg = hashAlg;
    }

    public Binary generateCert(Binary idInfo, ECAlg userPublicKey, Binary privateKeyData) {
        Binary PuBin;
        BigInteger e;
        ECCurve.ECPoint Pu;
        Ex.MUST(userPublicKey.getCurve().equals(this.issuerKey.getCurve()), "User and issuer curve parameters not match");
        ECCurve ecCurve = this.issuerKey.getCurve();
        ECAlg kkG = new ECAlg(ecCurve);
        BigInteger n = ecCurve.getOrder();
        BigInteger dCa = new BigInteger(1, this.issuerKey.getPrivate().getBytes());
        do {
            kkG.generateKeyPair();
            ECCurve.ECPoint Ru = ecCurve.decodePoint(userPublicKey.getPublic());
            ECCurve.ECPoint kG = ecCurve.decodePoint(kkG.getPublic());
            Pu = Ru.add(kG);
            PuBin = Pu.getEncoded(true);
        } while (Pu.multiply(e = this.calculateE(n, Binary.Bin(idInfo, PuBin))).add(ecCurve.getG().multiply(dCa)).equals(ecCurve.getInfinity()));
        BigInteger k = new BigInteger(1, kkG.getPrivate().getBytes());
        BigInteger r = e.multiply(k).add(dCa).mod(n);
        int mLen = (ecCurve.getFieldSize() + 7) / 8;
        privateKeyData.assign(ECQV.integerToOctetString(r, mLen));
        return PuBin;
    }

    public ECAlg extractPublic(Binary idInfo, Binary reconstructionPoint) {
        ECCurve ecCurve = this.issuerKey.getCurve();
        BigInteger n = ecCurve.getOrder();
        ECCurve.ECPoint Pu = ecCurve.decodePoint(reconstructionPoint);
        ECCurve.ECPoint Qca = ecCurve.decodePoint(this.issuerKey.getPublic());
        BigInteger e = this.calculateE(n, Binary.Bin(idInfo, reconstructionPoint));
        Binary Qu = Pu.multiply(e).add(Qca).getEncoded(false);
        return new ECAlg(ecCurve).setPublic(Qu);
    }

    public ECAlg extractPrivate(Binary idInfo, Binary reconstructionPoint, Binary privateKeyData, ECAlg userPrivateKey) {
        ECAlg uPubKey = this.extractPublic(idInfo, reconstructionPoint);
        ECCurve ecCurve = userPrivateKey.getCurve();
        BigInteger n = ecCurve.getOrder();
        BigInteger e = this.calculateE(n, Binary.Bin(idInfo, reconstructionPoint));
        BigInteger r = new BigInteger(1, privateKeyData.getBytes());
        Ex.MUST(n.compareTo(r) == 1, "Octet String value is larger than modulus");
        BigInteger kU = new BigInteger(1, userPrivateKey.getPrivate().getBytes());
        BigInteger dU = r.add(e.multiply(kU)).mod(n);
        ECAlg uPrivKey = new ECAlg(ecCurve);
        int mLen = (ecCurve.getFieldSize() + 7) / 8;
        uPrivKey.setPrivate(ECQV.integerToOctetString(dU, mLen));
        Ex.MUST(uPrivKey.getPublic().equals(uPubKey.getPublic()));
        return uPrivKey;
    }

    public Binary generateCertSelf(Binary idInfo, ECAlg userPrivateKey) {
        ECCurve ecCurve = this.issuerKey.getCurve();
        BigInteger n = ecCurve.getOrder();
        Ex.MUST(userPrivateKey.getCurve().equals(this.issuerKey.getCurve()), "User and issuer curve parameters not match");
        ECCurve.ECPoint Pu = ecCurve.decodePoint(this.issuerKey.getPublic());
        Binary PuBin = Pu.getEncoded(true);
        BigInteger e = this.calculateE(n, Binary.Bin(idInfo, PuBin));
        BigInteger k = new BigInteger(1, this.issuerKey.getPrivate().getBytes());
        BigInteger r = e.multiply(k).mod(n);
        int mLen = (ecCurve.getFieldSize() + 7) / 8;
        userPrivateKey.setPrivate(ECQV.integerToOctetString(r, mLen));
        return PuBin;
    }

    public ECAlg extractPublicSelf(Binary idInfo, Binary reconstructionPoint) {
        ECCurve ecCurve = this.issuerKey.getCurve();
        BigInteger n = ecCurve.getOrder();
        ECCurve.ECPoint Pu = ecCurve.decodePoint(reconstructionPoint);
        BigInteger e = this.calculateE(n, Binary.Bin(idInfo, reconstructionPoint));
        Binary Qu = Pu.multiply(e).getEncoded(false);
        return new ECAlg(ecCurve).setPublic(Qu);
    }

    private BigInteger calculateE(BigInteger n, Binary s) {
        Binary hash = this.hashAlg.calc(s);
        int log2n = n.bitLength() - 1;
        int messageBitLength = hash.size() * 8;
        BigInteger e = new BigInteger(1, hash.getBytes());
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }

    private static Binary integerToOctetString(BigInteger x, int desiredLen) {
        int srcLen;
        Ex.MUST(x.signum() == 1, "Integer is not positive");
        Ex.MUST(x.compareTo(new BigInteger("2").pow(8 * desiredLen)) == -1, "Integer is larger than expected");
        byte[] xBin = x.toByteArray();
        int srcOffset = xBin[0] == 0 ? 1 : 0;
        int n = srcLen = xBin[0] == 0 ? xBin.length - 1 : xBin.length;
        if (srcLen < desiredLen) {
            return Binary.Bin(Binary.Bin(desiredLen - srcLen), new Binary(xBin, srcOffset, srcLen));
        }
        return new Binary(xBin, srcOffset, srcLen);
    }
}

