/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m;

import java.math.BigInteger;
import java.util.Random;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.F2m.SimpleBigDecimal;

public abstract class F2mCurveAbstract
extends ECCurve {
    protected final int m;
    protected final int k1;
    protected final int k2;
    protected final int k3;
    protected int[] ks;
    protected final boolean isKoblitz;
    private BigInteger[] si = null;
    private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private static final BigInteger MINUS_THREE = BigInteger.valueOf(-3L);
    private static final byte WIDTH = 4;
    private static final byte POW_2_WIDTH = 16;
    private static final ZTauElement[] alpha0;
    private static final byte[][] alpha0Tnaf;
    private static final ZTauElement[] alpha1;
    private static final byte[][] alpha1Tnaf;

    static {
        ZTauElement[] zTauElementArray = new ZTauElement[9];
        zTauElementArray[1] = new ZTauElement(BigInteger.ONE, BigInteger.ZERO);
        zTauElementArray[3] = new ZTauElement(MINUS_THREE, MINUS_ONE);
        zTauElementArray[5] = new ZTauElement(MINUS_ONE, MINUS_ONE);
        zTauElementArray[7] = new ZTauElement(BigInteger.ONE, MINUS_ONE);
        alpha0 = zTauElementArray;
        byte[][] byArrayArray = new byte[8][];
        byArrayArray[1] = new byte[]{1};
        byte[] byArray = new byte[3];
        byArray[0] = -1;
        byArray[2] = 1;
        byArrayArray[3] = byArray;
        byte[] byArray2 = new byte[3];
        byArray2[0] = 1;
        byArray2[2] = 1;
        byArrayArray[5] = byArray2;
        byte[] byArray3 = new byte[4];
        byArray3[0] = -1;
        byArray3[3] = 1;
        byArrayArray[7] = byArray3;
        alpha0Tnaf = byArrayArray;
        ZTauElement[] zTauElementArray2 = new ZTauElement[9];
        zTauElementArray2[1] = new ZTauElement(BigInteger.ONE, BigInteger.ZERO);
        zTauElementArray2[3] = new ZTauElement(MINUS_THREE, BigInteger.ONE);
        zTauElementArray2[5] = new ZTauElement(MINUS_ONE, BigInteger.ONE);
        zTauElementArray2[7] = new ZTauElement(BigInteger.ONE, BigInteger.ONE);
        alpha1 = zTauElementArray2;
        byte[][] byArrayArray2 = new byte[8][];
        byArrayArray2[1] = new byte[]{1};
        byte[] byArray4 = new byte[3];
        byArray4[0] = -1;
        byArray4[2] = 1;
        byArrayArray2[3] = byArray4;
        byte[] byArray5 = new byte[3];
        byArray5[0] = 1;
        byArray5[2] = 1;
        byArrayArray2[5] = byArray5;
        byte[] byArray6 = new byte[4];
        byArray6[0] = -1;
        byArray6[3] = -1;
        byArrayArray2[7] = byArray6;
        alpha1Tnaf = byArrayArray2;
    }

    protected F2mCurveAbstract(int m, int k1, int k2, int k3, boolean isKoblitz) {
        this.m = m;
        this.k1 = k1;
        this.k2 = k2;
        this.k3 = k3;
        this.isKoblitz = isKoblitz;
        if (k2 == 0 && k3 == 0) {
            this.ks = new int[]{k1};
        } else {
            Ex.MUST(k2 < k3, "k2 must be smaller than k3");
            Ex.MUST(k2 > 0, "k2 must be larger than 0");
            this.ks = new int[]{k1, k2, k3};
        }
    }

    @Override
    public int getFieldSize() {
        return this.m;
    }

    protected static boolean isKoblitzCurve(BigInteger a, BigInteger b) {
        return b.equals(BigInteger.ONE) && (a.equals(BigInteger.ONE) || a.equals(BigInteger.ZERO));
    }

    @Override
    public ECCurve.ECPoint createPoint(BigInteger x, BigInteger y) {
        ECCurve.ECElement X = this.fromBigInteger(x);
        ECCurve.ECElement Y = this.fromBigInteger(y);
        if (X.isZero()) {
            Ex.MUST(Y.square().equals(this.getB()));
        } else {
            Y = Y.divide(X).add(X);
        }
        return this.createRawPoint(X, Y);
    }

    @Override
    protected ECCurve.ECPoint decompressPoint(int yTilde, BigInteger X1) {
        ECCurve.ECElement x = this.fromBigInteger(X1);
        ECCurve.ECElement y = null;
        if (x.isZero()) {
            y = this.getB().sqrt();
        } else {
            ECCurve.ECElement beta = x.square().invert().multiply(this.getB()).add(this.getA()).add(x);
            ECCurve.ECElement z = this.solveQuadraticEquation(beta);
            if (z != null) {
                if (z.testBitZero() != (yTilde == 1)) {
                    z = z.addOne();
                }
                y = z.add(x);
            }
        }
        Ex.MUST(y != null, "Invalid point compression");
        return this.createRawPoint(x, y);
    }

    protected ECCurve.ECElement solveQuadraticEquation(ECCurve.ECElement beta) {
        ECCurve.ECElement z;
        ECCurve.ECElement gamma;
        if (beta.isZero()) {
            return beta;
        }
        ECCurve.ECElement zeroElement = this.fromBigInteger(BigInteger.ZERO);
        int m = this.getFieldSize();
        Random rand = new Random();
        do {
            ECCurve.ECElement t = this.fromBigInteger(new BigInteger(m, rand));
            z = zeroElement;
            ECCurve.ECElement w = beta;
            int i = 1;
            while (i < m) {
                ECCurve.ECElement w2 = w.square();
                z = z.square().add(w2.multiply(t));
                w = w2.add(beta);
                ++i;
            }
            if (w.isZero()) continue;
            return null;
        } while ((gamma = z.square().add(z)).isZero());
        return z;
    }

    protected BigInteger[] getSi() {
        if (this.si != null) {
            return this.si;
        }
        Ex.MUST(this.isKoblitz, "si is defined for Koblitz curves only");
        int m = this.getFieldSize();
        int a = this.getA().toBigInteger().intValue();
        byte mu = F2mCurveAbstract.getMu(a);
        int shifts = 0;
        if (this.getCofactor().equals(BigInteger.valueOf(2L))) {
            shifts = 1;
        }
        if (this.getCofactor().equals(BigInteger.valueOf(4L))) {
            shifts = 2;
        }
        int index = m + 3 - a;
        BigInteger[] ui = this.getLucas(mu, index, false);
        if (mu == 1) {
            ui[0] = ui[0].negate();
            ui[1] = ui[1].negate();
        }
        BigInteger dividend0 = BigInteger.ONE.add(ui[1]).shiftRight(shifts);
        BigInteger dividend1 = BigInteger.ONE.add(ui[0]).shiftRight(shifts).negate();
        this.si = new BigInteger[]{dividend0, dividend1};
        return this.si;
    }

    @Override
    public ECCurve.ECPoint sumOfTwoMultiplies(ECCurve.ECPoint P, BigInteger a, ECCurve.ECPoint Q, BigInteger b) {
        if (this.isKoblitz) {
            Q = this.importPoint(Q);
            return P.multiply(a).add(Q.multiply(b));
        }
        return super.sumOfTwoMultiplies(P, a, Q, b);
    }

    private static byte getMu(int curveA) {
        return (byte)(curveA == 0 ? -1 : 1);
    }

    private BigInteger getTw(byte mu, int w) {
        if (w == 4) {
            if (mu == 1) {
                return BigInteger.valueOf(6L);
            }
            return BigInteger.valueOf(10L);
        }
        BigInteger[] us = this.getLucas(mu, w, false);
        BigInteger twoToW = BigInteger.ZERO.setBit(w);
        BigInteger u1invert = us[1].modInverse(twoToW);
        BigInteger tw = BigInteger.valueOf(2L).multiply(us[0]).multiply(u1invert).mod(twoToW);
        return tw;
    }

    private BigInteger[] getLucas(byte mu, int k, boolean doV) {
        BigInteger u1;
        BigInteger u0;
        Ex.MUST(mu == 1 || mu == -1, "mu must be 1 or -1");
        if (doV) {
            u0 = BigInteger.valueOf(2L);
            u1 = BigInteger.valueOf(mu);
        } else {
            u0 = BigInteger.ZERO;
            u1 = BigInteger.ONE;
        }
        int i = 1;
        while (i < k) {
            BigInteger s = null;
            s = mu == 1 ? u1 : u1.negate();
            BigInteger u2 = s.subtract(u0.shiftLeft(1));
            u0 = u1;
            u1 = u2;
            ++i;
        }
        BigInteger[] retVal = new BigInteger[]{u0, u1};
        return retVal;
    }

    private SimpleBigDecimal approximateDivisionByN(BigInteger k, BigInteger s, BigInteger vm, byte a, int m, int c) {
        int _k = (m + 5) / 2 + c;
        BigInteger ns = k.shiftRight(m - _k - 2 + a);
        BigInteger gs = s.multiply(ns);
        BigInteger hs = gs.shiftRight(m);
        BigInteger js = vm.multiply(hs);
        BigInteger gsPlusJs = gs.add(js);
        BigInteger ls = gsPlusJs.shiftRight(_k - c);
        if (gsPlusJs.testBit(_k - c - 1)) {
            ls = ls.add(BigInteger.ONE);
        }
        return new SimpleBigDecimal(ls, c);
    }

    private ZTauElement round(SimpleBigDecimal lambda0, SimpleBigDecimal lambda1, byte mu) {
        SimpleBigDecimal check2;
        SimpleBigDecimal check1;
        int scale = lambda0.scale;
        Ex.MUST(lambda1.scale == scale);
        Ex.MUST(mu == 1 || mu == -1);
        BigInteger f0 = lambda0.round();
        BigInteger f1 = lambda1.round();
        SimpleBigDecimal eta0 = lambda0.subtract(f0);
        SimpleBigDecimal eta1 = lambda1.subtract(f1);
        SimpleBigDecimal eta = eta0.add(eta0);
        eta = mu == 1 ? eta.add(eta1) : eta.subtract(eta1);
        SimpleBigDecimal threeEta1 = eta1.add(eta1).add(eta1);
        SimpleBigDecimal fourEta1 = threeEta1.add(eta1);
        if (mu == 1) {
            check1 = eta0.subtract(threeEta1);
            check2 = eta0.add(fourEta1);
        } else {
            check1 = eta0.add(threeEta1);
            check2 = eta0.subtract(fourEta1);
        }
        int h0 = 0;
        byte h1 = 0;
        if (eta.compareTo(BigInteger.ONE) >= 0) {
            if (check1.compareTo(MINUS_ONE) < 0) {
                h1 = mu;
            } else {
                h0 = 1;
            }
        } else if (check2.compareTo(BigInteger.valueOf(2L)) >= 0) {
            h1 = mu;
        }
        if (eta.compareTo(MINUS_ONE) < 0) {
            if (check1.compareTo(BigInteger.ONE) >= 0) {
                h1 = -mu;
            } else {
                h0 = -1;
            }
        } else if (check2.compareTo(BigInteger.valueOf(-2L)) < 0) {
            h1 = -mu;
        }
        BigInteger q0 = f0.add(BigInteger.valueOf(h0));
        BigInteger q1 = f1.add(BigInteger.valueOf(h1));
        return new ZTauElement(q0, q1);
    }

    private ZTauElement partModReduction(BigInteger k, int m, byte a, BigInteger[] s, byte mu) {
        BigInteger d0 = mu == 1 ? s[0].add(s[1]) : s[0].subtract(s[1]);
        BigInteger[] v = this.getLucas(mu, m, true);
        BigInteger vm = v[1];
        SimpleBigDecimal lambda0 = this.approximateDivisionByN(k, s[0], vm, a, m, 10);
        SimpleBigDecimal lambda1 = this.approximateDivisionByN(k, s[1], vm, a, m, 10);
        ZTauElement q = this.round(lambda0, lambda1, mu);
        BigInteger r0 = k.subtract(d0.multiply(q.u)).subtract(BigInteger.valueOf(2L).multiply(s[1]).multiply(q.v));
        BigInteger r1 = s[1].multiply(q.u).subtract(s[0].multiply(q.v));
        return new ZTauElement(r0, r1);
    }

    private BigInteger norm(byte mu, ZTauElement lambda) {
        BigInteger norm;
        BigInteger s1 = lambda.u.multiply(lambda.u);
        BigInteger s2 = lambda.u.multiply(lambda.v);
        BigInteger s3 = lambda.v.multiply(lambda.v).shiftLeft(1);
        if (mu == 1) {
            norm = s1.add(s2).add(s3);
        } else if (mu == -1) {
            norm = s1.subtract(s2).add(s3);
        } else {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        return norm;
    }

    private byte[] tauAdicWNaf(byte mu, ZTauElement lambda, byte width, BigInteger pow2w, BigInteger tw, ZTauElement[] alpha) {
        if (mu != 1 && mu != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        BigInteger norm = this.norm(mu, lambda);
        int log2Norm = norm.bitLength();
        int maxLength = log2Norm > 30 ? log2Norm + 4 + width : 34 + width;
        byte[] u = new byte[maxLength];
        BigInteger pow2wMin1 = pow2w.shiftRight(1);
        BigInteger r0 = lambda.u;
        BigInteger r1 = lambda.v;
        int i = 0;
        while (!r0.equals(BigInteger.ZERO) || !r1.equals(BigInteger.ZERO)) {
            if (r0.testBit(0)) {
                BigInteger uUnMod = r0.add(r1.multiply(tw)).mod(pow2w);
                byte uLocal = uUnMod.compareTo(pow2wMin1) >= 0 ? (byte)uUnMod.subtract(pow2w).intValue() : (byte)uUnMod.intValue();
                u[i] = uLocal;
                boolean s = true;
                if (uLocal < 0) {
                    s = false;
                    uLocal = -uLocal;
                }
                if (s) {
                    r0 = r0.subtract(alpha[uLocal].u);
                    r1 = r1.subtract(alpha[uLocal].v);
                } else {
                    r0 = r0.add(alpha[uLocal].u);
                    r1 = r1.add(alpha[uLocal].v);
                }
            } else {
                u[i] = 0;
            }
            BigInteger t = r0;
            r0 = mu == 1 ? r1.add(r0.shiftRight(1)) : r1.subtract(r0.shiftRight(1));
            r1 = t.shiftRight(1).negate();
            ++i;
        }
        return u;
    }

    protected abstract class F2mElementAbstract
    extends ECCurve.ECElement {
        protected F2mElementAbstract() {
        }

        @Override
        public final int getFieldSize() {
            return F2mCurveAbstract.this.getFieldSize();
        }

        protected int trace() {
            ECCurve.ECElement fe;
            int m = this.getFieldSize();
            ECCurve.ECElement tr = fe = this;
            int i = 1;
            while (i < m) {
                fe = fe.square();
                tr = tr.add(fe);
                ++i;
            }
            if (tr.isZero()) {
                return 0;
            }
            if (tr.isOne()) {
                return 1;
            }
            Ex.THROW("Internal error in trace calculation");
            return 0;
        }
    }

    protected abstract class F2mPointAbstract
    extends ECCurve.ECPoint {
        private F2mPointAbstract[] preCompTauWNaf;

        protected F2mPointAbstract(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(x, y, new ECCurve.ECElement[]{F2mCurveAbstract.this.fromBigInteger(BigInteger.ONE)});
            this.preCompTauWNaf = null;
        }

        protected F2mPointAbstract(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(x, y, zs);
            this.preCompTauWNaf = null;
        }

        @Override
        public ECCurve.ECPoint normalize() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement Z1 = this.getZCoord(0);
            if (Z1.isOne()) {
                return this;
            }
            ECCurve.ECElement zInv = Z1.invert();
            return F2mCurveAbstract.this.createRawPoint(this.x.multiply(zInv), this.y.multiply(zInv));
        }

        @Override
        protected boolean satisfiesCurveEquation() {
            ECCurve.ECElement rhs;
            ECCurve.ECElement lhs;
            ECCurve.ECElement X = this.x;
            ECCurve.ECElement A = F2mCurveAbstract.this.getA();
            ECCurve.ECElement B = F2mCurveAbstract.this.getB();
            ECCurve.ECElement Z = this.zs[0];
            boolean ZIsOne = Z.isOne();
            if (X.isZero()) {
                ECCurve.ECElement Y = this.y;
                ECCurve.ECElement lhs2 = Y.square();
                ECCurve.ECElement rhs2 = B;
                if (!ZIsOne) {
                    rhs2 = rhs2.multiply(Z.square());
                }
                return lhs2.equals(rhs2);
            }
            ECCurve.ECElement L = this.y;
            ECCurve.ECElement X2 = X.square();
            if (ZIsOne) {
                lhs = L.square().add(L).add(A);
                rhs = X2.square().add(B);
            } else {
                ECCurve.ECElement Z2 = Z.square();
                ECCurve.ECElement Z4 = Z2.square();
                lhs = L.add(Z).multiplyPlusProduct(L, A, Z2);
                rhs = X2.squarePlusProduct(B, Z4);
            }
            lhs = lhs.multiply(X2);
            return lhs.equals(rhs);
        }

        @Override
        protected boolean satisfiesOrder() {
            BigInteger cofactor = F2mCurveAbstract.this.getCofactor();
            if (cofactor.equals(BigInteger.valueOf(2L))) {
                ECCurve.ECPoint N = this.normalize();
                ECCurve.ECElement X = N.getAffineXCoord();
                ECCurve.ECElement rhs = X.add(F2mCurveAbstract.this.getA());
                return ((F2mElementAbstract)rhs).trace() == 0;
            }
            if (cofactor.equals(BigInteger.valueOf(4L))) {
                ECCurve.ECPoint N = this.normalize();
                ECCurve.ECElement X = N.getAffineXCoord();
                ECCurve.ECElement lambda = F2mCurveAbstract.this.solveQuadraticEquation(X.add(F2mCurveAbstract.this.getA()));
                if (lambda == null) {
                    return false;
                }
                ECCurve.ECElement w = X.multiply(lambda).add(N.getAffineYCoord());
                ECCurve.ECElement t = w.add(F2mCurveAbstract.this.getA());
                return ((F2mElementAbstract)t).trace() == 0 || ((F2mElementAbstract)t.add(X)).trace() == 0;
            }
            return super.satisfiesOrder();
        }

        @Override
        public final ECCurve.ECPoint multiply(BigInteger k) {
            if (F2mCurveAbstract.this.isKoblitz) {
                return this.multiplyWTau(k);
            }
            return super.multiply(k);
        }

        private void precomputeTNaf(byte a) {
            if (this.preCompTauWNaf != null) {
                return;
            }
            byte[][] alphaTnaf = a == 0 ? alpha0Tnaf : alpha1Tnaf;
            this.preCompTauWNaf = new F2mPointAbstract[alphaTnaf.length + 1 >>> 1];
            this.preCompTauWNaf[0] = (F2mPointAbstract)this.normalize();
            int precompLen = alphaTnaf.length;
            int i = 3;
            while (i < precompLen) {
                this.preCompTauWNaf[i >>> 1] = (F2mPointAbstract)this.multiplyFromTnaf(alphaTnaf[i]).normalize();
                i += 2;
            }
        }

        private F2mPointAbstract tauPow(int pow) {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement X1 = this.x;
            ECCurve.ECElement Y1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            return (F2mPointAbstract)F2mCurveAbstract.this.createRawPoint(X1.squarePow(pow), Y1.squarePow(pow), new ECCurve.ECElement[]{Z1.squarePow(pow)});
        }

        private ECCurve.ECPoint multiplyWTau(BigInteger k) {
            int sign = k.signum();
            if (sign == 0 || this.isInfinity()) {
                return F2mCurveAbstract.this.getInfinity();
            }
            k = k.abs();
            int m = F2mCurveAbstract.this.getFieldSize();
            byte a = F2mCurveAbstract.this.getA().toBigInteger().byteValue();
            byte mu = F2mCurveAbstract.getMu(a);
            ZTauElement rho = F2mCurveAbstract.this.partModReduction(k, m, a, F2mCurveAbstract.this.getSi(), mu);
            ZTauElement[] alpha = a == 0 ? alpha0 : alpha1;
            BigInteger tw = F2mCurveAbstract.this.getTw(mu, 4);
            byte[] u = F2mCurveAbstract.this.tauAdicWNaf(mu, rho, (byte)4, BigInteger.valueOf(16L), tw, alpha);
            this.precomputeTNaf(a);
            F2mPointAbstract[] puNeg = new F2mPointAbstract[this.preCompTauWNaf.length];
            int i = 0;
            while (i < this.preCompTauWNaf.length) {
                puNeg[i] = (F2mPointAbstract)this.preCompTauWNaf[i].negate();
                ++i;
            }
            F2mPointAbstract q = (F2mPointAbstract)F2mCurveAbstract.this.getInfinity();
            int tauCount = 0;
            int i2 = u.length - 1;
            while (i2 >= 0) {
                ++tauCount;
                byte ui = u[i2];
                if (ui != 0) {
                    q = q.tauPow(tauCount);
                    tauCount = 0;
                    F2mPointAbstract x = ui > 0 ? this.preCompTauWNaf[ui >>> 1] : puNeg[-ui >>> 1];
                    q = (F2mPointAbstract)q.add(x);
                }
                --i2;
            }
            if (tauCount > 0) {
                q = q.tauPow(tauCount);
            }
            return sign > 0 ? q : q.negate();
        }

        private F2mPointAbstract multiplyFromTnaf(byte[] u) {
            F2mPointAbstract q = (F2mPointAbstract)F2mCurveAbstract.this.getInfinity();
            F2mPointAbstract pNeg = (F2mPointAbstract)this.negate();
            int tauCount = 0;
            int i = u.length - 1;
            while (i >= 0) {
                ++tauCount;
                byte ui = u[i];
                if (ui != 0) {
                    q = q.tauPow(tauCount);
                    tauCount = 0;
                    F2mPointAbstract x = ui > 0 ? this : pNeg;
                    q = (F2mPointAbstract)q.add(x);
                }
                --i;
            }
            if (tauCount > 0) {
                q = q.tauPow(tauCount);
            }
            return q;
        }
    }

    private static class ZTauElement {
        private final BigInteger u;
        private final BigInteger v;

        private ZTauElement(BigInteger u, BigInteger v) {
            this.u = u;
            this.v = v;
        }
    }
}

