/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.F2m.custom.CustomF2mCurve;
import org.denom.crypt.ec.Nat;

public class Sect113
extends CustomF2mCurve {
    private static final int ARR_LEN = 2;
    private static final int ARR_LEN2 = 4;
    private static final long M49 = 0x1FFFFFFFFFFFFL;
    private static final long M57 = 0x1FFFFFFFFFFFFFFL;

    public static Sect113 r1() {
        return new Sect113("1.3.132.0.4", "003088250CA6E7C7FE649CE85820F7", "00E8BEE4D3E2260744188BE0E9C723", "0100000000000000D9CCEC8A39E56F", "02", "04 009D73616F35F4AB1407D73562C10F 00A52830277958EE84D1315ED31886", false);
    }

    public static Sect113 r2() {
        return new Sect113("1.3.132.0.5", "00689918DBEC7E5A0DD6DFC0AA55C7", "0095E9A9EC9B297BD4BF36E059184F", "010000000000000108789B2496AF93", "02", "04 01A57A6A7B26CA5EF52FCDB8164797 00B3ADC94ED1FE674C06E695BABA1D", false);
    }

    private Sect113(String oid, String aHex, String bHex, String orderHex, String cofactorHex, String gPointHex, boolean isKoblitz) {
        super(113, 9, 0, 0, 2, isKoblitz);
        super.init(new Element(), new CustomF2mCurve.Point(null, null, null), oid, aHex, bHex, orderHex, cofactorHex, gPointHex);
    }

    private static void invert(long[] x, long[] z) {
        Ex.MUST(!Nat.isZero64(x));
        long[] t0 = new long[2];
        long[] t1 = new long[2];
        Sect113.square(x, t0);
        Sect113.multiply(t0, x, t0);
        Sect113.square(t0, t0);
        Sect113.multiply(t0, x, t0);
        Sect113.squareN(t0, 3, t1);
        Sect113.multiply(t1, t0, t1);
        Sect113.square(t1, t1);
        Sect113.multiply(t1, x, t1);
        Sect113.squareN(t1, 7, t0);
        Sect113.multiply(t0, t1, t0);
        Sect113.squareN(t0, 14, t1);
        Sect113.multiply(t1, t0, t1);
        Sect113.squareN(t1, 28, t0);
        Sect113.multiply(t0, t1, t0);
        Sect113.squareN(t0, 56, t1);
        Sect113.multiply(t1, t0, t1);
        Sect113.square(t1, z);
    }

    private static void multiply(long[] x, long[] y, long[] z) {
        long[] tt = new long[4];
        Sect113.implMultiply(x, y, tt);
        Sect113.reduce(tt, z);
    }

    private static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] tt = new long[4];
        Sect113.implMultiply(x, y, tt);
        Sect113.add(zz, tt, zz);
    }

    private static void reduce(long[] xx, long[] z) {
        long x0 = xx[0];
        long x1 = xx[1];
        long x2 = xx[2];
        long x3 = xx[3];
        x1 ^= x3 << 15 ^ x3 << 24;
        long t = (x1 ^= x2 >>> 49 ^ x2 >>> 40) >>> 49;
        z[0] = (x0 ^= (x2 ^= x3 >>> 49 ^ x3 >>> 40) << 15 ^ x2 << 24) ^ t ^ t << 9;
        z[1] = x1 & 0x1FFFFFFFFFFFFL;
    }

    private static void sqrt(long[] x, long[] z) {
        long u0 = Nat.unshuffle(x[0]);
        long u1 = Nat.unshuffle(x[1]);
        long e0 = u0 & 0xFFFFFFFFL | u1 << 32;
        long c0 = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        z[0] = e0 ^ c0 << 57 ^ c0 << 5;
        z[1] = c0 >>> 7 ^ c0 >>> 59;
    }

    private static void square(long[] x, long[] z) {
        long[] tt = new long[4];
        Sect113.implSquare(x, tt);
        Sect113.reduce(tt, z);
    }

    private static void squareAddToExt(long[] x, long[] zz) {
        long[] tt = new long[4];
        Sect113.implSquare(x, tt);
        Sect113.add(zz, tt, zz);
    }

    private static void squareN(long[] x, int n, long[] z) {
        long[] tt = new long[4];
        Sect113.implSquare(x, tt);
        Sect113.reduce(tt, z);
        while (--n > 0) {
            Sect113.implSquare(z, tt);
            Sect113.reduce(tt, z);
        }
    }

    private static void implMultiply(long[] x, long[] y, long[] zz) {
        long f0 = x[0];
        long f1 = x[1];
        f1 = (f0 >>> 57 ^ f1 << 7) & 0x1FFFFFFFFFFFFFFL;
        long g0 = y[0];
        long g1 = y[1];
        g1 = (g0 >>> 57 ^ g1 << 7) & 0x1FFFFFFFFFFFFFFL;
        long[] H = new long[6];
        Sect113.implMulw(f0 &= 0x1FFFFFFFFFFFFFFL, g0 &= 0x1FFFFFFFFFFFFFFL, H, 0);
        Sect113.implMulw(f1, g1, H, 2);
        Sect113.implMulw(f0 ^ f1, g0 ^ g1, H, 4);
        long r = H[1] ^ H[2];
        long z0 = H[0];
        long z3 = H[3];
        long z1 = H[4] ^ z0 ^ r;
        long z2 = H[5] ^ z3 ^ r;
        zz[0] = z0 ^ z1 << 57;
        zz[1] = z1 >>> 7 ^ z2 << 50;
        zz[2] = z2 >>> 14 ^ z3 << 43;
        zz[3] = z3 >>> 21;
    }

    private static void implMulw(long x, long y, long[] z, int zOff) {
        long[] u = new long[8];
        u[1] = y;
        u[2] = u[1] << 1;
        u[3] = u[2] ^ y;
        u[4] = u[2] << 1;
        u[5] = u[4] ^ y;
        u[6] = u[3] << 1;
        u[7] = u[6] ^ y;
        int j = (int)x;
        long h = 0L;
        long l = u[j & 7];
        int k = 48;
        do {
            j = (int)(x >>> k);
            long g = u[j & 7] ^ u[j >>> 3 & 7] << 3 ^ u[j >>> 6 & 7] << 6;
            l ^= g << k;
            h ^= g >>> -k;
        } while ((k -= 9) > 0);
        z[zOff] = l & 0x1FFFFFFFFFFFFFFL;
        z[zOff + 1] = l >>> 57 ^ (h ^= (x & 0x100804020100800L & y << 7 >> 63) >>> 8) << 7;
    }

    private static void implSquare(long[] x, long[] zz) {
        Nat.expand64To128(x[0], zz, 0);
        Nat.expand64To128(x[1], zz, 2);
    }

    private class Element
    extends CustomF2mCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            super(X);
            long t = this.arr[1] >>> 49;
            this.arr[0] = this.arr[0] ^ (t ^ t << 9);
            this.arr[1] = this.arr[1] & 0x1FFFFFFFFFFFFL;
        }

        private Element(long[] x) {
            super(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        protected Element create(long[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement multiply(ECCurve.ECElement b) {
            long[] z = new long[2];
            Sect113.multiply(this.arr, ((Element)b).arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement multiplyPlusProduct(ECCurve.ECElement b, ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] bx = ((Element)b).arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[4];
            Sect113.multiplyAddToExt(ax, bx, tt);
            Sect113.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[2];
            Sect113.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement square() {
            long[] z = new long[2];
            Sect113.square(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePlusProduct(ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[4];
            Sect113.squareAddToExt(ax, tt);
            Sect113.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[2];
            Sect113.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePow(int pow) {
            if (pow < 1) {
                return this;
            }
            long[] z = new long[2];
            Sect113.squareN(this.arr, pow, z);
            return new Element(z);
        }

        @Override
        public int trace() {
            return (int)this.arr[0] & 1;
        }

        @Override
        public ECCurve.ECElement invert() {
            long[] z = new long[2];
            Sect113.invert(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            long[] z = new long[2];
            Sect113.sqrt(this.arr, z);
            return new Element(z);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Element)) {
                return false;
            }
            Element o = (Element)other;
            return Arrays.equals(this.arr, o.arr);
        }

        public int hashCode() {
            return 0x1B971 ^ Arrays.hashCode(this.arr);
        }
    }
}

