/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.F2m.custom.CustomF2mCurve;
import org.denom.crypt.ec.Nat;

public class Sect131
extends CustomF2mCurve {
    private static final int ARR_LEN = 3;
    private static final int ARR_LEN2 = 6;
    private static final long M03 = 7L;
    private static final long M44 = 0xFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{2791191049453778211L, 2791191049453778402L, 6L};
    protected CustomF2mCurve.Point infinity;

    public static Sect131 r1() {
        return new Sect131("1.3.132.0.22", "07A11B09A76B562144418FF3FF8C2570B8", "0217C05610884B63B9C6C7291678F9D341", "0400000000000000023123953A9464B54D", "02", "04 0081BAF91FDF9833C40F9C181343638399 078C6E7EA38C001F73C8134B1B4EF9E150", false);
    }

    public static Sect131 r2() {
        return new Sect131("1.3.132.0.23", "03E5A88919D7CAFCBF415F07C2176573B2", "04B8266A46C55657AC734CE38F018F2192", "0400000000000000016954A233049BA98F", "02", "04 0356DCD8F2F95031AD652D23951BB366A8 0648F06D867940A5366D9E265DE9EB240F", false);
    }

    private Sect131(String oid, String aHex, String bHex, String orderHex, String cofactorHex, String gPointHex, boolean isKoblitz) {
        super(131, 2, 3, 8, 3, isKoblitz);
        super.init(new Element(), new CustomF2mCurve.Point(null, null, null), oid, aHex, bHex, orderHex, cofactorHex, gPointHex);
    }

    private static void invert(long[] x, long[] z) {
        Ex.MUST(!Nat.isZero64(x));
        long[] t0 = new long[3];
        long[] t1 = new long[3];
        Sect131.square(x, t0);
        Sect131.multiply(t0, x, t0);
        Sect131.squareN(t0, 2, t1);
        Sect131.multiply(t1, t0, t1);
        Sect131.squareN(t1, 4, t0);
        Sect131.multiply(t0, t1, t0);
        Sect131.squareN(t0, 8, t1);
        Sect131.multiply(t1, t0, t1);
        Sect131.squareN(t1, 16, t0);
        Sect131.multiply(t0, t1, t0);
        Sect131.squareN(t0, 32, t1);
        Sect131.multiply(t1, t0, t1);
        Sect131.square(t1, t1);
        Sect131.multiply(t1, x, t1);
        Sect131.squareN(t1, 65, t0);
        Sect131.multiply(t0, t1, t0);
        Sect131.square(t0, z);
    }

    private static void multiply(long[] x, long[] y, long[] z) {
        long[] tt = new long[6];
        Sect131.implMultiply(x, y, tt);
        Sect131.reduce(tt, z);
    }

    private static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] tt = new long[6];
        Sect131.implMultiply(x, y, tt);
        Sect131.add(zz, tt, zz);
    }

    private static void reduce(long[] xx, long[] z) {
        long x0 = xx[0];
        long x1 = xx[1];
        long x2 = xx[2];
        long x3 = xx[3];
        long x4 = xx[4];
        x1 ^= x4 << 61 ^ x4 << 63;
        x2 ^= x4 >>> 3 ^ x4 >>> 1 ^ x4 ^ x4 << 5;
        long t = (x2 ^= x3 >>> 59) >>> 3;
        z[0] = (x0 ^= (x3 ^= x4 >>> 59) << 61 ^ x3 << 63) ^ t ^ t << 2 ^ t << 3 ^ t << 8;
        z[1] = (x1 ^= x3 >>> 3 ^ x3 >>> 1 ^ x3 ^ x3 << 5) ^ t >>> 56;
        z[2] = x2 & 7L;
    }

    private static void sqrt(long[] x, long[] z) {
        long[] odd = new long[3];
        long u0 = Nat.unshuffle(x[0]);
        long u1 = Nat.unshuffle(x[1]);
        long e0 = u0 & 0xFFFFFFFFL | u1 << 32;
        odd[0] = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        u0 = Nat.unshuffle(x[2]);
        long e1 = u0 & 0xFFFFFFFFL;
        odd[1] = u0 >>> 32;
        Sect131.multiply(odd, ROOT_Z, z);
        z[0] = z[0] ^ e0;
        z[1] = z[1] ^ e1;
    }

    private static void square(long[] x, long[] z) {
        long[] tt = new long[5];
        Sect131.implSquare(x, tt);
        Sect131.reduce(tt, z);
    }

    private static void squareAddToExt(long[] x, long[] zz) {
        long[] tt = new long[5];
        Sect131.implSquare(x, tt);
        Sect131.add(zz, tt, zz);
    }

    private static void squareN(long[] x, int n, long[] z) {
        long[] tt = new long[5];
        Sect131.implSquare(x, tt);
        Sect131.reduce(tt, z);
        while (--n > 0) {
            Sect131.implSquare(z, tt);
            Sect131.reduce(tt, z);
        }
    }

    private static void implCompactExt(long[] zz) {
        long z0 = zz[0];
        long z1 = zz[1];
        long z2 = zz[2];
        long z3 = zz[3];
        long z4 = zz[4];
        long z5 = zz[5];
        zz[0] = z0 ^ z1 << 44;
        zz[1] = z1 >>> 20 ^ z2 << 24;
        zz[2] = z2 >>> 40 ^ z3 << 4 ^ z4 << 48;
        zz[3] = z3 >>> 60 ^ z5 << 28 ^ z4 >>> 16;
        zz[4] = z5 >>> 36;
        zz[5] = 0L;
    }

    private static void implMultiply(long[] x, long[] y, long[] zz) {
        long f0 = x[0];
        long f1 = x[1];
        long f2 = x[2];
        f2 = (f1 >>> 24 ^ f2 << 40) & 0xFFFFFFFFFFFL;
        f1 = (f0 >>> 44 ^ f1 << 20) & 0xFFFFFFFFFFFL;
        f0 &= 0xFFFFFFFFFFFL;
        long g0 = y[0];
        long g1 = y[1];
        long g2 = y[2];
        g2 = (g1 >>> 24 ^ g2 << 40) & 0xFFFFFFFFFFFL;
        g1 = (g0 >>> 44 ^ g1 << 20) & 0xFFFFFFFFFFFL;
        long[] H = new long[10];
        Sect131.implMulw(f0, g0 &= 0xFFFFFFFFFFFL, H, 0);
        Sect131.implMulw(f2, g2, H, 2);
        long t0 = f0 ^ f1 ^ f2;
        long t1 = g0 ^ g1 ^ g2;
        Sect131.implMulw(t0, t1, H, 4);
        long t2 = f1 << 1 ^ f2 << 2;
        long t3 = g1 << 1 ^ g2 << 2;
        Sect131.implMulw(f0 ^ t2, g0 ^ t3, H, 6);
        Sect131.implMulw(t0 ^ t2, t1 ^ t3, H, 8);
        long t4 = H[6] ^ H[8];
        long t5 = H[7] ^ H[9];
        long v0 = t4 << 1 ^ H[6];
        long v1 = t4 ^ t5 << 1 ^ H[7];
        long v2 = t5;
        long u0 = H[0];
        long u1 = H[1] ^ H[0] ^ H[4];
        long u2 = H[1] ^ H[5];
        long w0 = u0 ^ v0 ^ H[2] << 4 ^ H[2] << 1;
        long w1 = u1 ^ v1 ^ H[3] << 4 ^ H[3] << 1;
        long w2 = u2 ^ v2;
        w1 ^= w0 >>> 44;
        w0 &= 0xFFFFFFFFFFFL;
        w2 ^= w1 >>> 44;
        w0 = w0 >>> 1 ^ ((w1 &= 0xFFFFFFFFFFFL) & 1L) << 43;
        w1 = w1 >>> 1 ^ (w2 & 1L) << 43;
        w2 >>>= 1;
        w0 ^= w0 << 1;
        w0 ^= w0 << 2;
        w0 ^= w0 << 4;
        w0 ^= w0 << 8;
        w0 ^= w0 << 16;
        w0 ^= w0 << 32;
        w1 ^= (w0 &= 0xFFFFFFFFFFFL) >>> 43;
        w1 ^= w1 << 1;
        w1 ^= w1 << 2;
        w1 ^= w1 << 4;
        w1 ^= w1 << 8;
        w1 ^= w1 << 16;
        w1 ^= w1 << 32;
        w2 ^= (w1 &= 0xFFFFFFFFFFFL) >>> 43;
        w2 ^= w2 << 1;
        w2 ^= w2 << 2;
        w2 ^= w2 << 4;
        w2 ^= w2 << 8;
        w2 ^= w2 << 16;
        w2 ^= w2 << 32;
        zz[0] = u0;
        zz[1] = u1 ^ w0 ^ H[2];
        zz[2] = u2 ^ w1 ^ w0 ^ H[3];
        zz[3] = w2 ^ w1;
        zz[4] = w2 ^ H[2];
        zz[5] = H[3];
        Sect131.implCompactExt(zz);
    }

    private static void implMulw(long x, long y, long[] z, int zOff) {
        long[] u = new long[8];
        u[1] = y;
        u[2] = u[1] << 1;
        u[3] = u[2] ^ y;
        u[4] = u[2] << 1;
        u[5] = u[4] ^ y;
        u[6] = u[3] << 1;
        u[7] = u[6] ^ y;
        int j = (int)x;
        long h = 0L;
        long l = u[j & 7] ^ u[j >>> 3 & 7] << 3 ^ u[j >>> 6 & 7] << 6;
        int k = 33;
        do {
            j = (int)(x >>> k);
            long g = u[j & 7] ^ u[j >>> 3 & 7] << 3 ^ u[j >>> 6 & 7] << 6 ^ u[j >>> 9 & 7] << 9;
            l ^= g << k;
            h ^= g >>> -k;
        } while ((k -= 12) > 0);
        z[zOff] = l & 0xFFFFFFFFFFFL;
        z[zOff + 1] = l >>> 44 ^ h << 20;
    }

    private static void implSquare(long[] x, long[] zz) {
        Nat.expand64To128(x[0], zz, 0);
        Nat.expand64To128(x[1], zz, 2);
        zz[4] = (long)Nat.expand8to16((int)x[2]) & 0xFFFFFFFFL;
    }

    private class Element
    extends CustomF2mCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            super(X);
            long t = this.arr[2] >>> 3;
            this.arr[0] = this.arr[0] ^ (t ^ t << 2 ^ t << 3 ^ t << 8);
            this.arr[1] = this.arr[1] ^ t >>> 56;
            this.arr[2] = this.arr[2] & 7L;
        }

        private Element(long[] x) {
            super(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        protected Element create(long[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement multiply(ECCurve.ECElement b) {
            long[] z = new long[3];
            Sect131.multiply(this.arr, ((Element)b).arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement multiplyPlusProduct(ECCurve.ECElement b, ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] bx = ((Element)b).arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[5];
            Sect131.multiplyAddToExt(ax, bx, tt);
            Sect131.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[3];
            Sect131.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement square() {
            long[] z = new long[3];
            Sect131.square(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePlusProduct(ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[5];
            Sect131.squareAddToExt(ax, tt);
            Sect131.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[3];
            Sect131.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePow(int pow) {
            if (pow < 1) {
                return this;
            }
            long[] z = new long[3];
            Sect131.squareN(this.arr, pow, z);
            return new Element(z);
        }

        @Override
        public int trace() {
            return (int)(this.arr[0] ^ this.arr[1] >>> 59 ^ this.arr[2] >>> 1) & 1;
        }

        @Override
        public ECCurve.ECElement invert() {
            long[] z = new long[3];
            Sect131.invert(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            long[] z = new long[3];
            Sect131.sqrt(this.arr, z);
            return new Element(z);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Element)) {
                return false;
            }
            Element o = (Element)other;
            return Arrays.equals(this.arr, o.arr);
        }

        public int hashCode() {
            return 0x202F8 ^ Arrays.hashCode(this.arr);
        }
    }
}

