/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.F2m.custom.CustomF2mCurve;
import org.denom.crypt.ec.Nat;

public class Sect163
extends CustomF2mCurve {
    private static final int ARR_LEN = 3;
    private static final int ARR_LEN2 = 6;
    private static final long M35 = 0x7FFFFFFFFL;
    private static final long M55 = 0x7FFFFFFFFFFFFFL;
    private static final long[] ROOT_Z = new long[]{-5270498306774157648L, 5270498306774195053L, 0x492492492L};

    public static Sect163 k1() {
        return new Sect163("1.3.132.0.1", "01", "01", "04000000000000000000020108A2E0CC0D99F8A5EF", "02", "04 02FE13C0537BBC11ACAA07D793DE4E6D5E5C94EEE8 0289070FB05D38FF58321F2E800536D538CCDAA3D9", true);
    }

    public static Sect163 r1() {
        return new Sect163("1.3.132.0.2", "07B6882CAAEFA84F9554FF8428BD88E246D2782AE2", "0713612DCDDCB40AAB946BDA29CA91F73AF958AFD9", "03FFFFFFFFFFFFFFFFFFFF48AAB689C29CA710279B", "02", "04 0369979697AB43897789566789567F787A7876A654 00435EDB42EFAFB2989D51FEFCE3C80988F41FF883", false);
    }

    public static Sect163 r2() {
        return new Sect163("1.3.132.0.15", "01", "020A601907B8C953CA1481EB10512F78744A3205FD", "040000000000000000000292FE77E70C12A4234C33", "02", "04 03F0EBA16286A2D57EA0991168D4994637E8343E36 00D51FBC6C71A0094FA2CDD545B11C5C0C797324F1", false);
    }

    private Sect163(String oid, String aHex, String bHex, String orderHex, String cofactorHex, String gPointHex, boolean isKoblitz) {
        super(163, 3, 6, 7, 3, isKoblitz);
        super.init(new Element(), new CustomF2mCurve.Point(null, null, null), oid, aHex, bHex, orderHex, cofactorHex, gPointHex);
    }

    private static void invert(long[] x, long[] z) {
        Ex.MUST(!Nat.isZero64(x));
        long[] t0 = new long[3];
        long[] t1 = new long[3];
        Sect163.square(x, t0);
        Sect163.squareN(t0, 1, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t1, 1, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t0, 3, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t1, 3, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t0, 9, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t1, 9, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t0, 27, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t1, 27, t1);
        Sect163.multiply(t0, t1, t0);
        Sect163.squareN(t0, 81, t1);
        Sect163.multiply(t0, t1, z);
    }

    private static void multiply(long[] x, long[] y, long[] z) {
        long[] tt = new long[6];
        Sect163.implMultiply(x, y, tt);
        Sect163.reduce(tt, z);
    }

    private static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] tt = new long[6];
        Sect163.implMultiply(x, y, tt);
        Sect163.add(zz, tt, zz);
    }

    private static void reduce(long[] xx, long[] z) {
        long x0 = xx[0];
        long x1 = xx[1];
        long x2 = xx[2];
        long x3 = xx[3];
        long x4 = xx[4];
        long x5 = xx[5];
        x2 ^= x5 << 29 ^ x5 << 32 ^ x5 << 35 ^ x5 << 36;
        x1 ^= x4 << 29 ^ x4 << 32 ^ x4 << 35 ^ x4 << 36;
        long t = (x2 ^= x4 >>> 35 ^ x4 >>> 32 ^ x4 >>> 29 ^ x4 >>> 28) >>> 35;
        z[0] = (x0 ^= (x3 ^= x5 >>> 35 ^ x5 >>> 32 ^ x5 >>> 29 ^ x5 >>> 28) << 29 ^ x3 << 32 ^ x3 << 35 ^ x3 << 36) ^ t ^ t << 3 ^ t << 6 ^ t << 7;
        z[1] = x1 ^= x3 >>> 35 ^ x3 >>> 32 ^ x3 >>> 29 ^ x3 >>> 28;
        z[2] = x2 & 0x7FFFFFFFFL;
    }

    private static void sqrt(long[] x, long[] z) {
        long[] odd = new long[3];
        long u0 = Nat.unshuffle(x[0]);
        long u1 = Nat.unshuffle(x[1]);
        long e0 = u0 & 0xFFFFFFFFL | u1 << 32;
        odd[0] = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        u0 = Nat.unshuffle(x[2]);
        long e1 = u0 & 0xFFFFFFFFL;
        odd[1] = u0 >>> 32;
        Sect163.multiply(odd, ROOT_Z, z);
        z[0] = z[0] ^ e0;
        z[1] = z[1] ^ e1;
    }

    private static void square(long[] x, long[] z) {
        long[] tt = new long[6];
        Sect163.implSquare(x, tt);
        Sect163.reduce(tt, z);
    }

    private static void squareAddToExt(long[] x, long[] zz) {
        long[] tt = new long[6];
        Sect163.implSquare(x, tt);
        Sect163.add(zz, tt, zz);
    }

    private static void squareN(long[] x, int n, long[] z) {
        long[] tt = new long[6];
        Sect163.implSquare(x, tt);
        Sect163.reduce(tt, z);
        while (--n > 0) {
            Sect163.implSquare(z, tt);
            Sect163.reduce(tt, z);
        }
    }

    private static void implCompactExt(long[] zz) {
        long z0 = zz[0];
        long z1 = zz[1];
        long z2 = zz[2];
        long z3 = zz[3];
        long z4 = zz[4];
        long z5 = zz[5];
        zz[0] = z0 ^ z1 << 55;
        zz[1] = z1 >>> 9 ^ z2 << 46;
        zz[2] = z2 >>> 18 ^ z3 << 37;
        zz[3] = z3 >>> 27 ^ z4 << 28;
        zz[4] = z4 >>> 36 ^ z5 << 19;
        zz[5] = z5 >>> 45;
    }

    private static void implMultiply(long[] x, long[] y, long[] zz) {
        long f0 = x[0];
        long f1 = x[1];
        long f2 = x[2];
        f2 = f1 >>> 46 ^ f2 << 18;
        f1 = (f0 >>> 55 ^ f1 << 9) & 0x7FFFFFFFFFFFFFL;
        f0 &= 0x7FFFFFFFFFFFFFL;
        long g0 = y[0];
        long g1 = y[1];
        long g2 = y[2];
        g2 = g1 >>> 46 ^ g2 << 18;
        g1 = (g0 >>> 55 ^ g1 << 9) & 0x7FFFFFFFFFFFFFL;
        long[] H = new long[10];
        Sect163.implMulw(f0, g0 &= 0x7FFFFFFFFFFFFFL, H, 0);
        Sect163.implMulw(f2, g2, H, 2);
        long t0 = f0 ^ f1 ^ f2;
        long t1 = g0 ^ g1 ^ g2;
        Sect163.implMulw(t0, t1, H, 4);
        long t2 = f1 << 1 ^ f2 << 2;
        long t3 = g1 << 1 ^ g2 << 2;
        Sect163.implMulw(f0 ^ t2, g0 ^ t3, H, 6);
        Sect163.implMulw(t0 ^ t2, t1 ^ t3, H, 8);
        long t4 = H[6] ^ H[8];
        long t5 = H[7] ^ H[9];
        long v0 = t4 << 1 ^ H[6];
        long v1 = t4 ^ t5 << 1 ^ H[7];
        long v2 = t5;
        long u0 = H[0];
        long u1 = H[1] ^ H[0] ^ H[4];
        long u2 = H[1] ^ H[5];
        long w0 = u0 ^ v0 ^ H[2] << 4 ^ H[2] << 1;
        long w1 = u1 ^ v1 ^ H[3] << 4 ^ H[3] << 1;
        long w2 = u2 ^ v2;
        w1 ^= w0 >>> 55;
        w0 &= 0x7FFFFFFFFFFFFFL;
        w2 ^= w1 >>> 55;
        w0 = w0 >>> 1 ^ ((w1 &= 0x7FFFFFFFFFFFFFL) & 1L) << 54;
        w1 = w1 >>> 1 ^ (w2 & 1L) << 54;
        w2 >>>= 1;
        w0 ^= w0 << 1;
        w0 ^= w0 << 2;
        w0 ^= w0 << 4;
        w0 ^= w0 << 8;
        w0 ^= w0 << 16;
        w0 ^= w0 << 32;
        w1 ^= (w0 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        w1 ^= w1 << 1;
        w1 ^= w1 << 2;
        w1 ^= w1 << 4;
        w1 ^= w1 << 8;
        w1 ^= w1 << 16;
        w1 ^= w1 << 32;
        w2 ^= (w1 &= 0x7FFFFFFFFFFFFFL) >>> 54;
        w2 ^= w2 << 1;
        w2 ^= w2 << 2;
        w2 ^= w2 << 4;
        w2 ^= w2 << 8;
        w2 ^= w2 << 16;
        w2 ^= w2 << 32;
        zz[0] = u0;
        zz[1] = u1 ^ w0 ^ H[2];
        zz[2] = u2 ^ w1 ^ w0 ^ H[3];
        zz[3] = w2 ^ w1;
        zz[4] = w2 ^ H[2];
        zz[5] = H[3];
        Sect163.implCompactExt(zz);
    }

    private static void implMulw(long x, long y, long[] z, int zOff) {
        long[] u = new long[8];
        u[1] = y;
        u[2] = u[1] << 1;
        u[3] = u[2] ^ y;
        u[4] = u[2] << 1;
        u[5] = u[4] ^ y;
        u[6] = u[3] << 1;
        u[7] = u[6] ^ y;
        int j = (int)x;
        long h = 0L;
        long l = u[j & 3];
        int k = 47;
        do {
            j = (int)(x >>> k);
            long g = u[j & 7] ^ u[j >>> 3 & 7] << 3 ^ u[j >>> 6 & 7] << 6;
            l ^= g << k;
            h ^= g >>> -k;
        } while ((k -= 9) > 0);
        z[zOff] = l & 0x7FFFFFFFFFFFFFL;
        z[zOff + 1] = l >>> 55 ^ h << 9;
    }

    private static void implSquare(long[] x, long[] zz) {
        Nat.expand64To128(x[0], zz, 0);
        Nat.expand64To128(x[1], zz, 2);
        long x2 = x[2];
        zz[4] = Nat.expand32to64((int)x2);
        zz[5] = (long)Nat.expand8to16((int)(x2 >>> 32)) & 0xFFFFFFFFL;
    }

    private class Element
    extends CustomF2mCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            super(X);
            long t = this.arr[2] >>> 35;
            this.arr[0] = this.arr[0] ^ (t ^ t << 3 ^ t << 6 ^ t << 7);
            this.arr[2] = this.arr[2] & 0x7FFFFFFFFL;
        }

        private Element(long[] x) {
            super(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        protected Element create(long[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement multiply(ECCurve.ECElement b) {
            long[] z = new long[3];
            Sect163.multiply(this.arr, ((Element)b).arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement multiplyPlusProduct(ECCurve.ECElement b, ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] bx = ((Element)b).arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[6];
            Sect163.multiplyAddToExt(ax, bx, tt);
            Sect163.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[3];
            Sect163.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement square() {
            long[] z = new long[3];
            Sect163.square(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePlusProduct(ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[6];
            Sect163.squareAddToExt(ax, tt);
            Sect163.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[3];
            Sect163.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePow(int pow) {
            if (pow < 1) {
                return this;
            }
            long[] z = new long[3];
            Sect163.squareN(this.arr, pow, z);
            return new Element(z);
        }

        @Override
        public int trace() {
            return (int)(this.arr[0] ^ this.arr[2] >>> 29) & 1;
        }

        @Override
        public ECCurve.ECElement invert() {
            long[] z = new long[3];
            Sect163.invert(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            long[] z = new long[3];
            Sect163.sqrt(this.arr, z);
            return new Element(z);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Element)) {
                return false;
            }
            Element o = (Element)other;
            return Arrays.equals(this.arr, o.arr);
        }

        public int hashCode() {
            return 0x27FB3 ^ Arrays.hashCode(this.arr);
        }
    }
}

