/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.F2m.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.F2m.custom.CustomF2mCurve;
import org.denom.crypt.ec.Nat;

public class Sect239
extends CustomF2mCurve {
    private static final int ARR_LEN = 4;
    private static final int ARR_LEN2 = 8;
    private static final long M47 = 0x7FFFFFFFFFFFL;
    private static final long M60 = 0xFFFFFFFFFFFFFFFL;

    public static Sect239 k1() {
        return new Sect239("1.3.132.0.3", "00", "01", "2000000000000000000000000000005A79FEC67CB6E91F1C1DA800E478A5", "04", "04 29A0B6A887A983E9730988A68727A8B2D126C44CC2CC7B2A6555193035DC 76310804F12E549BDB011C103089E73510ACB275FC312A5DC6B76553F0CA", true);
    }

    private Sect239(String oid, String aHex, String bHex, String orderHex, String cofactorHex, String gPointHex, boolean isKoblitz) {
        super(239, 158, 0, 0, 4, isKoblitz);
        super.init(new Element(), new CustomF2mCurve.Point(null, null, null), oid, aHex, bHex, orderHex, cofactorHex, gPointHex);
    }

    private static void invert(long[] x, long[] z) {
        Ex.MUST(!Nat.isZero64(x));
        long[] t0 = new long[4];
        long[] t1 = new long[4];
        Sect239.square(x, t0);
        Sect239.multiply(t0, x, t0);
        Sect239.square(t0, t0);
        Sect239.multiply(t0, x, t0);
        Sect239.squareN(t0, 3, t1);
        Sect239.multiply(t1, t0, t1);
        Sect239.square(t1, t1);
        Sect239.multiply(t1, x, t1);
        Sect239.squareN(t1, 7, t0);
        Sect239.multiply(t0, t1, t0);
        Sect239.squareN(t0, 14, t1);
        Sect239.multiply(t1, t0, t1);
        Sect239.square(t1, t1);
        Sect239.multiply(t1, x, t1);
        Sect239.squareN(t1, 29, t0);
        Sect239.multiply(t0, t1, t0);
        Sect239.square(t0, t0);
        Sect239.multiply(t0, x, t0);
        Sect239.squareN(t0, 59, t1);
        Sect239.multiply(t1, t0, t1);
        Sect239.square(t1, t1);
        Sect239.multiply(t1, x, t1);
        Sect239.squareN(t1, 119, t0);
        Sect239.multiply(t0, t1, t0);
        Sect239.square(t0, z);
    }

    private static void multiply(long[] x, long[] y, long[] z) {
        long[] tt = new long[8];
        Sect239.implMultiply(x, y, tt);
        Sect239.reduce(tt, z);
    }

    private static void multiplyAddToExt(long[] x, long[] y, long[] zz) {
        long[] tt = new long[8];
        Sect239.implMultiply(x, y, tt);
        Sect239.add(zz, tt, zz);
    }

    private static void reduce(long[] xx, long[] z) {
        long x0 = xx[0];
        long x1 = xx[1];
        long x2 = xx[2];
        long x3 = xx[3];
        long x4 = xx[4];
        long x5 = xx[5];
        long x6 = xx[6];
        long x7 = xx[7];
        x3 ^= x7 << 17;
        x4 ^= x7 >>> 47;
        x5 ^= x7 << 47;
        x2 ^= (x6 ^= x7 >>> 17) << 17;
        x3 ^= x6 >>> 47;
        x4 ^= x6 << 47;
        x1 ^= (x5 ^= x6 >>> 17) << 17;
        x2 ^= x5 >>> 47;
        x3 ^= x5 << 47;
        long t = (x3 ^= x4 >>> 17) >>> 47;
        z[0] = (x0 ^= (x4 ^= x5 >>> 17) << 17) ^ t;
        z[1] = x1 ^= x4 >>> 47;
        z[2] = (x2 ^= x4 << 47) ^ t << 30;
        z[3] = x3 & 0x7FFFFFFFFFFFL;
    }

    private static void sqrt(long[] x, long[] z) {
        long u0 = Nat.unshuffle(x[0]);
        long u1 = Nat.unshuffle(x[1]);
        long e0 = u0 & 0xFFFFFFFFL | u1 << 32;
        long c0 = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        u0 = Nat.unshuffle(x[2]);
        u1 = Nat.unshuffle(x[3]);
        long e1 = u0 & 0xFFFFFFFFL | u1 << 32;
        long c1 = u0 >>> 32 | u1 & 0xFFFFFFFF00000000L;
        long c3 = c1 >>> 49;
        long c2 = c0 >>> 49 | c1 << 15;
        c1 ^= c0 << 15;
        long[] tt = new long[8];
        int[] shifts = new int[]{39, 120};
        int i = 0;
        while (i < shifts.length) {
            int w = shifts[i] >>> 6;
            int s = shifts[i] & 0x3F;
            int n = w;
            tt[n] = tt[n] ^ c0 << s;
            int n2 = w + 1;
            tt[n2] = tt[n2] ^ (c1 << s | c0 >>> -s);
            int n3 = w + 2;
            tt[n3] = tt[n3] ^ (c2 << s | c1 >>> -s);
            int n4 = w + 3;
            tt[n4] = tt[n4] ^ (c3 << s | c2 >>> -s);
            int n5 = w + 4;
            tt[n5] = tt[n5] ^ c3 >>> -s;
            ++i;
        }
        Sect239.reduce(tt, z);
        z[0] = z[0] ^ e0;
        z[1] = z[1] ^ e1;
    }

    private static void square(long[] x, long[] z) {
        long[] tt = new long[8];
        Sect239.implSquare(x, tt);
        Sect239.reduce(tt, z);
    }

    private static void squareAddToExt(long[] x, long[] zz) {
        long[] tt = new long[8];
        Sect239.implSquare(x, tt);
        Sect239.add(zz, tt, zz);
    }

    private static void squareN(long[] x, int n, long[] z) {
        long[] tt = new long[8];
        Sect239.implSquare(x, tt);
        Sect239.reduce(tt, z);
        while (--n > 0) {
            Sect239.implSquare(z, tt);
            Sect239.reduce(tt, z);
        }
    }

    private static void implCompactExt(long[] zz) {
        long z0 = zz[0];
        long z1 = zz[1];
        long z2 = zz[2];
        long z3 = zz[3];
        long z4 = zz[4];
        long z5 = zz[5];
        long z6 = zz[6];
        long z7 = zz[7];
        zz[0] = z0 ^ z1 << 60;
        zz[1] = z1 >>> 4 ^ z2 << 56;
        zz[2] = z2 >>> 8 ^ z3 << 52;
        zz[3] = z3 >>> 12 ^ z4 << 48;
        zz[4] = z4 >>> 16 ^ z5 << 44;
        zz[5] = z5 >>> 20 ^ z6 << 40;
        zz[6] = z6 >>> 24 ^ z7 << 36;
        zz[7] = z7 >>> 28;
    }

    private static void implExpand(long[] x, long[] z) {
        long x0 = x[0];
        long x1 = x[1];
        long x2 = x[2];
        long x3 = x[3];
        z[0] = x0 & 0xFFFFFFFFFFFFFFFL;
        z[1] = (x0 >>> 60 ^ x1 << 4) & 0xFFFFFFFFFFFFFFFL;
        z[2] = (x1 >>> 56 ^ x2 << 8) & 0xFFFFFFFFFFFFFFFL;
        z[3] = x2 >>> 52 ^ x3 << 12;
    }

    private static void implMultiply(long[] x, long[] y, long[] zz) {
        long[] f = new long[4];
        long[] g = new long[4];
        Sect239.implExpand(x, f);
        Sect239.implExpand(y, g);
        Sect239.implMulwAcc(f[0], g[0], zz, 0);
        Sect239.implMulwAcc(f[1], g[1], zz, 1);
        Sect239.implMulwAcc(f[2], g[2], zz, 2);
        Sect239.implMulwAcc(f[3], g[3], zz, 3);
        int i = 5;
        while (i > 0) {
            int n = i;
            zz[n] = zz[n] ^ zz[i - 1];
            --i;
        }
        Sect239.implMulwAcc(f[0] ^ f[1], g[0] ^ g[1], zz, 1);
        Sect239.implMulwAcc(f[2] ^ f[3], g[2] ^ g[3], zz, 3);
        i = 7;
        while (i > 1) {
            int n = i;
            zz[n] = zz[n] ^ zz[i - 2];
            --i;
        }
        long c0 = f[0] ^ f[2];
        long c1 = f[1] ^ f[3];
        long d0 = g[0] ^ g[2];
        long d1 = g[1] ^ g[3];
        Sect239.implMulwAcc(c0 ^ c1, d0 ^ d1, zz, 3);
        long[] t = new long[3];
        Sect239.implMulwAcc(c0, d0, t, 0);
        Sect239.implMulwAcc(c1, d1, t, 1);
        long t0 = t[0];
        long t1 = t[1];
        long t2 = t[2];
        zz[2] = zz[2] ^ t0;
        zz[3] = zz[3] ^ (t0 ^ t1);
        zz[4] = zz[4] ^ (t2 ^ t1);
        zz[5] = zz[5] ^ t2;
        Sect239.implCompactExt(zz);
    }

    private static void implMulwAcc(long x, long y, long[] z, int zOff) {
        long[] u = new long[8];
        u[1] = y;
        u[2] = u[1] << 1;
        u[3] = u[2] ^ y;
        u[4] = u[2] << 1;
        u[5] = u[4] ^ y;
        u[6] = u[3] << 1;
        u[7] = u[6] ^ y;
        int j = (int)x;
        long h = 0L;
        long l = u[j & 7] ^ u[j >>> 3 & 7] << 3;
        int k = 54;
        do {
            j = (int)(x >>> k);
            long g = u[j & 7] ^ u[j >>> 3 & 7] << 3;
            l ^= g << k;
            h ^= g >>> -k;
        } while ((k -= 6) > 0);
        int n = zOff;
        z[n] = z[n] ^ l & 0xFFFFFFFFFFFFFFFL;
        int n2 = zOff + 1;
        z[n2] = z[n2] ^ (l >>> 60 ^ (h ^= (x & 0x820820820820820L & y << 4 >> 63) >>> 5) << 4);
    }

    private static void implSquare(long[] x, long[] zz) {
        Nat.expand64To128(x[0], zz, 0);
        Nat.expand64To128(x[1], zz, 2);
        Nat.expand64To128(x[2], zz, 4);
        long x3 = x[3];
        zz[6] = Nat.expand32to64((int)x3);
        zz[7] = (long)Nat.expand16to32((int)(x3 >>> 32)) & 0xFFFFFFFFL;
    }

    private class Element
    extends CustomF2mCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            super(X);
            long t = this.arr[3] >>> 47;
            this.arr[0] = this.arr[0] ^ t;
            this.arr[2] = this.arr[2] ^ t << 30;
            this.arr[3] = this.arr[3] & 0x7FFFFFFFFFFFL;
        }

        private Element(long[] x) {
            super(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        protected Element create(long[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement multiply(ECCurve.ECElement b) {
            long[] z = new long[4];
            Sect239.multiply(this.arr, ((Element)b).arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement multiplyPlusProduct(ECCurve.ECElement b, ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] bx = ((Element)b).arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[8];
            Sect239.multiplyAddToExt(ax, bx, tt);
            Sect239.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[4];
            Sect239.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement square() {
            long[] z = new long[4];
            Sect239.square(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePlusProduct(ECCurve.ECElement x, ECCurve.ECElement y) {
            long[] ax = this.arr;
            long[] xx = ((Element)x).arr;
            long[] yx = ((Element)y).arr;
            long[] tt = new long[8];
            Sect239.squareAddToExt(ax, tt);
            Sect239.multiplyAddToExt(xx, yx, tt);
            long[] z = new long[4];
            Sect239.reduce(tt, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement squarePow(int pow) {
            if (pow < 1) {
                return this;
            }
            long[] z = new long[4];
            Sect239.squareN(this.arr, pow, z);
            return new Element(z);
        }

        @Override
        public int trace() {
            return (int)(this.arr[0] ^ this.arr[1] >>> 17 ^ this.arr[2] >>> 34) & 1;
        }

        @Override
        public ECCurve.ECElement invert() {
            long[] z = new long[4];
            Sect239.invert(this.arr, z);
            return new Element(z);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            long[] z = new long[4];
            Sect239.sqrt(this.arr, z);
            return new Element(z);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Element)) {
                return false;
            }
            Element o = (Element)other;
            return Arrays.equals(this.arr, o.arr);
        }

        public int hashCode() {
            return 0x16CAFFE ^ Arrays.hashCode(this.arr);
        }
    }
}

