/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp;

import java.math.BigInteger;
import java.util.Random;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.FpCurveAbstract;
import org.denom.crypt.ec.Nat;

public class FpCurve
extends FpCurveAbstract {
    BigInteger r;

    public FpCurve(String oid, String pHex, String aHex, String bHex, String orderHex, String cofactorHex, String gPointHex) {
        super(pHex, false);
        this.r = FpCurve.calculateResidue(this.modP);
        super.init(new FpElement(), new FpPoint(null, null, null), oid, aHex, bHex, orderHex, cofactorHex, gPointHex);
    }

    private static BigInteger calculateResidue(BigInteger p) {
        BigInteger firstWord;
        int bitLength = p.bitLength();
        if (bitLength >= 96 && (firstWord = p.shiftRight(bitLength - 64)).longValue() == -1L) {
            return BigInteger.ONE.shiftLeft(bitLength).subtract(p);
        }
        return null;
    }

    private class FpElement
    extends FpCurveAbstract.FpElementAbstract {
        BigInteger q;
        BigInteger x;

        private FpElement() {
            super(FpCurve.this);
            this.q = FpCurve.this.modP;
        }

        private FpElement(BigInteger x) {
            super(FpCurve.this);
            this.q = FpCurve.this.modP;
            this.x = x;
            Ex.MUST(x != null && x.signum() >= 0 && x.compareTo(this.q) < 0);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new FpElement(x);
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x;
        }

        @Override
        public ECCurve.ECElement add(ECCurve.ECElement b) {
            return new FpElement(this.modAdd(this.x, b.toBigInteger()));
        }

        @Override
        public ECCurve.ECElement addOne() {
            BigInteger x2 = this.x.add(BigInteger.ONE);
            if (x2.compareTo(this.q) == 0) {
                x2 = BigInteger.ZERO;
            }
            return new FpElement(x2);
        }

        @Override
        public ECCurve.ECElement subtract(ECCurve.ECElement b) {
            return new FpElement(this.modSubtract(this.x, b.toBigInteger()));
        }

        @Override
        public ECCurve.ECElement multiply(ECCurve.ECElement b) {
            return new FpElement(this.modMult(this.x, b.toBigInteger()));
        }

        private ECCurve.ECElement multiplyMinusProduct(ECCurve.ECElement b, ECCurve.ECElement x, ECCurve.ECElement y) {
            BigInteger ax = this.x;
            BigInteger bx = b.toBigInteger();
            BigInteger xx = x.toBigInteger();
            BigInteger yx = y.toBigInteger();
            BigInteger ab = ax.multiply(bx);
            BigInteger xy = xx.multiply(yx);
            return new FpElement(this.modReduce(ab.subtract(xy)));
        }

        @Override
        public ECCurve.ECElement multiplyPlusProduct(ECCurve.ECElement b, ECCurve.ECElement x, ECCurve.ECElement y) {
            BigInteger ax = this.x;
            BigInteger bx = b.toBigInteger();
            BigInteger xx = x.toBigInteger();
            BigInteger yx = y.toBigInteger();
            BigInteger ab = ax.multiply(bx);
            BigInteger xy = xx.multiply(yx);
            return new FpElement(this.modReduce(ab.add(xy)));
        }

        @Override
        public ECCurve.ECElement divide(ECCurve.ECElement b) {
            return new FpElement(this.modMult(this.x, this.modInverse(b.toBigInteger())));
        }

        @Override
        public ECCurve.ECElement negate() {
            return this.x.signum() == 0 ? this : new FpElement(this.q.subtract(this.x));
        }

        @Override
        public ECCurve.ECElement square() {
            return new FpElement(this.modMult(this.x, this.x));
        }

        @Override
        public ECCurve.ECElement squarePlusProduct(ECCurve.ECElement x, ECCurve.ECElement y) {
            BigInteger ax = this.x;
            BigInteger xx = x.toBigInteger();
            BigInteger yx = y.toBigInteger();
            BigInteger aa = ax.multiply(ax);
            BigInteger xy = xx.multiply(yx);
            return new FpElement(this.modReduce(aa.add(xy)));
        }

        @Override
        public ECCurve.ECElement invert() {
            return new FpElement(this.modInverse(this.x));
        }

        @Override
        public ECCurve.ECElement sqrt() {
            if (this.isZero() || this.isOne()) {
                return this;
            }
            if (!this.q.testBit(0)) {
                throw new RuntimeException("not done yet");
            }
            if (this.q.testBit(1)) {
                BigInteger e = this.q.shiftRight(2).add(BigInteger.ONE);
                return this.checkSqrt(new FpElement(this.x.modPow(e, this.q)));
            }
            if (this.q.testBit(2)) {
                BigInteger t1 = this.x.modPow(this.q.shiftRight(3), this.q);
                BigInteger t2 = this.modMult(t1, this.x);
                BigInteger t3 = this.modMult(t2, t1);
                if (t3.equals(BigInteger.ONE)) {
                    return this.checkSqrt(new FpElement(t2));
                }
                BigInteger t4 = BigInteger.valueOf(2L).modPow(this.q.shiftRight(2), this.q);
                BigInteger y = this.modMult(t2, t4);
                return this.checkSqrt(new FpElement(y));
            }
            BigInteger legendreExponent = this.q.shiftRight(1);
            if (!this.x.modPow(legendreExponent, this.q).equals(BigInteger.ONE)) {
                return null;
            }
            BigInteger X = this.x;
            BigInteger fourX = this.modDouble(this.modDouble(X));
            BigInteger k = legendreExponent.add(BigInteger.ONE);
            BigInteger qMinusOne = this.q.subtract(BigInteger.ONE);
            Random rand = new Random();
            while (true) {
                BigInteger P;
                if ((P = new BigInteger(this.q.bitLength(), rand)).compareTo(this.q) >= 0 || !this.modReduce(P.multiply(P).subtract(fourX)).modPow(legendreExponent, this.q).equals(qMinusOne)) {
                    continue;
                }
                BigInteger[] result = this.lucasSequence(P, X, k);
                BigInteger U = result[0];
                BigInteger V = result[1];
                if (this.modMult(V, V).equals(fourX)) {
                    return new FpElement(this.modHalfAbs(V));
                }
                if (!U.equals(BigInteger.ONE) && !U.equals(qMinusOne)) break;
            }
            return null;
        }

        private ECCurve.ECElement checkSqrt(ECCurve.ECElement z) {
            return z.square().equals(this) ? z : null;
        }

        private BigInteger[] lucasSequence(BigInteger P, BigInteger Q, BigInteger k) {
            int n = k.bitLength();
            int s = k.getLowestSetBit();
            BigInteger Uh = BigInteger.ONE;
            BigInteger Vl = BigInteger.valueOf(2L);
            BigInteger Vh = P;
            BigInteger Ql = BigInteger.ONE;
            BigInteger Qh = BigInteger.ONE;
            int j = n - 1;
            while (j >= s + 1) {
                Ql = this.modMult(Ql, Qh);
                if (k.testBit(j)) {
                    Qh = this.modMult(Ql, Q);
                    Uh = this.modMult(Uh, Vh);
                    Vl = this.modReduce(Vh.multiply(Vl).subtract(P.multiply(Ql)));
                    Vh = this.modReduce(Vh.multiply(Vh).subtract(Qh.shiftLeft(1)));
                } else {
                    Qh = Ql;
                    Uh = this.modReduce(Uh.multiply(Vl).subtract(Ql));
                    Vh = this.modReduce(Vh.multiply(Vl).subtract(P.multiply(Ql)));
                    Vl = this.modReduce(Vl.multiply(Vl).subtract(Ql.shiftLeft(1)));
                }
                --j;
            }
            Ql = this.modMult(Ql, Qh);
            Qh = this.modMult(Ql, Q);
            Uh = this.modReduce(Uh.multiply(Vl).subtract(Ql));
            Vl = this.modReduce(Vh.multiply(Vl).subtract(P.multiply(Ql)));
            Ql = this.modMult(Ql, Qh);
            j = 1;
            while (j <= s) {
                Uh = this.modMult(Uh, Vl);
                Vl = this.modReduce(Vl.multiply(Vl).subtract(Ql.shiftLeft(1)));
                Ql = this.modMult(Ql, Ql);
                ++j;
            }
            return new BigInteger[]{Uh, Vl};
        }

        private BigInteger modAdd(BigInteger x1, BigInteger x2) {
            BigInteger x3 = x1.add(x2);
            if (x3.compareTo(this.q) >= 0) {
                x3 = x3.subtract(this.q);
            }
            return x3;
        }

        private BigInteger modDouble(BigInteger x) {
            BigInteger _2x = x.shiftLeft(1);
            if (_2x.compareTo(this.q) >= 0) {
                _2x = _2x.subtract(this.q);
            }
            return _2x;
        }

        private BigInteger modHalfAbs(BigInteger x) {
            if (x.testBit(0)) {
                x = this.q.subtract(x);
            }
            return x.shiftRight(1);
        }

        private BigInteger modInverse(BigInteger x) {
            int bits = this.getFieldSize();
            int len = bits + 31 >> 5;
            int[] p = Nat.fromBigInteger(bits, this.q);
            int[] n = Nat.fromBigInteger(bits, x);
            int[] z = new int[len];
            Nat.invert(p, n, z);
            return Nat.toBigInteger(len, z);
        }

        private BigInteger modMult(BigInteger x1, BigInteger x2) {
            return this.modReduce(x1.multiply(x2));
        }

        private BigInteger modReduce(BigInteger x) {
            if (FpCurve.this.r != null) {
                boolean negative;
                boolean bl = negative = x.signum() < 0;
                if (negative) {
                    x = x.abs();
                }
                int qLen = this.q.bitLength();
                boolean rIsOne = FpCurve.this.r.equals(BigInteger.ONE);
                while (x.bitLength() > qLen + 1) {
                    BigInteger u = x.shiftRight(qLen);
                    BigInteger v = x.subtract(u.shiftLeft(qLen));
                    if (!rIsOne) {
                        u = u.multiply(FpCurve.this.r);
                    }
                    x = u.add(v);
                }
                while (x.compareTo(this.q) >= 0) {
                    x = x.subtract(this.q);
                }
                if (negative && x.signum() != 0) {
                    x = this.q.subtract(x);
                }
            } else {
                x = x.mod(this.q);
            }
            return x;
        }

        private BigInteger modSubtract(BigInteger x1, BigInteger x2) {
            BigInteger x3 = x1.subtract(x2);
            if (x3.signum() < 0) {
                x3 = x3.add(this.q);
            }
            return x3;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof FpElement)) {
                return false;
            }
            FpElement o = (FpElement)other;
            return this.q.equals(o.q) && this.x.equals(o.x);
        }

        public int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }

    private class FpPoint
    extends FpCurveAbstract.FpPointAbstract {
        private FpPoint(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(FpCurve.this, x, y);
            Ex.MUST(x == null == (y == null));
        }

        private FpPoint(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(FpCurve.this, x, y, zs);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y) {
            return new FpPoint(x, y);
        }

        @Override
        protected ECCurve.ECPoint create(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            return new FpPoint(x, y, zs);
        }

        @Override
        public ECCurve.ECElement getZCoord(int index) {
            if (index == 1 && FpCurve.this.isJacobianModified) {
                return this.getJacobianModifiedW();
            }
            return super.getZCoord(index);
        }

        @Override
        public ECCurve.ECPoint add(ECCurve.ECPoint b) {
            ECCurve.ECElement Z3;
            ECCurve.ECElement Y3;
            ECCurve.ECElement X3;
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this;
            }
            if (this == b) {
                return this.twice();
            }
            ECCurve.ECElement X1 = this.x;
            ECCurve.ECElement Y1 = this.y;
            ECCurve.ECElement X2 = b.x;
            ECCurve.ECElement Y2 = b.y;
            ECCurve.ECElement Z1 = this.zs[0];
            ECCurve.ECElement Z2 = b.zs[0];
            boolean Z1IsOne = Z1.isOne();
            ECCurve.ECElement Z3Squared = null;
            if (!Z1IsOne && Z1.equals(Z2)) {
                ECCurve.ECElement dx = X1.subtract(X2);
                ECCurve.ECElement dy = Y1.subtract(Y2);
                if (dx.isZero()) {
                    if (dy.isZero()) {
                        return this.twice();
                    }
                    return FpCurve.this.getInfinity();
                }
                ECCurve.ECElement C = dx.square();
                ECCurve.ECElement W1 = X1.multiply(C);
                ECCurve.ECElement W2 = X2.multiply(C);
                ECCurve.ECElement A1 = W1.subtract(W2).multiply(Y1);
                X3 = dy.square().subtract(W1).subtract(W2);
                Y3 = W1.subtract(X3).multiply(dy).subtract(A1);
                Z3 = dx;
                Z3 = Z3.multiply(Z1);
            } else {
                ECCurve.ECElement S1;
                ECCurve.ECElement U1;
                ECCurve.ECElement S2;
                ECCurve.ECElement U2;
                ECCurve.ECElement Z1Squared;
                if (Z1IsOne) {
                    Z1Squared = Z1;
                    U2 = X2;
                    S2 = Y2;
                } else {
                    Z1Squared = Z1.square();
                    U2 = Z1Squared.multiply(X2);
                    ECCurve.ECElement Z1Cubed = Z1Squared.multiply(Z1);
                    S2 = Z1Cubed.multiply(Y2);
                }
                boolean Z2IsOne = Z2.isOne();
                if (Z2IsOne) {
                    ECCurve.ECElement Z2Squared = Z2;
                    U1 = X1;
                    S1 = Y1;
                } else {
                    ECCurve.ECElement Z2Squared = Z2.square();
                    U1 = Z2Squared.multiply(X1);
                    ECCurve.ECElement Z2Cubed = Z2Squared.multiply(Z2);
                    S1 = Z2Cubed.multiply(Y1);
                }
                ECCurve.ECElement H = U1.subtract(U2);
                ECCurve.ECElement R = S1.subtract(S2);
                if (H.isZero()) {
                    if (R.isZero()) {
                        return this.twice();
                    }
                    return FpCurve.this.getInfinity();
                }
                ECCurve.ECElement HSquared = H.square();
                ECCurve.ECElement G = HSquared.multiply(H);
                ECCurve.ECElement V = HSquared.multiply(U1);
                X3 = R.square().add(G).subtract(this.two(V));
                Y3 = ((FpElement)V.subtract(X3)).multiplyMinusProduct(R, G, S1);
                Z3 = H;
                if (!Z1IsOne) {
                    Z3 = Z3.multiply(Z1);
                }
                if (!Z2IsOne) {
                    Z3 = Z3.multiply(Z2);
                }
                if (Z3 == H) {
                    Z3Squared = HSquared;
                }
            }
            if (FpCurve.this.isJacobianModified) {
                ECCurve.ECElement W3 = this.calculateJacobianModifiedW(Z3, Z3Squared);
                return new FpPoint(X3, Y3, new ECCurve.ECElement[]{Z3, W3});
            }
            return new FpPoint(X3, Y3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twice() {
            ECCurve.ECElement S;
            ECCurve.ECElement M;
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement Y1 = this.y;
            if (Y1.isZero()) {
                return FpCurve.this.getInfinity();
            }
            if (FpCurve.this.isJacobianModified) {
                return this.twiceJacobianModified(true);
            }
            ECCurve.ECElement X1 = this.x;
            ECCurve.ECElement Z1 = this.zs[0];
            boolean Z1IsOne = Z1.isOne();
            ECCurve.ECElement Y1Squared = Y1.square();
            ECCurve.ECElement T = Y1Squared.square();
            ECCurve.ECElement a4 = FpCurve.this.getA();
            ECCurve.ECElement a4Neg = a4.negate();
            if (a4Neg.toBigInteger().equals(BigInteger.valueOf(3L))) {
                ECCurve.ECElement Z1Squared = Z1IsOne ? Z1 : Z1.square();
                M = this.three(X1.add(Z1Squared).multiply(X1.subtract(Z1Squared)));
                S = this.four(Y1Squared.multiply(X1));
            } else {
                ECCurve.ECElement X1Squared = X1.square();
                M = this.three(X1Squared);
                if (Z1IsOne) {
                    M = M.add(a4);
                } else if (!a4.isZero()) {
                    ECCurve.ECElement Z1Squared = Z1.square();
                    ECCurve.ECElement Z1Pow4 = Z1Squared.square();
                    M = a4Neg.bitLength() < a4.bitLength() ? M.subtract(Z1Pow4.multiply(a4Neg)) : M.add(Z1Pow4.multiply(a4));
                }
                S = this.four(X1.multiply(Y1Squared));
            }
            ECCurve.ECElement X3 = M.square().subtract(this.two(S));
            ECCurve.ECElement Y3 = S.subtract(X3).multiply(M).subtract(this.eight(T));
            ECCurve.ECElement Z3 = this.two(Y1);
            if (!Z1IsOne) {
                Z3 = Z3.multiply(Z1);
            }
            return new FpPoint(X3, Y3, new ECCurve.ECElement[]{Z3});
        }

        @Override
        public ECCurve.ECPoint twicePlus(ECCurve.ECPoint b) {
            if (this.isInfinity()) {
                return b;
            }
            if (b.isInfinity()) {
                return this.twice();
            }
            ECCurve.ECElement Y1 = this.y;
            if (Y1.isZero()) {
                return b;
            }
            if (FpCurve.this.isJacobianModified) {
                return this.twiceJacobianModified(false).add(b);
            }
            return this.twice().add(b);
        }

        @Override
        public ECCurve.ECPoint timesPow2(int e) {
            ECCurve.ECElement Z1;
            Ex.MUST(e >= 0, "'e' cannot be negative");
            if (e == 0 || this.isInfinity()) {
                return this;
            }
            if (e == 1) {
                return this.twice();
            }
            ECCurve.ECElement Y1 = this.y;
            if (Y1.isZero()) {
                return FpCurve.this.getInfinity();
            }
            ECCurve.ECElement W1 = FpCurve.this.getA();
            ECCurve.ECElement X1 = this.x;
            ECCurve.ECElement eCElement = Z1 = this.zs.length < 1 ? FpCurve.this.fromBigInteger(BigInteger.ONE) : this.zs[0];
            if (!Z1.isOne()) {
                W1 = FpCurve.this.isJacobianModified ? this.getJacobianModifiedW() : this.calculateJacobianModifiedW(Z1, null);
            }
            int i = 0;
            while (i < e) {
                if (Y1.isZero()) {
                    return FpCurve.this.getInfinity();
                }
                ECCurve.ECElement X1Squared = X1.square();
                ECCurve.ECElement M = this.three(X1Squared);
                ECCurve.ECElement _2Y1 = this.two(Y1);
                ECCurve.ECElement _2Y1Squared = _2Y1.multiply(Y1);
                ECCurve.ECElement S = this.two(X1.multiply(_2Y1Squared));
                ECCurve.ECElement _4T = _2Y1Squared.square();
                ECCurve.ECElement _8T = this.two(_4T);
                if (!W1.isZero()) {
                    M = M.add(W1);
                    W1 = this.two(_8T.multiply(W1));
                }
                X1 = M.square().subtract(this.two(S));
                Y1 = M.multiply(S.subtract(X1)).subtract(_8T);
                Z1 = Z1.isOne() ? _2Y1 : _2Y1.multiply(Z1);
                ++i;
            }
            if (FpCurve.this.isJacobianModified) {
                return new FpPoint(X1, Y1, new ECCurve.ECElement[]{Z1, W1});
            }
            return new FpPoint(X1, Y1, new ECCurve.ECElement[]{Z1});
        }

        protected ECCurve.ECElement two(ECCurve.ECElement x) {
            return x.add(x);
        }

        protected ECCurve.ECElement three(ECCurve.ECElement x) {
            return this.two(x).add(x);
        }

        protected ECCurve.ECElement four(ECCurve.ECElement x) {
            return this.two(this.two(x));
        }

        protected ECCurve.ECElement eight(ECCurve.ECElement x) {
            return this.four(this.two(x));
        }

        protected ECCurve.ECElement calculateJacobianModifiedW(ECCurve.ECElement Z, ECCurve.ECElement ZSquared) {
            ECCurve.ECElement a4 = FpCurve.this.getA();
            if (a4.isZero() || Z.isOne()) {
                return a4;
            }
            if (ZSquared == null) {
                ZSquared = Z.square();
            }
            ECCurve.ECElement W = ZSquared.square();
            ECCurve.ECElement a4Neg = a4.negate();
            W = a4Neg.bitLength() < a4.bitLength() ? W.multiply(a4Neg).negate() : W.multiply(a4);
            return W;
        }

        protected ECCurve.ECElement getJacobianModifiedW() {
            ECCurve.ECElement W = this.zs[1];
            if (W == null) {
                this.zs[1] = W = this.calculateJacobianModifiedW(this.zs[0], null);
            }
            return W;
        }

        protected FpPoint twiceJacobianModified(boolean calculateW) {
            ECCurve.ECElement X1 = this.x;
            ECCurve.ECElement Y1 = this.y;
            ECCurve.ECElement Z1 = this.zs[0];
            ECCurve.ECElement W1 = this.getJacobianModifiedW();
            ECCurve.ECElement X1Squared = X1.square();
            ECCurve.ECElement M = this.three(X1Squared).add(W1);
            ECCurve.ECElement _2Y1 = this.two(Y1);
            ECCurve.ECElement _2Y1Squared = _2Y1.multiply(Y1);
            ECCurve.ECElement S = this.two(X1.multiply(_2Y1Squared));
            ECCurve.ECElement X3 = M.square().subtract(this.two(S));
            ECCurve.ECElement _4T = _2Y1Squared.square();
            ECCurve.ECElement _8T = this.two(_4T);
            ECCurve.ECElement Y3 = M.multiply(S.subtract(X3)).subtract(_8T);
            ECCurve.ECElement W3 = calculateW ? this.two(_8T.multiply(W1)) : null;
            ECCurve.ECElement Z3 = Z1.isOne() ? _2Y1 : _2Y1.multiply(Z1);
            return new FpPoint(X3, Y3, new ECCurve.ECElement[]{Z3, W3});
        }
    }
}

