/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp;

import java.math.BigInteger;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;

public abstract class FpCurveAbstract
extends ECCurve {
    protected final BigInteger modP;
    protected final int fieldSize;
    protected final boolean isJacobianModified;

    protected FpCurveAbstract(String PHex, boolean isJacobianModified) {
        this.isJacobianModified = isJacobianModified;
        this.modP = FpCurveAbstract.Hex2BigInt(PHex);
        this.fieldSize = this.modP.bitLength();
    }

    public final BigInteger getP() {
        return this.modP;
    }

    @Override
    protected ECCurve.ECPoint decompressPoint(int yTilde, BigInteger X1) {
        ECCurve.ECElement x = this.fromBigInteger(X1);
        ECCurve.ECElement rhs = x.square().add(this.getA()).multiply(x).add(this.getB());
        ECCurve.ECElement y = rhs.sqrt();
        Ex.MUST(y != null, "Invalid point compression");
        if (y.testBitZero() != (yTilde == 1)) {
            y = y.negate();
        }
        return this.createRawPoint(x, y);
    }

    @Override
    public final int getFieldSize() {
        return this.fieldSize;
    }

    public final int getNField() {
        return this.fieldSize + 7 >>> 3;
    }

    private ECCurve.ECElement[] getInitialZCoords() {
        ECCurve.ECElement one = this.fromBigInteger(BigInteger.ONE);
        if (this.isJacobianModified) {
            return new ECCurve.ECElement[]{one, this.getA()};
        }
        return new ECCurve.ECElement[]{one};
    }

    protected abstract class FpElementAbstract
    extends ECCurve.ECElement {
        protected FpElementAbstract() {
        }

        @Override
        public final int getFieldSize() {
            return FpCurveAbstract.this.getFieldSize();
        }
    }

    protected abstract class FpPointAbstract
    extends ECCurve.ECPoint {
        protected FpPointAbstract(ECCurve.ECElement x, ECCurve.ECElement y) {
            super(x, y, FpCurveAbstract.this.getInitialZCoords());
        }

        protected FpPointAbstract(ECCurve.ECElement x, ECCurve.ECElement y, ECCurve.ECElement[] zs) {
            super(x, y, zs);
        }

        @Override
        public ECCurve.ECPoint normalize() {
            if (this.isInfinity()) {
                return this;
            }
            ECCurve.ECElement Z1 = this.getZCoord(0);
            if (Z1.isOne()) {
                return this;
            }
            ECCurve.ECElement zInv = Z1.invert();
            ECCurve.ECElement zInv2 = zInv.square();
            ECCurve.ECElement zInv3 = zInv2.multiply(zInv);
            return FpCurveAbstract.this.createRawPoint(this.x.multiply(zInv2), this.y.multiply(zInv3));
        }

        @Override
        protected boolean getCompressionYTilde() {
            return this.getAffineYCoord().testBitZero();
        }

        @Override
        protected boolean satisfiesCurveEquation() {
            ECCurve.ECElement X = this.x;
            ECCurve.ECElement Y = this.y;
            ECCurve.ECElement A = FpCurveAbstract.this.getA();
            ECCurve.ECElement B = FpCurveAbstract.this.getB();
            ECCurve.ECElement lhs = Y.square();
            ECCurve.ECElement Z = this.zs[0];
            if (!Z.isOne()) {
                ECCurve.ECElement Z2 = Z.square();
                ECCurve.ECElement Z4 = Z2.square();
                ECCurve.ECElement Z6 = Z2.multiply(Z4);
                A = A.multiply(Z4);
                B = B.multiply(Z6);
            }
            ECCurve.ECElement rhs = X.square().add(A).multiply(X).add(B);
            return lhs.equals(rhs);
        }

        @Override
        public final ECCurve.ECPoint negate() {
            if (this.isInfinity()) {
                return this;
            }
            return this.create(this.x, this.y.negate(), this.zs);
        }
    }
}

