/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp128r1
extends CustomFpCurve {
    private static final long M = 0xFFFFFFFFL;
    private static final int ARR_LEN = 4;
    private static final int ARR_LEN2 = 8;
    private static final int[] P = new int[]{-1, -1, -1, -3};
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P3s1 = 0x7FFFFFFE;
    private static final int PExt7s1 = 0x7FFFFFFE;

    static {
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[3] = 4;
        nArray[4] = -2;
        nArray[5] = -1;
        nArray[6] = 3;
        nArray[7] = -4;
        PExt = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = -1;
        nArray2[1] = -1;
        nArray2[2] = -1;
        nArray2[3] = -5;
        nArray2[4] = 1;
        nArray2[6] = -4;
        nArray2[7] = 3;
        PExtInv = nArray2;
    }

    public Secp128r1() {
        super(P, "FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFF", 4, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.28", "FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC", "E87579C11079F43DD824993C2CEE5ED3", "FFFFFFFE0000000075A30D1B9038A115", "01", "04 161FF7528B899B2D0C28607CA52C5B86 CF5AC8395BAFEB13C02DA292DDED7A83");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long x0 = (long)xx[0] & 0xFFFFFFFFL;
        long x1 = (long)xx[1] & 0xFFFFFFFFL;
        long x2 = (long)xx[2] & 0xFFFFFFFFL;
        long x3 = (long)xx[3] & 0xFFFFFFFFL;
        long x4 = (long)xx[4] & 0xFFFFFFFFL;
        long x5 = (long)xx[5] & 0xFFFFFFFFL;
        long x6 = (long)xx[6] & 0xFFFFFFFFL;
        long x7 = (long)xx[7] & 0xFFFFFFFFL;
        x3 += x7;
        x2 += (x6 += x7 << 1);
        x1 += (x5 += x6 << 1);
        x3 += x4 << 1;
        z[0] = (int)(x0 += (x4 += x5 << 1));
        z[1] = (int)(x1 += x0 >>> 32);
        z[2] = (int)(x2 += x1 >>> 32);
        z[3] = (int)(x3 += x2 >>> 32);
        this.elReduceInt((int)(x3 >>> 32), z);
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        while (x != 0) {
            long x4 = (long)x & 0xFFFFFFFFL;
            long c = ((long)z[0] & 0xFFFFFFFFL) + x4;
            z[0] = (int)c;
            if ((c >>= 32) != 0L) {
                z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
                c >>= 32;
                z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
                c >>= 32;
            }
            z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) + (x4 << 1));
            x = (int)(c >>= 32);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(4, x, y, z);
        if (c != 0 || z[3] >>> 1 >= 0x7FFFFFFE && Nat.gte(4, z, P)) {
            this.elAddPInvTo(z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(4, x, z);
        if (c != 0 || z[3] >>> 1 >= 0x7FFFFFFE && Nat.gte(4, z, P)) {
            this.elAddPInvTo(z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(4, x, y, zz);
        if (c != 0 || zz[7] >>> 1 >= 0x7FFFFFFE && Nat.gte(8, zz, PExt)) {
            Nat.addTo(PExtInv.length, PExtInv, zz);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(4, x, y, z);
        if (c != 0) {
            this.elSubPInvFrom(z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(4, x, 0, z);
        if (c != 0 || z[3] >>> 1 >= 0x7FFFFFFE && Nat.gte(4, z, P)) {
            this.elAddPInvTo(z);
        }
    }

    private void elAddPInvTo(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) + 1L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
            c >>= 32;
            z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) + 2L);
    }

    private void elSubPInvFrom(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) - 1L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
            c >>= 32;
            z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) - 2L);
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp128r1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(128, X);
            if (this.arr[3] >>> 1 >= 0x7FFFFFFE && Nat.gte(4, this.arr, P)) {
                Nat.subFrom(4, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(4, x1) || Nat.isOne(4, x1)) {
                return this;
            }
            int[] x2 = new int[4];
            Secp128r1.this.elSquare(x1, x2);
            Secp128r1.this.elMultiply(x2, x1, x2);
            int[] x4 = new int[4];
            Secp128r1.this.elSquareN(x2, 2, x4);
            Secp128r1.this.elMultiply(x4, x2, x4);
            int[] x8 = new int[4];
            Secp128r1.this.elSquareN(x4, 4, x8);
            Secp128r1.this.elMultiply(x8, x4, x8);
            int[] x10 = x4;
            Secp128r1.this.elSquareN(x8, 2, x10);
            Secp128r1.this.elMultiply(x10, x2, x10);
            int[] x20 = x2;
            Secp128r1.this.elSquareN(x10, 10, x20);
            Secp128r1.this.elMultiply(x20, x10, x20);
            int[] x30 = x8;
            Secp128r1.this.elSquareN(x20, 10, x30);
            Secp128r1.this.elMultiply(x30, x10, x30);
            int[] x31 = x10;
            Secp128r1.this.elSquare(x30, x31);
            Secp128r1.this.elMultiply(x31, x1, x31);
            int[] t1 = x31;
            Secp128r1.this.elSquareN(t1, 95, t1);
            int[] t2 = x30;
            Secp128r1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

