/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp160r1
extends CustomFpCurve {
    private static final int ARR_LEN = 5;
    private static final int ARR_LEN2 = 10;
    private static final long M = 0xFFFFFFFFL;
    private static final int[] P = new int[]{Integer.MAX_VALUE, -1, -1, -1, -1};
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P4 = -1;
    private static final int PExt9 = -1;
    private static final int PInv = -2147483647;

    static {
        int[] nArray = new int[10];
        nArray[0] = 1;
        nArray[1] = 0x40000001;
        nArray[5] = -2;
        nArray[6] = -2;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        PExt = nArray;
        PExtInv = new int[]{-1, -1073741826, -1, -1, -1, 1, 1};
    }

    public Secp160r1() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFF", 5, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.8", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC", "1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45", "0100000000000000000001F4C8F927AED3CA752257", "01", "04 4A96B5688EF573284664698968C38BB913CBFC82 23A628553168947D59DCC912042351377AC5FB32");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long x5 = (long)xx[5] & 0xFFFFFFFFL;
        long x6 = (long)xx[6] & 0xFFFFFFFFL;
        long x7 = (long)xx[7] & 0xFFFFFFFFL;
        long x8 = (long)xx[8] & 0xFFFFFFFFL;
        long x9 = (long)xx[9] & 0xFFFFFFFFL;
        long c = 0L;
        z[0] = (int)(c += ((long)xx[0] & 0xFFFFFFFFL) + x5 + (x5 << 31));
        c >>>= 32;
        z[1] = (int)(c += ((long)xx[1] & 0xFFFFFFFFL) + x6 + (x6 << 31));
        c >>>= 32;
        z[2] = (int)(c += ((long)xx[2] & 0xFFFFFFFFL) + x7 + (x7 << 31));
        c >>>= 32;
        z[3] = (int)(c += ((long)xx[3] & 0xFFFFFFFFL) + x8 + (x8 << 31));
        c >>>= 32;
        z[4] = (int)(c += ((long)xx[4] & 0xFFFFFFFFL) + x9 + (x9 << 31));
        this.elReduceInt((int)(c >>>= 32), z);
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        if (x != 0 && Nat.mulWordsAdd(5, -2147483647, x, z) != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(5, x, y, z);
        if (c != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(5, x, z);
        if (c != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }

    @Override
    protected void elMultiply(int[] x, int[] y, int[] z) {
        int[] tt = new int[10];
        Nat.mul(5, x, y, tt);
        this.elReduce(tt, z);
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(5, x, y, zz);
        if ((c != 0 || zz[9] == -1 && Nat.gte(10, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(10, zz, PExtInv.length);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(5, x, y, z);
        if (c != 0) {
            Nat.subWordFrom(5, -2147483647, z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(5, x, 0, z);
        if (c != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.addWordTo(5, -2147483647, z);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp160r1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(160, X);
            if (this.arr[4] == -1 && Nat.gte(5, this.arr, P)) {
                Nat.subFrom(5, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(5, x1) || Nat.isOne(5, x1)) {
                return this;
            }
            int[] x2 = new int[5];
            Secp160r1.this.elSquare(x1, x2);
            Secp160r1.this.elMultiply(x2, x1, x2);
            int[] x4 = new int[5];
            Secp160r1.this.elSquareN(x2, 2, x4);
            Secp160r1.this.elMultiply(x4, x2, x4);
            int[] x8 = x2;
            Secp160r1.this.elSquareN(x4, 4, x8);
            Secp160r1.this.elMultiply(x8, x4, x8);
            int[] x16 = x4;
            Secp160r1.this.elSquareN(x8, 8, x16);
            Secp160r1.this.elMultiply(x16, x8, x16);
            int[] x32 = x8;
            Secp160r1.this.elSquareN(x16, 16, x32);
            Secp160r1.this.elMultiply(x32, x16, x32);
            int[] x64 = x16;
            Secp160r1.this.elSquareN(x32, 32, x64);
            Secp160r1.this.elMultiply(x64, x32, x64);
            int[] x128 = x32;
            Secp160r1.this.elSquareN(x64, 64, x128);
            Secp160r1.this.elMultiply(x128, x64, x128);
            int[] x129 = x64;
            Secp160r1.this.elSquare(x128, x129);
            Secp160r1.this.elMultiply(x129, x1, x129);
            int[] t1 = x129;
            Secp160r1.this.elSquareN(t1, 29, t1);
            int[] t2 = x128;
            Secp160r1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

