/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp160r2
extends CustomFpCurve {
    private static final int ARR_LEN = 5;
    private static final int ARR_LEN2 = 10;
    private static final int[] P = new int[]{-21389, -2, -1, -1, -1};
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P4 = -1;
    private static final int PExt9 = -1;
    private static final int PInv33 = 21389;

    static {
        int[] nArray = new int[10];
        nArray[0] = 457489321;
        nArray[1] = 42778;
        nArray[2] = 1;
        nArray[5] = -42778;
        nArray[6] = -3;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[9] = -1;
        PExt = nArray;
        PExtInv = new int[]{-457489321, -42779, -2, -1, -1, 42777, 2};
    }

    public Secp160r2() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73", 5, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.30", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC70", "B4E134D3FB59EB8BAB57274904664D5AF50388BA", "0100000000000000000000351EE786A818F3A1A16B", "01", "04 52DCB034293A117E1F4FF11B30F7199D3144CE6D FEAFFEF2E331F296E071FA0DF9982CFEA7D43F2E");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long cc = Nat.mul33Add(5, 21389, xx, 5, xx, 0, z, 0);
        int c = Nat.mul33DWordAdd(5, 21389, cc, z, 0);
        if (c != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.add33To(5, 21389, z);
        }
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        if (x != 0 && Nat.mul33WordAdd(5, 21389, x, z, 0) != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.add33To(5, 21389, z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(5, x, y, z);
        if (c != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.add33To(5, 21389, z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(5, x, z);
        if (c != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.add33To(5, 21389, z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(5, x, y, zz);
        if ((c != 0 || zz[9] == -1 && Nat.gte(10, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(10, zz, PExtInv.length);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(5, x, y, z);
        if (c != 0) {
            Nat.sub33From(5, 21389, z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(5, x, 0, z);
        if (c != 0 || z[4] == -1 && Nat.gte(5, z, P)) {
            Nat.add33To(5, 21389, z);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp160r2.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(160, X);
            if (this.arr[4] == -1 && Nat.gte(5, this.arr, P)) {
                Nat.subFrom(5, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(5, x1) || Nat.isOne(5, x1)) {
                return this;
            }
            int[] x2 = new int[5];
            Secp160r2.this.elSquare(x1, x2);
            Secp160r2.this.elMultiply(x2, x1, x2);
            int[] x3 = new int[5];
            Secp160r2.this.elSquare(x2, x3);
            Secp160r2.this.elMultiply(x3, x1, x3);
            int[] x4 = new int[5];
            Secp160r2.this.elSquare(x3, x4);
            Secp160r2.this.elMultiply(x4, x1, x4);
            int[] x7 = new int[5];
            Secp160r2.this.elSquareN(x4, 3, x7);
            Secp160r2.this.elMultiply(x7, x3, x7);
            int[] x14 = x4;
            Secp160r2.this.elSquareN(x7, 7, x14);
            Secp160r2.this.elMultiply(x14, x7, x14);
            int[] x17 = x7;
            Secp160r2.this.elSquareN(x14, 3, x17);
            Secp160r2.this.elMultiply(x17, x3, x17);
            int[] x31 = new int[5];
            Secp160r2.this.elSquareN(x17, 14, x31);
            Secp160r2.this.elMultiply(x31, x14, x31);
            int[] x62 = x14;
            Secp160r2.this.elSquareN(x31, 31, x62);
            Secp160r2.this.elMultiply(x62, x31, x62);
            int[] x124 = x31;
            Secp160r2.this.elSquareN(x62, 62, x124);
            Secp160r2.this.elMultiply(x124, x62, x124);
            int[] x127 = x62;
            Secp160r2.this.elSquareN(x124, 3, x127);
            Secp160r2.this.elMultiply(x127, x3, x127);
            int[] t1 = x127;
            Secp160r2.this.elSquareN(t1, 18, t1);
            Secp160r2.this.elMultiply(t1, x17, t1);
            Secp160r2.this.elSquareN(t1, 2, t1);
            Secp160r2.this.elMultiply(t1, x1, t1);
            Secp160r2.this.elSquareN(t1, 3, t1);
            Secp160r2.this.elMultiply(t1, x2, t1);
            Secp160r2.this.elSquareN(t1, 6, t1);
            Secp160r2.this.elMultiply(t1, x3, t1);
            Secp160r2.this.elSquareN(t1, 2, t1);
            Secp160r2.this.elMultiply(t1, x1, t1);
            int[] t2 = x2;
            Secp160r2.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

