/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp192k1
extends CustomFpCurve {
    private static final int ARR_LEN = 6;
    private static final int[] P = new int[]{-4553, -2, -1, -1, -1, -1};
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P5 = -1;
    private static final int PExt11 = -1;
    private static final int PInv33 = 4553;

    static {
        int[] nArray = new int[12];
        nArray[0] = 20729809;
        nArray[1] = 9106;
        nArray[2] = 1;
        nArray[6] = -9106;
        nArray[7] = -3;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        PExt = nArray;
        PExtInv = new int[]{-20729809, -9107, -2, -1, -1, -1, 9105, 2};
    }

    public Secp192k1() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFEE37", 6, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.31", "00", "03", "FFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8D", "01", "04 DB4FF10EC057E9AE26B07D0280B7F4341DA5D1B1EAE06C7D 9B2F2F6D9C5628A7844163D015BE86344082AA88D95E2F9D");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long cc = Nat.mul33Add(6, 4553, xx, 6, xx, 0, z, 0);
        int c = Nat.mul33DWordAdd(6, 4553, cc, z, 0);
        if (c != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            Nat.add33To(6, 4553, z);
        }
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        if (x != 0 && Nat.mul33WordAdd(6, 4553, x, z, 0) != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            Nat.add33To(6, 4553, z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(6, x, y, z);
        if (c != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            Nat.add33To(6, 4553, z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(6, x, z);
        if (c != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            Nat.add33To(6, 4553, z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(6, x, y, zz);
        if ((c != 0 || zz[11] == -1 && Nat.gte(12, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(12, zz, PExtInv.length);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        int c = Nat.sub(6, x, y, z);
        if (c != 0) {
            Nat.sub33From(6, 4553, z);
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(6, x, 0, z);
        if (c != 0 || z[5] == -1 && Nat.gte(6, z, P)) {
            Nat.add33To(6, 4553, z);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp192k1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(192, X);
            if (this.arr[5] == -1 && Nat.gte(6, this.arr, P)) {
                Nat.subFrom(6, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement sqrt() {
            int[] x1 = this.arr;
            if (Nat.isZero(6, x1) || Nat.isOne(6, x1)) {
                return this;
            }
            int[] x2 = new int[6];
            Secp192k1.this.elSquare(x1, x2);
            Secp192k1.this.elMultiply(x2, x1, x2);
            int[] x3 = new int[6];
            Secp192k1.this.elSquare(x2, x3);
            Secp192k1.this.elMultiply(x3, x1, x3);
            int[] x6 = new int[6];
            Secp192k1.this.elSquareN(x3, 3, x6);
            Secp192k1.this.elMultiply(x6, x3, x6);
            int[] x8 = x6;
            Secp192k1.this.elSquareN(x6, 2, x8);
            Secp192k1.this.elMultiply(x8, x2, x8);
            int[] x16 = x2;
            Secp192k1.this.elSquareN(x8, 8, x16);
            Secp192k1.this.elMultiply(x16, x8, x16);
            int[] x19 = x8;
            Secp192k1.this.elSquareN(x16, 3, x19);
            Secp192k1.this.elMultiply(x19, x3, x19);
            int[] x35 = new int[6];
            Secp192k1.this.elSquareN(x19, 16, x35);
            Secp192k1.this.elMultiply(x35, x16, x35);
            int[] x70 = x16;
            Secp192k1.this.elSquareN(x35, 35, x70);
            Secp192k1.this.elMultiply(x70, x35, x70);
            int[] x140 = x35;
            Secp192k1.this.elSquareN(x70, 70, x140);
            Secp192k1.this.elMultiply(x140, x70, x140);
            int[] x159 = x70;
            Secp192k1.this.elSquareN(x140, 19, x159);
            Secp192k1.this.elMultiply(x159, x19, x159);
            int[] t1 = x159;
            Secp192k1.this.elSquareN(t1, 20, t1);
            Secp192k1.this.elMultiply(t1, x19, t1);
            Secp192k1.this.elSquareN(t1, 4, t1);
            Secp192k1.this.elMultiply(t1, x3, t1);
            Secp192k1.this.elSquareN(t1, 6, t1);
            Secp192k1.this.elMultiply(t1, x3, t1);
            Secp192k1.this.elSquare(t1, t1);
            int[] t2 = x3;
            Secp192k1.this.elSquare(t1, t2);
            return Arrays.equals(x1, t2) ? new Element(t1) : null;
        }
    }
}

