/*
 * Decompiled with CFR 0.152.
 */
package org.denom.crypt.ec.Fp.custom;

import java.math.BigInteger;
import java.util.Arrays;
import org.denom.Ex;
import org.denom.crypt.ec.ECCurve;
import org.denom.crypt.ec.Fp.custom.CustomFpCurve;
import org.denom.crypt.ec.Nat;

public class Secp224r1
extends CustomFpCurve {
    private static final int ARR_LEN = 7;
    private static final int ARR_LEN2 = 14;
    private static final long M = 0xFFFFFFFFL;
    private static final int[] P;
    private static final int[] PExt;
    private static final int[] PExtInv;
    private static final int P6 = -1;
    private static final int PExt13 = -1;

    static {
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        P = nArray;
        int[] nArray2 = new int[14];
        nArray2[0] = 1;
        nArray2[3] = -2;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[7] = 2;
        nArray2[10] = -2;
        nArray2[11] = -1;
        nArray2[12] = -1;
        nArray2[13] = -1;
        PExt = nArray2;
        int[] nArray3 = new int[11];
        nArray3[0] = -1;
        nArray3[1] = -1;
        nArray3[2] = -1;
        nArray3[3] = 1;
        nArray3[6] = -1;
        nArray3[7] = -3;
        nArray3[8] = -1;
        nArray3[9] = -1;
        nArray3[10] = 1;
        PExtInv = nArray3;
    }

    public Secp224r1() {
        super(P, "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001", 7, false);
        super.init(new Element(), new CustomFpCurve.Point(null, null, null), "1.3.132.0.33", "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE", "B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4", "FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D", "01", "04 B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21 BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34");
    }

    @Override
    protected void elReduce(int[] xx, int[] z) {
        long xx10 = (long)xx[10] & 0xFFFFFFFFL;
        long xx11 = (long)xx[11] & 0xFFFFFFFFL;
        long xx12 = (long)xx[12] & 0xFFFFFFFFL;
        long xx13 = (long)xx[13] & 0xFFFFFFFFL;
        long n = 1L;
        long t0 = ((long)xx[7] & 0xFFFFFFFFL) + xx11 - 1L;
        long t1 = ((long)xx[8] & 0xFFFFFFFFL) + xx12;
        long t2 = ((long)xx[9] & 0xFFFFFFFFL) + xx13;
        long cc = 0L;
        long z0 = (cc += ((long)xx[0] & 0xFFFFFFFFL) - t0) & 0xFFFFFFFFL;
        cc >>= 32;
        z[1] = (int)(cc += ((long)xx[1] & 0xFFFFFFFFL) - t1);
        cc >>= 32;
        z[2] = (int)(cc += ((long)xx[2] & 0xFFFFFFFFL) - t2);
        cc >>= 32;
        long z3 = (cc += ((long)xx[3] & 0xFFFFFFFFL) + t0 - xx10) & 0xFFFFFFFFL;
        cc >>= 32;
        z[4] = (int)(cc += ((long)xx[4] & 0xFFFFFFFFL) + t1 - xx11);
        cc >>= 32;
        z[5] = (int)(cc += ((long)xx[5] & 0xFFFFFFFFL) + t2 - xx12);
        cc >>= 32;
        z[6] = (int)(cc += ((long)xx[6] & 0xFFFFFFFFL) + xx10 - xx13);
        cc >>= 32;
        z3 += ++cc;
        z[0] = (int)(z0 -= cc);
        cc = z0 >> 32;
        if (cc != 0L) {
            z[1] = (int)(cc += (long)z[1] & 0xFFFFFFFFL);
            cc >>= 32;
            z[2] = (int)(cc += (long)z[2] & 0xFFFFFFFFL);
            z3 += cc >> 32;
        }
        z[3] = (int)z3;
        cc = z3 >> 32;
        if (cc != 0L && Nat.incAt(7, z, 4) != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elReduceInt(int x, int[] z) {
        long cc = 0L;
        if (x != 0) {
            long xx07 = (long)x & 0xFFFFFFFFL;
            z[0] = (int)(cc += ((long)z[0] & 0xFFFFFFFFL) - xx07);
            if ((cc >>= 32) != 0L) {
                z[1] = (int)(cc += (long)z[1] & 0xFFFFFFFFL);
                cc >>= 32;
                z[2] = (int)(cc += (long)z[2] & 0xFFFFFFFFL);
                cc >>= 32;
            }
            z[3] = (int)(cc += ((long)z[3] & 0xFFFFFFFFL) + xx07);
            cc >>= 32;
        }
        if (cc != 0L && Nat.incAt(7, z, 4) != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elAdd(int[] x, int[] y, int[] z) {
        int c = Nat.add(7, x, y, z);
        if (c != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elAddOne(int[] x, int[] z) {
        int c = Nat.inc(7, x, z);
        if (c != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            this.addPInvTo(z);
        }
    }

    @Override
    protected void elMultiplyAddToExt(int[] x, int[] y, int[] zz) {
        int c = Nat.mulAddTo(7, x, y, zz);
        if ((c != 0 || zz[13] == -1 && Nat.gte(14, zz, PExt)) && Nat.addTo(PExtInv.length, PExtInv, zz) != 0) {
            Nat.incAt(14, zz, PExtInv.length);
        }
    }

    @Override
    protected void elSubtract(int[] x, int[] y, int[] z) {
        if (Nat.sub(7, x, y, z) != 0) {
            long c = ((long)z[0] & 0xFFFFFFFFL) + 1L;
            z[0] = (int)c;
            if ((c >>= 32) != 0L) {
                z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
                c >>= 32;
                z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
                c >>= 32;
            }
            z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) - 1L);
            if ((c >>= 32) != 0L) {
                Nat.decAt(7, z, 4);
            }
        }
    }

    @Override
    protected void elTwice(int[] x, int[] z) {
        int c = Nat.shiftUpBit(7, x, 0, z);
        if (c != 0 || z[6] == -1 && Nat.gte(7, z, P)) {
            this.addPInvTo(z);
        }
    }

    private void addPInvTo(int[] z) {
        long c = ((long)z[0] & 0xFFFFFFFFL) - 1L;
        z[0] = (int)c;
        if ((c >>= 32) != 0L) {
            z[1] = (int)(c += (long)z[1] & 0xFFFFFFFFL);
            c >>= 32;
            z[2] = (int)(c += (long)z[2] & 0xFFFFFFFFL);
            c >>= 32;
        }
        z[3] = (int)(c += ((long)z[3] & 0xFFFFFFFFL) + 1L);
        if ((c >>= 32) != 0L) {
            Nat.incAt(7, z, 4);
        }
    }

    private class Element
    extends CustomFpCurve.Element {
        private Element() {
        }

        private Element(BigInteger X) {
            Ex.MUST(X != null && X.signum() >= 0 && X.compareTo(Secp224r1.this.getP()) < 0);
            this.arr = Nat.fromBigInteger(224, X);
            if (this.arr[6] == -1 && Nat.gte(7, this.arr, P)) {
                Nat.subFrom(7, P, this.arr);
            }
        }

        private Element(int[] x) {
            this.arr = x;
        }

        @Override
        protected ECCurve.ECElement create(int[] x) {
            return new Element(x);
        }

        @Override
        public ECCurve.ECElement create(BigInteger x) {
            return new Element(x);
        }

        private boolean isSquare(int[] x) {
            int[] t1 = new int[7];
            int[] t2 = new int[7];
            Nat.copy(7, x, t1);
            int i = 0;
            while (i < 7) {
                Nat.copy(7, t1, t2);
                Secp224r1.this.elSquareN(t1, 1 << i, t1);
                Secp224r1.this.elMultiply(t1, t2, t1);
                ++i;
            }
            Secp224r1.this.elSquareN(t1, 95, t1);
            return Nat.isOne(7, t1);
        }

        private void RM(int[] nc, int[] d0, int[] e0, int[] d1, int[] e1, int[] f1, int[] t) {
            Secp224r1.this.elMultiply(e1, e0, t);
            Secp224r1.this.elMultiply(t, nc, t);
            Secp224r1.this.elMultiply(d1, d0, f1);
            Secp224r1.this.elAdd(f1, t, f1);
            Secp224r1.this.elMultiply(d1, e0, t);
            Nat.copy(7, f1, d1);
            Secp224r1.this.elMultiply(e1, d0, e1);
            Secp224r1.this.elAdd(e1, t, e1);
            Secp224r1.this.elSquare(e1, f1);
            Secp224r1.this.elMultiply(f1, nc, f1);
        }

        private void RP(int[] nc, int[] d1, int[] e1, int[] f1, int[] t) {
            Nat.copy(7, nc, f1);
            int[] d0 = new int[7];
            int[] e0 = new int[7];
            int i = 0;
            while (i < 7) {
                Nat.copy(7, d1, d0);
                Nat.copy(7, e1, e0);
                int j = 1 << i;
                while (--j >= 0) {
                    this.RS(d1, e1, f1, t);
                }
                this.RM(nc, d0, e0, d1, e1, f1, t);
                ++i;
            }
        }

        private void RS(int[] d, int[] e, int[] f, int[] t) {
            Secp224r1.this.elMultiply(e, d, e);
            Secp224r1.this.elTwice(e, e);
            Secp224r1.this.elSquare(d, t);
            Secp224r1.this.elAdd(f, t, d);
            Secp224r1.this.elMultiply(f, t, f);
            int c = Nat.shiftUpBits(7, f, 2, 0);
            Secp224r1.this.elReduceInt(c, f);
        }

        private boolean trySqrt(int[] nc, int[] r, int[] t) {
            int[] d1 = new int[7];
            Nat.copy(7, r, d1);
            int[] e1 = new int[7];
            e1[0] = 1;
            int[] f1 = new int[7];
            this.RP(nc, d1, e1, f1, t);
            int[] d0 = new int[7];
            int[] e0 = new int[7];
            int k = 1;
            while (k < 96) {
                Nat.copy(7, d1, d0);
                Nat.copy(7, e1, e0);
                this.RS(d1, e1, f1, t);
                if (Nat.isZero(7, d1)) {
                    Nat.invert(P, e0, t);
                    Secp224r1.this.elMultiply(t, d0, t);
                    return true;
                }
                ++k;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public ECCurve.ECElement sqrt() {
            c = this.arr;
            if (Nat.isZero(7, c) || Nat.isOne(7, c)) {
                return this;
            }
            nc = new int[7];
            Secp224r1.this.elNegate(c, nc);
            r = Nat.random(Secp224r1.access$0());
            t = new int[7];
            if (this.isSquare(c)) ** GOTO lbl11
            return null;
lbl-1000:
            // 1 sources

            {
                Secp224r1.this.elAddOne(r, r);
lbl11:
                // 2 sources

                ** while (!this.trySqrt((int[])nc, (int[])r, (int[])t))
            }
lbl12:
            // 1 sources

            Secp224r1.this.elSquare(t, r);
            return Arrays.equals(c, r) != false ? new Element(t) : null;
        }
    }
}

